/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFUniformShaderParameter;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFilePathString;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoShaderObject
extends SoNode {
    public final SoSFBool isActive;
    public final SoSFEnum<SourceTypes> sourceType;
    public final SoSFFilePathString sourceProgram;
    public final SoMFUniformShaderParameter parameter;

    private static native int getShaderTypeImpl(long var0);

    protected SoShaderObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.isActive = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "isActive"));
        this.sourceType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "sourceType"), SourceTypes.class);
        this.sourceProgram = ObjectManager.getManagedObjectFor(SoSFFilePathString.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "sourceProgram"));
        this.parameter = ObjectManager.getManagedObjectFor(SoMFUniformShaderParameter.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "parameter"));
    }

    static native String getClassTypeId();

    public ShaderTypes getShaderType() {
        return IntegerValuedEnumHelper.fromIntValue(ShaderTypes.class, SoShaderObject.getShaderTypeImpl(this.getNativeResourceHandle()));
    }

    public static enum SourceTypes implements IntegerValuedEnum
    {
        ARB_PROGRAM(SourceTypes.getARBPROGRAM()),
        CG_PROGRAM(SourceTypes.getCGPROGRAM()),
        GLSL_PROGRAM(SourceTypes.getGLSLPROGRAM()),
        FILENAME(SourceTypes.getFILENAME());

        private int value;

        private static native int getARBPROGRAMNative();

        private SourceTypes(int n2) {
            this.value = n2;
        }

        private static int getFILENAME() {
            JniInitializer.checkInit();
            return SourceTypes.getFILENAMENative();
        }

        private static native int getFILENAMENative();

        private static int getGLSLPROGRAM() {
            JniInitializer.checkInit();
            return SourceTypes.getGLSLPROGRAMNative();
        }

        private static native int getGLSLPROGRAMNative();

        private static int getCGPROGRAM() {
            JniInitializer.checkInit();
            return SourceTypes.getCGPROGRAMNative();
        }

        private static native int getCGPROGRAMNative();

        private static int getARBPROGRAM() {
            JniInitializer.checkInit();
            return SourceTypes.getARBPROGRAMNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static SourceTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SourceTypes.class, n);
        }
    }

    public static enum ShaderTypes implements IntegerValuedEnum
    {
        VERTEX_SHADER(ShaderTypes.getVERTEXSHADER()),
        GEOMETRY_SHADER(ShaderTypes.getGEOMETRYSHADER()),
        FRAGMENT_SHADER(ShaderTypes.getFRAGMENTSHADER()),
        TESSELLATION_CONTROL_SHADER(ShaderTypes.getTESSELLATIONCONTROLSHADER()),
        TESSELLATION_EVALUATION_SHADER(ShaderTypes.getTESSELLATIONEVALUATIONSHADER()),
        COMPUTE_SHADER(ShaderTypes.getCOMPUTESHADER());

        private int value;

        private static native int getVERTEXSHADERNative();

        private ShaderTypes(int n2) {
            this.value = n2;
        }

        private static int getCOMPUTESHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getCOMPUTESHADERNative();
        }

        private static native int getCOMPUTESHADERNative();

        private static int getTESSELLATIONEVALUATIONSHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getTESSELLATIONEVALUATIONSHADERNative();
        }

        private static native int getTESSELLATIONEVALUATIONSHADERNative();

        private static int getTESSELLATIONCONTROLSHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getTESSELLATIONCONTROLSHADERNative();
        }

        private static int getVERTEXSHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getVERTEXSHADERNative();
        }

        private static native int getGEOMETRYSHADERNative();

        private static int getGEOMETRYSHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getGEOMETRYSHADERNative();
        }

        private static native int getFRAGMENTSHADERNative();

        private static int getFRAGMENTSHADER() {
            JniInitializer.checkInit();
            return ShaderTypes.getFRAGMENTSHADERNative();
        }

        private static native int getTESSELLATIONCONTROLSHADERNative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static ShaderTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShaderTypes.class, n);
        }
    }
}

