/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoShape
extends SoNode {
    public final SoSFBool boundingBoxIgnoring;

    private static native int getShapeTypeImpl(long var0);

    private static native boolean isPrimitiveRestartAvailableImpl(long var0);

    protected SoShape(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.boundingBoxIgnoring = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShape.getFieldHandle(this.getNativeResourceHandle(), "boundingBoxIgnoring"));
    }

    static native String getClassTypeId();

    public static boolean isPrimitiveRestartAvailable() {
        return SoShape.isPrimitiveRestartAvailable(null);
    }

    public static boolean isPrimitiveRestartAvailable(SoState soState) {
        return SoShape.isPrimitiveRestartAvailableImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public ShapeTypes getShapeType() {
        return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, SoShape.getShapeTypeImpl(this.getNativeResourceHandle()));
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        POINTS(ShapeTypes.getPOINTS()),
        LINES(ShapeTypes.getLINES()),
        POLYGONS(ShapeTypes.getPOLYGONS()),
        TEXT(ShapeTypes.getTEXT());

        private int value;

        private static native int getPOINTSNative();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static int getTEXT() {
            JniInitializer.checkInit();
            return ShapeTypes.getTEXTNative();
        }

        private static native int getTEXTNative();

        private static int getPOLYGONS() {
            JniInitializer.checkInit();
            return ShapeTypes.getPOLYGONSNative();
        }

        private static native int getPOLYGONSNative();

        private static int getLINES() {
            JniInitializer.checkInit();
            return ShapeTypes.getLINESNative();
        }

        private static native int getLINESNative();

        private static int getPOINTS() {
            JniInitializer.checkInit();
            return ShapeTypes.getPOINTSNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }
    }
}

