/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoShapeHints
extends SoNode {
    public final SoSFEnum<VertexOrderings> vertexOrdering;
    public final SoSFEnum<ShapeTypes> shapeType;
    public final SoSFEnum<FaceTypes> faceType;
    public final SoSFEnum<WindingTypes> windingType;
    public final SoSFBool useVBO;
    public final SoSFFloat creaseAngle;
    public final SoSFFloat neighborTolerance;

    private static native long ctorImpl();

    private static native boolean isVBOSupportedImpl();

    protected SoShapeHints(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.vertexOrdering = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "vertexOrdering"), VertexOrderings.class);
        this.shapeType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "shapeType"), ShapeTypes.class);
        this.faceType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "faceType"), FaceTypes.class);
        this.windingType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "windingType"), WindingTypes.class);
        this.useVBO = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "useVBO"));
        this.creaseAngle = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "creaseAngle"));
        this.neighborTolerance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoShapeHints.getFieldHandle(this.getNativeResourceHandle(), "neighborTolerance"));
    }

    static native String getClassTypeId();

    public static boolean isVBOSupported() {
        return SoShapeHints.isVBOSupportedImpl();
    }

    public SoShapeHints() {
        this(Inventor.ConstructorCommand.CreateInstance, SoShapeHints.ctorImpl());
    }

    public static enum VertexOrderings implements IntegerValuedEnum
    {
        UNKNOWN_ORDERING(VertexOrderings.getUNKNOWNORDERING()),
        CLOCKWISE(VertexOrderings.getCLOCKWISE()),
        COUNTERCLOCKWISE(VertexOrderings.getCOUNTERCLOCKWISE());

        private int value;

        private static native int getUNKNOWNORDERINGNative();

        private VertexOrderings(int n2) {
            this.value = n2;
        }

        private static int getCOUNTERCLOCKWISE() {
            JniInitializer.checkInit();
            return VertexOrderings.getCOUNTERCLOCKWISENative();
        }

        private static native int getCOUNTERCLOCKWISENative();

        private static int getCLOCKWISE() {
            JniInitializer.checkInit();
            return VertexOrderings.getCLOCKWISENative();
        }

        private static native int getCLOCKWISENative();

        private static int getUNKNOWNORDERING() {
            JniInitializer.checkInit();
            return VertexOrderings.getUNKNOWNORDERINGNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static VertexOrderings valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(VertexOrderings.class, n);
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        UNKNOWN_SHAPE_TYPE(ShapeTypes.getUNKNOWNSHAPETYPE()),
        SOLID(ShapeTypes.getSOLID()),
        INNER_SOLID(ShapeTypes.getINNERSOLID());

        private int value;

        private static native int getUNKNOWNSHAPETYPENative();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static int getINNERSOLID() {
            JniInitializer.checkInit();
            return ShapeTypes.getINNERSOLIDNative();
        }

        private static native int getINNERSOLIDNative();

        private static int getSOLID() {
            JniInitializer.checkInit();
            return ShapeTypes.getSOLIDNative();
        }

        private static native int getSOLIDNative();

        private static int getUNKNOWNSHAPETYPE() {
            JniInitializer.checkInit();
            return ShapeTypes.getUNKNOWNSHAPETYPENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }
    }

    public static enum FaceTypes implements IntegerValuedEnum
    {
        UNKNOWN_FACE_TYPE(FaceTypes.getUNKNOWNFACETYPE()),
        CONVEX(FaceTypes.getCONVEX());

        private int value;

        private static native int getUNKNOWNFACETYPENative();

        private static int getUNKNOWNFACETYPE() {
            JniInitializer.checkInit();
            return FaceTypes.getUNKNOWNFACETYPENative();
        }

        private static native int getCONVEXNative();

        private static int getCONVEX() {
            JniInitializer.checkInit();
            return FaceTypes.getCONVEXNative();
        }

        private FaceTypes(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static FaceTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FaceTypes.class, n);
        }
    }

    public static enum WindingTypes implements IntegerValuedEnum
    {
        NO_WINDING_TYPE(WindingTypes.getNOWINDINGTYPE()),
        ODD_TYPE(WindingTypes.getODDTYPE()),
        NON_ZERO_TYPE(WindingTypes.getNONZEROTYPE()),
        POSITIVE_TYPE(WindingTypes.getPOSITIVETYPE()),
        NEGATIVE_TYPE(WindingTypes.getNEGATIVETYPE()),
        ABS_GEQ_TWO_TYPE(WindingTypes.getABSGEQTWOTYPE());

        private int value;

        private static native int getNOWINDINGTYPENative();

        private WindingTypes(int n2) {
            this.value = n2;
        }

        private static int getABSGEQTWOTYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getABSGEQTWOTYPENative();
        }

        private static native int getABSGEQTWOTYPENative();

        private static int getNEGATIVETYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getNEGATIVETYPENative();
        }

        private static native int getNEGATIVETYPENative();

        private static int getPOSITIVETYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getPOSITIVETYPENative();
        }

        private static int getNOWINDINGTYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getNOWINDINGTYPENative();
        }

        private static native int getODDTYPENative();

        private static int getODDTYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getODDTYPENative();
        }

        private static native int getNONZEROTYPENative();

        private static int getNONZEROTYPE() {
            JniInitializer.checkInit();
            return WindingTypes.getNONZEROTYPENative();
        }

        private static native int getPOSITIVETYPENative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static WindingTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(WindingTypes.class, n);
        }
    }
}

