/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFVec4f;
import com.openinventor.inventor.image.SbRasterImage;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoTexture
extends SoNode {
    public final SoSFEnum<InternalFormats> internalFormat;
    public final SoSFBool enableCompressedTexture;
    public final SoSFEnum<WrapType> wrapS;
    public final SoSFEnum<Models> model;
    public final SoSFColor blendColor;
    public final SoSFBool enableBorder;
    public final SoSFVec4f borderColor;
    public final SoSFFloat maxAnisotropy;
    public final SoSFEnum<Filters> minFilter;
    public final SoSFEnum<Filters> magFilter;

    private static native void setBitmapFileTypeImpl(long var0, int var2);

    private static native int getBitmapFileTypeImpl(long var0);

    private static native boolean isSupportedImpl(int var0);

    private static native long readTextureImpl(String var0, int var1);

    protected SoTexture(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.internalFormat = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "internalFormat"), InternalFormats.class);
        this.enableCompressedTexture = ObjectManager.getManagedObjectFor(SoSFBool.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "enableCompressedTexture"));
        this.wrapS = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "wrapS"), WrapType.class);
        this.model = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "model"), Models.class);
        this.blendColor = ObjectManager.getManagedObjectFor(SoSFColor.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "blendColor"));
        this.enableBorder = ObjectManager.getManagedObjectFor(SoSFBool.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "enableBorder"));
        this.borderColor = ObjectManager.getManagedObjectFor(SoSFVec4f.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "borderColor"));
        this.maxAnisotropy = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "maxAnisotropy"));
        this.minFilter = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "minFilter"), Filters.class);
        this.magFilter = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoTexture.getFieldHandle(this.getNativeResourceHandle(), "magFilter"), Filters.class);
    }

    static native String getClassTypeId();

    public static SbRasterImage readTexture(String string) {
        return SoTexture.readTexture(string, FileTypes.valueOf(FileTypes.UNKNOWN.getValue()));
    }

    public FileTypes getBitmapFileType() {
        return IntegerValuedEnumHelper.fromIntValue(FileTypes.class, SoTexture.getBitmapFileTypeImpl(this.getNativeResourceHandle()));
    }

    public static boolean isSupported(HW_Features hW_Features) {
        return SoTexture.isSupportedImpl(hW_Features.getValue());
    }

    public void setBitmapFileType(FileTypes fileTypes) {
        SoTexture.setBitmapFileTypeImpl(this.getNativeResourceHandle(), fileTypes.getValue());
    }

    public static SbRasterImage readTexture(String string, FileTypes fileTypes) {
        return ObjectManager.getManagedObjectFor(SbRasterImage.class, SoTexture.readTextureImpl(string, fileTypes.getValue()));
    }

    public static enum InternalFormats implements IntegerValuedEnum
    {
        AUTO_INTERNAL_FORMAT(InternalFormats.getAUTOINTERNALFORMAT()),
        ALPHA_FORMAT(InternalFormats.getALPHAFORMAT()),
        ALPHA4(InternalFormats.getALPHA4()),
        ALPHA8(InternalFormats.getALPHA8()),
        ALPHA12(InternalFormats.getALPHA12()),
        ALPHA16(InternalFormats.getALPHA16()),
        LUMINANCE_FORMAT(InternalFormats.getLUMINANCEFORMAT()),
        LUMINANCE4(InternalFormats.getLUMINANCE4()),
        LUMINANCE8(InternalFormats.getLUMINANCE8()),
        LUMINANCE12(InternalFormats.getLUMINANCE12()),
        LUMINANCE16(InternalFormats.getLUMINANCE16()),
        LUMINANCE_ALPHA(InternalFormats.getLUMINANCEALPHA()),
        LUMINANCE4_ALPHA4(InternalFormats.getLUMINANCE4ALPHA4()),
        LUMINANCE6_ALPHA2(InternalFormats.getLUMINANCE6ALPHA2()),
        LUMINANCE8_ALPHA8(InternalFormats.getLUMINANCE8ALPHA8()),
        LUMINANCE12_ALPHA4(InternalFormats.getLUMINANCE12ALPHA4()),
        LUMINANCE12_ALPHA12(InternalFormats.getLUMINANCE12ALPHA12()),
        LUMINANCE16_ALPHA16(InternalFormats.getLUMINANCE16ALPHA16()),
        INTENSITY_FORMAT(InternalFormats.getINTENSITYFORMAT()),
        INTENSITY4(InternalFormats.getINTENSITY4()),
        INTENSITY8(InternalFormats.getINTENSITY8()),
        INTENSITY12(InternalFormats.getINTENSITY12()),
        INTENSITY16(InternalFormats.getINTENSITY16()),
        R3_G3_B2(InternalFormats.getR3G3B2()),
        RGB_FORMAT(InternalFormats.getRGBFORMAT()),
        RGB4(InternalFormats.getRGB4()),
        RGB5(InternalFormats.getRGB5()),
        RG8(InternalFormats.getRG8()),
        RGB8(InternalFormats.getRGB8()),
        RGB10(InternalFormats.getRGB10()),
        RGB12(InternalFormats.getRGB12()),
        RGB16(InternalFormats.getRGB16()),
        RGBA_FORMAT(InternalFormats.getRGBAFORMAT()),
        RGBA2(InternalFormats.getRGBA2()),
        RGBA4(InternalFormats.getRGBA4()),
        RGB5_ALPHA1(InternalFormats.getRGB5ALPHA1()),
        RGBA8(InternalFormats.getRGBA8()),
        RGB10_ALPHA2(InternalFormats.getRGB10ALPHA2()),
        RGBA12(InternalFormats.getRGBA12()),
        RGBA16(InternalFormats.getRGBA16()),
        RGBA_FLOAT32(InternalFormats.getRGBAFLOAT32()),
        RGB_FLOAT32(InternalFormats.getRGBFLOAT32()),
        ALPHA_FLOAT32(InternalFormats.getALPHAFLOAT32()),
        INTENSITY_FLOAT32(InternalFormats.getINTENSITYFLOAT32()),
        LUMINANCE_FLOAT32(InternalFormats.getLUMINANCEFLOAT32()),
        LUMINANCE_ALPHA_FLOAT32(InternalFormats.getLUMINANCEALPHAFLOAT32()),
        RGBA_FLOAT16(InternalFormats.getRGBAFLOAT16()),
        RGB_FLOAT16(InternalFormats.getRGBFLOAT16()),
        ALPHA_FLOAT16(InternalFormats.getALPHAFLOAT16()),
        INTENSITY_FLOAT16(InternalFormats.getINTENSITYFLOAT16()),
        LUMINANCE_FLOAT16(InternalFormats.getLUMINANCEFLOAT16()),
        LUMINANCE_ALPHA_FLOAT16(InternalFormats.getLUMINANCEALPHAFLOAT16()),
        COMPRESSED_ALPHA(InternalFormats.getCOMPRESSEDALPHA()),
        COMPRESSED_LUMINANCE(InternalFormats.getCOMPRESSEDLUMINANCE()),
        COMPRESSED_LUMINANCE_ALPHA(InternalFormats.getCOMPRESSEDLUMINANCEALPHA()),
        COMPRESSED_INTENSITY(InternalFormats.getCOMPRESSEDINTENSITY()),
        COMPRESSED_RGB(InternalFormats.getCOMPRESSEDRGB()),
        COMPRESSED_RGBA(InternalFormats.getCOMPRESSEDRGBA()),
        COMPRESSED_LUMINANCE_LATC1(InternalFormats.getCOMPRESSEDLUMINANCELATC1()),
        COMPRESSED_SIGNED_LUMINANCE_LATC1(InternalFormats.getCOMPRESSEDSIGNEDLUMINANCELATC1()),
        COMPRESSED_LUMINANCE_ALPHA_LATC2(InternalFormats.getCOMPRESSEDLUMINANCEALPHALATC2()),
        COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2(InternalFormats.getCOMPRESSEDSIGNEDLUMINANCEALPHALATC2()),
        COMPRESSED_RED_RGTC1(InternalFormats.getCOMPRESSEDREDRGTC1()),
        COMPRESSED_SIGNED_RED_RGTC1(InternalFormats.getCOMPRESSEDSIGNEDREDRGTC1()),
        COMPRESSED_RED_GREEN_RGTC2(InternalFormats.getCOMPRESSEDREDGREENRGTC2()),
        COMPRESSED_SIGNED_RED_GREEN_RGTC2(InternalFormats.getCOMPRESSEDSIGNEDREDGREENRGTC2()),
        DEPTH_COMPONENT16(InternalFormats.getDEPTHCOMPONENT16()),
        DEPTH_COMPONENT24(InternalFormats.getDEPTHCOMPONENT24()),
        DEPTH24_STENCIL8(InternalFormats.getDEPTH24STENCIL8()),
        R8I(InternalFormats.getR8I()),
        R8UI(InternalFormats.getR8UI()),
        R16I(InternalFormats.getR16I()),
        R16UI(InternalFormats.getR16UI()),
        R32I(InternalFormats.getR32I()),
        R32UI(InternalFormats.getR32UI()),
        RG8I(InternalFormats.getRG8I()),
        RG8UI(InternalFormats.getRG8UI()),
        RG16I(InternalFormats.getRG16I()),
        RG16UI(InternalFormats.getRG16UI()),
        RG32I(InternalFormats.getRG32I()),
        RG32UI(InternalFormats.getRG32UI()),
        RGB8I(InternalFormats.getRGB8I()),
        RGB8UI(InternalFormats.getRGB8UI()),
        RGB16I(InternalFormats.getRGB16I()),
        RGB16UI(InternalFormats.getRGB16UI()),
        RGB32I(InternalFormats.getRGB32I()),
        RGB32UI(InternalFormats.getRGB32UI()),
        RGBA8I(InternalFormats.getRGBA8I()),
        RGBA8UI(InternalFormats.getRGBA8UI()),
        RGBA16I(InternalFormats.getRGBA16I()),
        RGBA16UI(InternalFormats.getRGBA16UI()),
        RGBA32I(InternalFormats.getRGBA32I()),
        RGBA32UI(InternalFormats.getRGBA32UI());

        private int value;

        private static native int getAUTOINTERNALFORMATNative();

        private static int getCOMPRESSEDSIGNEDREDRGTC1() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDSIGNEDREDRGTC1Native();
        }

        private static native int getCOMPRESSEDSIGNEDREDRGTC1Native();

        private static int getCOMPRESSEDREDRGTC1() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDREDRGTC1Native();
        }

        private static native int getCOMPRESSEDREDRGTC1Native();

        private static int getCOMPRESSEDSIGNEDLUMINANCEALPHALATC2() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDSIGNEDLUMINANCEALPHALATC2Native();
        }

        private static native int getCOMPRESSEDSIGNEDLUMINANCEALPHALATC2Native();

        private static int getCOMPRESSEDLUMINANCEALPHALATC2() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDLUMINANCEALPHALATC2Native();
        }

        private static native int getCOMPRESSEDLUMINANCEALPHALATC2Native();

        private static int getCOMPRESSEDSIGNEDLUMINANCELATC1() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDSIGNEDLUMINANCELATC1Native();
        }

        private static native int getCOMPRESSEDSIGNEDLUMINANCELATC1Native();

        private static native int getCOMPRESSEDREDGREENRGTC2Native();

        private static int getR8I() {
            JniInitializer.checkInit();
            return InternalFormats.getR8INative();
        }

        private static native int getR8INative();

        private static int getDEPTH24STENCIL8() {
            JniInitializer.checkInit();
            return InternalFormats.getDEPTH24STENCIL8Native();
        }

        private static native int getDEPTH24STENCIL8Native();

        private static int getDEPTHCOMPONENT24() {
            JniInitializer.checkInit();
            return InternalFormats.getDEPTHCOMPONENT24Native();
        }

        private static native int getDEPTHCOMPONENT24Native();

        private static int getDEPTHCOMPONENT16() {
            JniInitializer.checkInit();
            return InternalFormats.getDEPTHCOMPONENT16Native();
        }

        private static native int getDEPTHCOMPONENT16Native();

        private static int getCOMPRESSEDSIGNEDREDGREENRGTC2() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDSIGNEDREDGREENRGTC2Native();
        }

        private static native int getCOMPRESSEDSIGNEDREDGREENRGTC2Native();

        private static int getCOMPRESSEDREDGREENRGTC2() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDREDGREENRGTC2Native();
        }

        private static int getCOMPRESSEDLUMINANCELATC1() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDLUMINANCELATC1Native();
        }

        private static native int getCOMPRESSEDALPHANative();

        private static int getLUMINANCEALPHAFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEALPHAFLOAT16Native();
        }

        private static native int getLUMINANCEALPHAFLOAT16Native();

        private static int getLUMINANCEFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEFLOAT16Native();
        }

        private static native int getLUMINANCEFLOAT16Native();

        private static int getINTENSITYFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITYFLOAT16Native();
        }

        private static native int getINTENSITYFLOAT16Native();

        private static int getALPHAFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHAFLOAT16Native();
        }

        private static native int getALPHAFLOAT16Native();

        private static int getRGBFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBFLOAT16Native();
        }

        private static int getCOMPRESSEDALPHA() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDALPHANative();
        }

        private static native int getCOMPRESSEDLUMINANCELATC1Native();

        private static int getCOMPRESSEDRGBA() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDRGBANative();
        }

        private static native int getCOMPRESSEDRGBANative();

        private static int getCOMPRESSEDRGB() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDRGBNative();
        }

        private static native int getCOMPRESSEDRGBNative();

        private static int getCOMPRESSEDINTENSITY() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDINTENSITYNative();
        }

        private static native int getCOMPRESSEDINTENSITYNative();

        private static int getCOMPRESSEDLUMINANCEALPHA() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDLUMINANCEALPHANative();
        }

        private static native int getCOMPRESSEDLUMINANCEALPHANative();

        private static int getCOMPRESSEDLUMINANCE() {
            JniInitializer.checkInit();
            return InternalFormats.getCOMPRESSEDLUMINANCENative();
        }

        private static native int getCOMPRESSEDLUMINANCENative();

        private static native int getR8UINative();

        private static native int getRGBA8INative();

        private static int getRGB32UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB32UINative();
        }

        private static native int getRGB32UINative();

        private static int getRGB32I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB32INative();
        }

        private static native int getRGB32INative();

        private static int getRGB16UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB16UINative();
        }

        private static native int getRGB16UINative();

        private static int getRGB16I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB16INative();
        }

        private static native int getRGB16INative();

        private static int getRGB8UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB8UINative();
        }

        private static int getRGBA8I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA8INative();
        }

        private InternalFormats(int n2) {
            this.value = n2;
        }

        private static int getRGBA32UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA32UINative();
        }

        private static native int getRGBA32UINative();

        private static int getRGBA32I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA32INative();
        }

        private static native int getRGBA32INative();

        private static int getRGBA16UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA16UINative();
        }

        private static native int getRGBA16UINative();

        private static int getRGBA16I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA16INative();
        }

        private static native int getRGBA16INative();

        private static int getRGBA8UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA8UINative();
        }

        private static native int getRGBA8UINative();

        private static native int getRGB8UINative();

        private static int getRG8I() {
            JniInitializer.checkInit();
            return InternalFormats.getRG8INative();
        }

        private static native int getRG8INative();

        private static int getR32UI() {
            JniInitializer.checkInit();
            return InternalFormats.getR32UINative();
        }

        private static native int getR32UINative();

        private static int getR32I() {
            JniInitializer.checkInit();
            return InternalFormats.getR32INative();
        }

        private static native int getR32INative();

        private static int getR16UI() {
            JniInitializer.checkInit();
            return InternalFormats.getR16UINative();
        }

        private static native int getR16UINative();

        private static int getR16I() {
            JniInitializer.checkInit();
            return InternalFormats.getR16INative();
        }

        private static native int getR16INative();

        private static int getR8UI() {
            JniInitializer.checkInit();
            return InternalFormats.getR8UINative();
        }

        private static native int getRG8UINative();

        private static int getRGB8I() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB8INative();
        }

        private static native int getRGB8INative();

        private static int getRG32UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRG32UINative();
        }

        private static native int getRG32UINative();

        private static int getRG32I() {
            JniInitializer.checkInit();
            return InternalFormats.getRG32INative();
        }

        private static native int getRG32INative();

        private static int getRG16UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRG16UINative();
        }

        private static native int getRG16UINative();

        private static int getRG16I() {
            JniInitializer.checkInit();
            return InternalFormats.getRG16INative();
        }

        private static native int getRG16INative();

        private static int getRG8UI() {
            JniInitializer.checkInit();
            return InternalFormats.getRG8UINative();
        }

        private static native int getRGBFLOAT16Native();

        private static native int getLUMINANCE16ALPHA16Native();

        private static int getLUMINANCE12ALPHA12() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE12ALPHA12Native();
        }

        private static native int getLUMINANCE12ALPHA12Native();

        private static int getLUMINANCE12ALPHA4() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE12ALPHA4Native();
        }

        private static native int getLUMINANCE12ALPHA4Native();

        private static int getLUMINANCE8ALPHA8() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE8ALPHA8Native();
        }

        private static native int getLUMINANCE8ALPHA8Native();

        private static int getLUMINANCE6ALPHA2() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE6ALPHA2Native();
        }

        private static native int getLUMINANCE6ALPHA2Native();

        private static int getLUMINANCE4ALPHA4() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE4ALPHA4Native();
        }

        private static int getLUMINANCE16ALPHA16() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE16ALPHA16Native();
        }

        private static native int getR3G3B2Native();

        private static int getINTENSITY16() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITY16Native();
        }

        private static native int getINTENSITY16Native();

        private static int getINTENSITY12() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITY12Native();
        }

        private static native int getINTENSITY12Native();

        private static int getINTENSITY8() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITY8Native();
        }

        private static native int getINTENSITY8Native();

        private static int getINTENSITY4() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITY4Native();
        }

        private static native int getINTENSITY4Native();

        private static int getINTENSITYFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITYFORMATNative();
        }

        private static native int getINTENSITYFORMATNative();

        private static native int getLUMINANCE4ALPHA4Native();

        private static int getALPHA16() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHA16Native();
        }

        private static native int getALPHA16Native();

        private static int getALPHA12() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHA12Native();
        }

        private static native int getALPHA12Native();

        private static int getALPHA8() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHA8Native();
        }

        private static native int getALPHA8Native();

        private static int getALPHA4() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHA4Native();
        }

        private static native int getALPHA4Native();

        private static int getALPHAFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHAFORMATNative();
        }

        private static native int getALPHAFORMATNative();

        private static int getAUTOINTERNALFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getAUTOINTERNALFORMATNative();
        }

        private static native int getLUMINANCEFORMATNative();

        private static int getLUMINANCEALPHA() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEALPHANative();
        }

        private static native int getLUMINANCEALPHANative();

        private static int getLUMINANCE16() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE16Native();
        }

        private static native int getLUMINANCE16Native();

        private static int getLUMINANCE12() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE12Native();
        }

        private static native int getLUMINANCE12Native();

        private static int getLUMINANCE8() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE8Native();
        }

        private static native int getLUMINANCE8Native();

        private static int getLUMINANCE4() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCE4Native();
        }

        private static native int getLUMINANCE4Native();

        private static int getLUMINANCEFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEFORMATNative();
        }

        private static int getR3G3B2() {
            JniInitializer.checkInit();
            return InternalFormats.getR3G3B2Native();
        }

        private static int getRGBAFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBAFLOAT32Native();
        }

        private static native int getRGBAFLOAT32Native();

        private static int getRGBA16() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA16Native();
        }

        private static native int getRGBA16Native();

        private static int getRGBA12() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA12Native();
        }

        private static native int getRGBA12Native();

        private static int getRGB10ALPHA2() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB10ALPHA2Native();
        }

        private static native int getRGB10ALPHA2Native();

        private static int getRGBA8() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA8Native();
        }

        private static native int getRGBA8Native();

        private static native int getRGBFLOAT32Native();

        private static int getRGBAFLOAT16() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBAFLOAT16Native();
        }

        private static native int getRGBAFLOAT16Native();

        private static int getLUMINANCEALPHAFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEALPHAFLOAT32Native();
        }

        private static native int getLUMINANCEALPHAFLOAT32Native();

        private static int getLUMINANCEFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getLUMINANCEFLOAT32Native();
        }

        private static native int getLUMINANCEFLOAT32Native();

        private static int getINTENSITYFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getINTENSITYFLOAT32Native();
        }

        private static native int getINTENSITYFLOAT32Native();

        private static int getALPHAFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getALPHAFLOAT32Native();
        }

        private static native int getALPHAFLOAT32Native();

        private static int getRGBFLOAT32() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBFLOAT32Native();
        }

        private static int getRGB5ALPHA1() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB5ALPHA1Native();
        }

        private static native int getRGB10Native();

        private static int getRGB8() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB8Native();
        }

        private static native int getRGB8Native();

        private static int getRG8() {
            JniInitializer.checkInit();
            return InternalFormats.getRG8Native();
        }

        private static native int getRG8Native();

        private static int getRGB5() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB5Native();
        }

        private static native int getRGB5Native();

        private static int getRGB4() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB4Native();
        }

        private static native int getRGB4Native();

        private static int getRGBFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBFORMATNative();
        }

        private static native int getRGBFORMATNative();

        private static int getRGB10() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB10Native();
        }

        private static native int getRGB5ALPHA1Native();

        private static int getRGBA4() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA4Native();
        }

        private static native int getRGBA4Native();

        private static int getRGBA2() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBA2Native();
        }

        private static native int getRGBA2Native();

        private static int getRGBAFORMAT() {
            JniInitializer.checkInit();
            return InternalFormats.getRGBAFORMATNative();
        }

        private static native int getRGB12Native();

        private static int getRGB12() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB12Native();
        }

        private static native int getRGB16Native();

        private static int getRGB16() {
            JniInitializer.checkInit();
            return InternalFormats.getRGB16Native();
        }

        private static native int getRGBAFORMATNative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static InternalFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(InternalFormats.class, n);
        }
    }

    public static enum WrapType implements IntegerValuedEnum
    {
        REPEAT(WrapType.getREPEAT()),
        CLAMP(WrapType.getCLAMP()),
        CLAMP_TO_BORDER(WrapType.getCLAMPTOBORDER()),
        CLAMP_TO_EDGE(WrapType.getCLAMPTOEDGE()),
        MIRRORED_REPEAT(WrapType.getMIRROREDREPEAT());

        private int value;

        private static native int getREPEATNative();

        private WrapType(int n2) {
            this.value = n2;
        }

        private static int getMIRROREDREPEAT() {
            JniInitializer.checkInit();
            return WrapType.getMIRROREDREPEATNative();
        }

        private static native int getMIRROREDREPEATNative();

        private static int getCLAMPTOEDGE() {
            JniInitializer.checkInit();
            return WrapType.getCLAMPTOEDGENative();
        }

        private static native int getCLAMPTOEDGENative();

        private static int getREPEAT() {
            JniInitializer.checkInit();
            return WrapType.getREPEATNative();
        }

        private static native int getCLAMPNative();

        private static int getCLAMP() {
            JniInitializer.checkInit();
            return WrapType.getCLAMPNative();
        }

        private static native int getCLAMPTOBORDERNative();

        private static int getCLAMPTOBORDER() {
            JniInitializer.checkInit();
            return WrapType.getCLAMPTOBORDERNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static WrapType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(WrapType.class, n);
        }
    }

    public static enum Models implements IntegerValuedEnum
    {
        MODULATE(Models.getMODULATE()),
        DECAL(Models.getDECAL()),
        BLEND(Models.getBLEND()),
        REPLACE(Models.getREPLACE()),
        ADD(Models.getADD()),
        COMBINE(Models.getCOMBINE());

        private int value;

        private static native int getMODULATENative();

        private Models(int n2) {
            this.value = n2;
        }

        private static int getCOMBINE() {
            JniInitializer.checkInit();
            return Models.getCOMBINENative();
        }

        private static native int getCOMBINENative();

        private static int getADD() {
            JniInitializer.checkInit();
            return Models.getADDNative();
        }

        private static native int getADDNative();

        private static int getREPLACE() {
            JniInitializer.checkInit();
            return Models.getREPLACENative();
        }

        private static int getMODULATE() {
            JniInitializer.checkInit();
            return Models.getMODULATENative();
        }

        private static native int getDECALNative();

        private static int getDECAL() {
            JniInitializer.checkInit();
            return Models.getDECALNative();
        }

        private static native int getBLENDNative();

        private static int getBLEND() {
            JniInitializer.checkInit();
            return Models.getBLENDNative();
        }

        private static native int getREPLACENative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static Models valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Models.class, n);
        }
    }

    public static enum Filters implements IntegerValuedEnum
    {
        AUTO(Filters.getAUTO()),
        NEAREST(Filters.getNEAREST()),
        LINEAR(Filters.getLINEAR()),
        NEAREST_MIPMAP_NEAREST(Filters.getNEARESTMIPMAPNEAREST()),
        NEAREST_MIPMAP_LINEAR(Filters.getNEARESTMIPMAPLINEAR()),
        LINEAR_MIPMAP_NEAREST(Filters.getLINEARMIPMAPNEAREST()),
        LINEAR_MIPMAP_LINEAR(Filters.getLINEARMIPMAPLINEAR());

        private int value;

        private static native int getAUTONative();

        private static int getNEARESTMIPMAPLINEAR() {
            JniInitializer.checkInit();
            return Filters.getNEARESTMIPMAPLINEARNative();
        }

        private static native int getLINEARMIPMAPNEARESTNative();

        private static int getLINEARMIPMAPNEAREST() {
            JniInitializer.checkInit();
            return Filters.getLINEARMIPMAPNEARESTNative();
        }

        private static native int getLINEARMIPMAPLINEARNative();

        private static int getLINEARMIPMAPLINEAR() {
            JniInitializer.checkInit();
            return Filters.getLINEARMIPMAPLINEARNative();
        }

        private Filters(int n2) {
            this.value = n2;
        }

        private static native int getNEARESTMIPMAPLINEARNative();

        private static int getAUTO() {
            JniInitializer.checkInit();
            return Filters.getAUTONative();
        }

        private static native int getNEARESTNative();

        private static int getNEAREST() {
            JniInitializer.checkInit();
            return Filters.getNEARESTNative();
        }

        private static native int getLINEARNative();

        private static int getLINEAR() {
            JniInitializer.checkInit();
            return Filters.getLINEARNative();
        }

        private static native int getNEARESTMIPMAPNEARESTNative();

        private static int getNEARESTMIPMAPNEAREST() {
            JniInitializer.checkInit();
            return Filters.getNEARESTMIPMAPNEARESTNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Filters valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Filters.class, n);
        }
    }

    public static enum FileTypes implements IntegerValuedEnum
    {
        UNKNOWN(FileTypes.getUNKNOWN()),
        RGB(FileTypes.getRGB()),
        SGI(FileTypes.getSGI()),
        TIFF(FileTypes.getTIFF()),
        GIF(FileTypes.getGIF()),
        JPEG(FileTypes.getJPEG()),
        BMP(FileTypes.getBMP()),
        PNG(FileTypes.getPNG()),
        JPEG2000(FileTypes.getJPEG2000()),
        DDS(FileTypes.getDDS()),
        HDRI(FileTypes.getHDRI()),
        NUM_FILETYPES(FileTypes.getNUMFILETYPES());

        private int value;

        private static native int getUNKNOWNNative();

        private static native int getPNGNative();

        private static int getPNG() {
            JniInitializer.checkInit();
            return FileTypes.getPNGNative();
        }

        private static native int getJPEG2000Native();

        private static int getJPEG2000() {
            JniInitializer.checkInit();
            return FileTypes.getJPEG2000Native();
        }

        private static native int getDDSNative();

        private static int getDDS() {
            JniInitializer.checkInit();
            return FileTypes.getDDSNative();
        }

        private static native int getHDRINative();

        private static int getHDRI() {
            JniInitializer.checkInit();
            return FileTypes.getHDRINative();
        }

        private static native int getNUMFILETYPESNative();

        private static int getNUMFILETYPES() {
            JniInitializer.checkInit();
            return FileTypes.getNUMFILETYPESNative();
        }

        private FileTypes(int n2) {
            this.value = n2;
        }

        private static int getBMP() {
            JniInitializer.checkInit();
            return FileTypes.getBMPNative();
        }

        private static int getUNKNOWN() {
            JniInitializer.checkInit();
            return FileTypes.getUNKNOWNNative();
        }

        private static native int getRGBNative();

        private static int getRGB() {
            JniInitializer.checkInit();
            return FileTypes.getRGBNative();
        }

        private static native int getSGINative();

        private static int getSGI() {
            JniInitializer.checkInit();
            return FileTypes.getSGINative();
        }

        private static native int getTIFFNative();

        private static native int getBMPNative();

        private static int getJPEG() {
            JniInitializer.checkInit();
            return FileTypes.getJPEGNative();
        }

        private static native int getJPEGNative();

        private static int getGIF() {
            JniInitializer.checkInit();
            return FileTypes.getGIFNative();
        }

        private static native int getGIFNative();

        private static int getTIFF() {
            JniInitializer.checkInit();
            return FileTypes.getTIFFNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static FileTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FileTypes.class, n);
        }
    }

    public static enum HW_Features implements IntegerValuedEnum
    {
        HW_NPOT(HW_Features.getHWNPOT()),
        HW_FLOATFORMAT(HW_Features.getHWFLOATFORMAT()),
        HW_DEPTHFORMAT(HW_Features.getHWDEPTHFORMAT()),
        HW_AUTOMIPMAP(HW_Features.getHWAUTOMIPMAP()),
        HW_BORDER_CLAMP(HW_Features.getHWBORDERCLAMP()),
        HW_EDGE_CLAMP(HW_Features.getHWEDGECLAMP()),
        HW_MIRRORED_REPEAT(HW_Features.getHWMIRROREDREPEAT()),
        HW_COMPRESSION_S3TC(HW_Features.getHWCOMPRESSIONS3TC()),
        HW_COMPRESSION_LATC(HW_Features.getHWCOMPRESSIONLATC()),
        HW_COMPRESSION_RGTC(HW_Features.getHWCOMPRESSIONRGTC());

        private int value;

        private static native int getHWNPOTNative();

        private static native int getHWMIRROREDREPEATNative();

        private static int getHWMIRROREDREPEAT() {
            JniInitializer.checkInit();
            return HW_Features.getHWMIRROREDREPEATNative();
        }

        private static native int getHWCOMPRESSIONS3TCNative();

        private static int getHWCOMPRESSIONS3TC() {
            JniInitializer.checkInit();
            return HW_Features.getHWCOMPRESSIONS3TCNative();
        }

        private static native int getHWCOMPRESSIONLATCNative();

        private static int getHWCOMPRESSIONLATC() {
            JniInitializer.checkInit();
            return HW_Features.getHWCOMPRESSIONLATCNative();
        }

        private static native int getHWCOMPRESSIONRGTCNative();

        private static int getHWCOMPRESSIONRGTC() {
            JniInitializer.checkInit();
            return HW_Features.getHWCOMPRESSIONRGTCNative();
        }

        private HW_Features(int n2) {
            this.value = n2;
        }

        private static int getHWEDGECLAMP() {
            JniInitializer.checkInit();
            return HW_Features.getHWEDGECLAMPNative();
        }

        private static int getHWNPOT() {
            JniInitializer.checkInit();
            return HW_Features.getHWNPOTNative();
        }

        private static native int getHWFLOATFORMATNative();

        private static int getHWFLOATFORMAT() {
            JniInitializer.checkInit();
            return HW_Features.getHWFLOATFORMATNative();
        }

        private static native int getHWDEPTHFORMATNative();

        private static int getHWDEPTHFORMAT() {
            JniInitializer.checkInit();
            return HW_Features.getHWDEPTHFORMATNative();
        }

        private static native int getHWEDGECLAMPNative();

        private static int getHWBORDERCLAMP() {
            JniInitializer.checkInit();
            return HW_Features.getHWBORDERCLAMPNative();
        }

        private static native int getHWBORDERCLAMPNative();

        private static int getHWAUTOMIPMAP() {
            JniInitializer.checkInit();
            return HW_Features.getHWAUTOMIPMAPNative();
        }

        private static native int getHWAUTOMIPMAPNative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static HW_Features valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(HW_Features.class, n);
        }
    }
}

