/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.internal.JniInitializer;

public class SoSensor
extends Inventor {
    protected Runnable task = null;

    public void setTask(Runnable runnable) {
        this.task = runnable;
        if (runnable != null) {
            this.setTaskNativ(this.getNativeResourceHandle());
        }
    }

    private native void setTaskNativ(long var1);

    private static void notifySensor(long l) {
        SoSensor soSensor = ObjectManager.getManagedObjectFor(SoSensor.class, l);
        if (soSensor != null && soSensor.task != null) {
            try {
                soSensor.task.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static native boolean isScheduledImpl(long var0);

    private static native void unscheduleImpl(long var0);

    private static native void scheduleImpl(long var0);

    protected SoSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void unschedule() {
        SoSensor.unscheduleImpl(this.getNativeResourceHandle());
    }

    public void schedule() {
        SoSensor.scheduleImpl(this.getNativeResourceHandle());
    }

    public boolean isScheduled() {
        return SoSensor.isScheduledImpl(this.getNativeResourceHandle());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

