/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public interface SiRenderArea {
    public SbEventHandler<RenderEventArg> onStartRender();

    public SoNode getSceneGraph();

    public RenderStatus render();

    public void setClearPolicy(ClearPolicies var1);

    public SbVec2i32 getSize();

    public ClearPolicies getClearPolicy();

    public void setSize(SbVec2i32 var1);

    public void setClearColor(SbColorRGBA var1);

    public float getClearDepth();

    public SbColorRGBA getClearColor();

    public void setClearDepth(float var1);

    public void setSceneGraph(SoNode var1);

    public static class RenderEventArg
    extends Inventor
    implements SbEventArg {
        private static native SiRenderArea getSourceImpl(long var0);

        private static long ctorImplIntermediate(SiRenderArea siRenderArea) {
            if (!Inventor.class.isAssignableFrom(siRenderArea.getClass())) {
                throw new UnsupportedOperationException();
            }
            return RenderEventArg.ctorImpl(siRenderArea != null ? ((Inventor)((Object)siRenderArea)).getNativeResourceHandle() : Inventor.ZeroHandle);
        }

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected RenderEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        public SiRenderArea getSource() {
            return RenderEventArg.getSourceImpl(this.getNativeResourceHandle());
        }

        public RenderEventArg(SiRenderArea siRenderArea) {
            this(Inventor.ConstructorCommand.CreateInstance, RenderEventArg.ctorImplIntermediate(siRenderArea));
        }

        public void setValue(RenderEventArg renderEventArg) {
            RenderEventArg.setValueImpl(this.getNativeResourceHandle(), renderEventArg.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static enum RenderStatus implements IntegerValuedEnum
    {
        ABORTED(RenderStatus.getABORTED()),
        INTERACTIVE(RenderStatus.getINTERACTIVE()),
        STILL(RenderStatus.getSTILL());

        private int value;

        private static native int getABORTEDNative();

        private RenderStatus(int n2) {
            this.value = n2;
        }

        private static int getSTILL() {
            JniInitializer.checkInit();
            return RenderStatus.getSTILLNative();
        }

        private static native int getSTILLNative();

        private static int getINTERACTIVE() {
            JniInitializer.checkInit();
            return RenderStatus.getINTERACTIVENative();
        }

        private static native int getINTERACTIVENative();

        private static int getABORTED() {
            JniInitializer.checkInit();
            return RenderStatus.getABORTEDNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static RenderStatus valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderStatus.class, n);
        }
    }

    public static enum ClearPolicies implements IntegerValuedEnum
    {
        NONE(ClearPolicies.getNONE()),
        COLORBUFFER(ClearPolicies.getCOLORBUFFER()),
        DEPTHBUFFER(ClearPolicies.getDEPTHBUFFER()),
        COLORBUFFER_AND_DEPTHBUFFER(ClearPolicies.getCOLORBUFFERANDDEPTHBUFFER());

        private int value;

        private static native int getNONENative();

        private ClearPolicies(int n2) {
            this.value = n2;
        }

        private static int getCOLORBUFFERANDDEPTHBUFFER() {
            JniInitializer.checkInit();
            return ClearPolicies.getCOLORBUFFERANDDEPTHBUFFERNative();
        }

        private static native int getCOLORBUFFERANDDEPTHBUFFERNative();

        private static int getDEPTHBUFFER() {
            JniInitializer.checkInit();
            return ClearPolicies.getDEPTHBUFFERNative();
        }

        private static native int getDEPTHBUFFERNative();

        private static int getCOLORBUFFER() {
            JniInitializer.checkInit();
            return ClearPolicies.getCOLORBUFFERNative();
        }

        private static native int getCOLORBUFFERNative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return ClearPolicies.getNONENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ClearPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ClearPolicies.class, n);
        }
    }
}

