/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshvizxlm.internal;

import com.openinventor.inventor.SbVec3d;

public class MbMatrix3d {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private double m20;
    private double m21;
    private double m22;

    public MbMatrix3d(SbVec3d a1, SbVec3d a2, SbVec3d a3) {
        this.m00 = a1.getX();
        this.m01 = a1.getY();
        this.m02 = a1.getZ();
        this.m10 = a2.getX();
        this.m11 = a2.getY();
        this.m12 = a2.getZ();
        this.m20 = a3.getX();
        this.m21 = a3.getY();
        this.m22 = a3.getZ();
    }

    public MbMatrix3d(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
    }

    public double det() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public double[] multVecMatrix(double[] vec) {
        double[] res = new double[]{vec[0] * this.m00 + vec[1] * this.m10 + vec[2] * this.m20, vec[0] * this.m01 + vec[1] * this.m11 + vec[2] * this.m21, vec[0] * this.m02 + vec[1] * this.m12 + vec[2] * this.m22};
        return res;
    }

    public double[] multVecMatrix(double vecX, double vecY, double vecZ) {
        double[] res = new double[]{vecX * this.m00 + vecY * this.m10 + vecZ * this.m20, vecX * this.m01 + vecY * this.m11 + vecZ * this.m21, vecX * this.m02 + vecY * this.m12 + vecZ * this.m22};
        return res;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 1.0 && this.m02 == 1.0 && this.m10 == 1.0 && this.m11 == 1.0 && this.m12 == 1.0 && this.m20 == 1.0 && this.m21 == 1.0 && this.m22 == 1.0;
    }

    public void inverse() {
        if (this.isIdentity()) {
            return;
        }
        double pos = 0.0;
        double neg = 0.0;
        double m00m11 = this.m00 * this.m11;
        double m01m12 = this.m01 * this.m12;
        double m02m10 = this.m02 * this.m10;
        double m02m11 = this.m02 * this.m11;
        double m01m10 = this.m01 * this.m10;
        double m00m12 = this.m00 * this.m12;
        double temp = m00m11 * this.m22;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        temp = m01m12 * this.m20;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        temp = m02m10 * this.m21;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        temp = -m02m11 * this.m20;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        temp = -m01m10 * this.m22;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        temp = -m00m12 * this.m21;
        if (temp > 0.0) {
            pos += temp;
        } else {
            neg += temp;
        }
        double det1 = pos + neg;
        temp = det1 / (pos - neg);
        if (Math.abs(temp) < 1.0E-15) {
            return;
        }
        det1 = 1.0 / det1;
        double out00 = (this.m11 * this.m22 - this.m12 * this.m21) * det1;
        double out01 = -(this.m01 * this.m22 - this.m02 * this.m21) * det1;
        double out02 = (m01m12 - m02m11) * det1;
        double out10 = -(this.m10 * this.m22 - this.m12 * this.m20) * det1;
        double out11 = (this.m00 * this.m22 - this.m02 * this.m20) * det1;
        double out12 = -(m00m12 - m02m10) * det1;
        double out20 = (this.m10 * this.m21 - this.m11 * this.m20) * det1;
        double out21 = -(this.m00 * this.m21 - this.m01 * this.m20) * det1;
        double out22 = (m00m11 - m01m10) * det1;
        this.m00 = out00;
        this.m01 = out01;
        this.m02 = out02;
        this.m10 = out10;
        this.m11 = out11;
        this.m12 = out12;
        this.m20 = out20;
        this.m21 = out21;
        this.m22 = out22;
    }

    public static double getDeterminant(double c1x, double c1y, double c1z, double c2x, double c2y, double c2z, double c3x, double c3y, double c3z) {
        return c1x * c2y * c3z + c2x * c3y * c1z + c3x * c1y * c2z - c1x * c3y * c2z - c2x * c1y * c3z - c3x * c2y * c1z;
    }
}

