/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.ldm.SoLDMTileID;
import com.openinventor.ldm.internal.JarInitializer;
import com.openinventor.ldm.internal.JniInitializer;
import com.openinventor.ldm.nodes.SoDataSet;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoLDMDataAccess
extends Inventor {
    public SoLDMDataAccess() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMDataAccess.ctorImpl());
    }

    private static native long ctorImpl();

    public void endRequest(int n) {
        throw new RuntimeException("An asynchronous access has been made using first class SoLDMDataAccess. Please implement your own, overloading endRequest method.");
    }

    private static void invokeEndRequest(long l, int n) {
        SoLDMDataAccess soLDMDataAccess = (SoLDMDataAccess)ObjectManager.getManagedObjectFor(SoLDMDataAccess.class, (Long)l);
        soLDMDataAccess.endRequest(n);
    }

    public DataInfoBox getData(int n, SbBox3i32 sbBox3i32) {
        return this.getData(n, sbBox3i32, (SoBufferObject)null);
    }

    public DataInfoBox getData(int n, SbBox3i32 sbBox3i32, SoBufferObject soBufferObject) {
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.getDataBoxNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, nArray, lArray, sbVec3i32.array);
        DataInfoBox dataInfoBox = new DataInfoBox(this);
        dataInfoBox.errorFlag = nArray[0];
        dataInfoBox.bufferSize = lArray[0];
        dataInfoBox.bufferDimension = sbVec3i32;
        return dataInfoBox;
    }

    private native void getDataBoxNativ(long var1, int var3, int[] var4, long var5, int[] var7, long[] var8, int[] var9);

    @Deprecated(since="9.4")
    public DataInfoBox getData(int n, SbBox3i32 sbBox3i32, ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            if (!byteBuffer.isDirect()) {
                throw new IllegalArgumentException("Not a direct buffer.");
            }
            if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
                throw new IllegalArgumentException("Buffer endian different from native endian.");
            }
        }
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.getDataBoxNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, byteBuffer, nArray, lArray, sbVec3i32.array);
        DataInfoBox dataInfoBox = new DataInfoBox(this);
        dataInfoBox.errorFlag = nArray[0];
        dataInfoBox.bufferSize = lArray[0];
        dataInfoBox.bufferDimension = sbVec3i32;
        return dataInfoBox;
    }

    private native void getDataBoxNativ(long var1, int var3, int[] var4, Buffer var5, int[] var6, long[] var7, int[] var8);

    public DataInfoPlane getData(int n, SbBox3i32 sbBox3i32, SbPlane sbPlane) {
        return this.getData(n, sbBox3i32, sbPlane, (SoBufferObject)null);
    }

    public DataInfoPlane getData(int n, SbBox3i32 sbBox3i32, SbPlane sbPlane, SoBufferObject soBufferObject) {
        int n2;
        int[] nArray = new int[4];
        long[] lArray = new long[1];
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[18];
        this.getDataPlaneNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbPlane.array, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, nArray, lArray, sbVec2i32.array, nArray2, nArray3);
        DataInfoPlane dataInfoPlane = new DataInfoPlane(this);
        dataInfoPlane.errorFlag = nArray[0];
        dataInfoPlane.bufferSize = lArray[0];
        dataInfoPlane.numPolygonPoints = nArray[1];
        dataInfoPlane.uAxis = nArray[2];
        dataInfoPlane.vAxis = nArray[3];
        dataInfoPlane.bufferDimension = sbVec2i32;
        dataInfoPlane.polygonCoord = new SbVec3i32[dataInfoPlane.numPolygonPoints];
        for (n2 = 0; n2 < dataInfoPlane.numPolygonPoints; ++n2) {
            dataInfoPlane.polygonCoord[n2] = new SbVec3i32();
            dataInfoPlane.polygonCoord[n2].setValue(nArray3[3 * n2], nArray3[3 * n2 + 1], nArray3[3 * n2 + 2]);
        }
        dataInfoPlane.quadCoord = new SbVec3i32[4];
        for (n2 = 0; n2 < 4; ++n2) {
            dataInfoPlane.quadCoord[n2] = new SbVec3i32();
            dataInfoPlane.quadCoord[n2].setValue(nArray2[3 * n2], nArray2[3 * n2 + 1], nArray2[3 * n2 + 2]);
        }
        return dataInfoPlane;
    }

    private native void getDataPlaneNativ(long var1, int var3, int[] var4, float[] var5, long var6, int[] var8, long[] var9, int[] var10, int[] var11, int[] var12);

    @Deprecated(since="9.4")
    public DataInfoPlane getData(int n, SbBox3i32 sbBox3i32, SbPlane sbPlane, ByteBuffer byteBuffer) {
        int n2;
        if (byteBuffer != null) {
            if (!byteBuffer.isDirect()) {
                throw new IllegalArgumentException("Not a direct buffer.");
            }
            if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
                throw new IllegalArgumentException("Buffer endian different from native endian.");
            }
        }
        int[] nArray = new int[4];
        long[] lArray = new long[1];
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[18];
        this.getDataPlaneNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbPlane.array, byteBuffer, nArray, lArray, sbVec2i32.array, nArray2, nArray3);
        DataInfoPlane dataInfoPlane = new DataInfoPlane(this);
        dataInfoPlane.errorFlag = nArray[0];
        dataInfoPlane.bufferSize = lArray[0];
        dataInfoPlane.numPolygonPoints = nArray[1];
        dataInfoPlane.uAxis = nArray[2];
        dataInfoPlane.vAxis = nArray[3];
        dataInfoPlane.bufferDimension = sbVec2i32;
        dataInfoPlane.polygonCoord = new SbVec3i32[dataInfoPlane.numPolygonPoints];
        for (n2 = 0; n2 < dataInfoPlane.numPolygonPoints; ++n2) {
            dataInfoPlane.polygonCoord[n2] = new SbVec3i32();
            dataInfoPlane.polygonCoord[n2].setValue(nArray3[3 * n2], nArray3[3 * n2 + 1], nArray3[3 * n2 + 2]);
        }
        dataInfoPlane.quadCoord = new SbVec3i32[4];
        for (n2 = 0; n2 < 4; ++n2) {
            dataInfoPlane.quadCoord[n2] = new SbVec3i32();
            dataInfoPlane.quadCoord[n2].setValue(nArray2[3 * n2], nArray2[3 * n2 + 1], nArray2[3 * n2 + 2]);
        }
        return dataInfoPlane;
    }

    private native void getDataPlaneNativ(long var1, int var3, int[] var4, float[] var5, Buffer var6, int[] var7, long[] var8, int[] var9, int[] var10, int[] var11);

    public DataInfoLine getData(int n, SbBox3i32 sbBox3i32, SbLine sbLine) {
        return this.getData(n, sbBox3i32, sbLine, (SoBufferObject)null);
    }

    public DataInfoLine getData(int n, SbBox3i32 sbBox3i32, SbLine sbLine, SoBufferObject soBufferObject) {
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        int[] nArray2 = new int[6];
        this.getDataLineNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbLine.array, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, nArray, lArray, nArray2);
        DataInfoLine dataInfoLine = new DataInfoLine(this);
        dataInfoLine.errorFlag = nArray[0];
        dataInfoLine.bufferSize = lArray[0];
        dataInfoLine.bufferDimension = nArray[1];
        dataInfoLine.lineCoord = new SbVec3i32[2];
        for (int i = 0; i < 2; ++i) {
            dataInfoLine.lineCoord[i] = new SbVec3i32();
            dataInfoLine.lineCoord[i].setValue(nArray2[3 * i], nArray2[3 * i + 1], nArray2[3 * i + 2]);
        }
        return dataInfoLine;
    }

    private native void getDataLineNativ(long var1, int var3, int[] var4, float[] var5, long var6, int[] var8, long[] var9, int[] var10);

    @Deprecated(since="9.4")
    public DataInfoLine getData(int n, SbBox3i32 sbBox3i32, SbLine sbLine, ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            if (!byteBuffer.isDirect()) {
                throw new IllegalArgumentException("Not a direct buffer.");
            }
            if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
                throw new IllegalArgumentException("Buffer endian different from native endian.");
            }
        }
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        int[] nArray2 = new int[6];
        this.getDataLineNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbLine.array, byteBuffer, nArray, lArray, nArray2);
        DataInfoLine dataInfoLine = new DataInfoLine(this);
        dataInfoLine.errorFlag = nArray[0];
        dataInfoLine.bufferSize = lArray[0];
        dataInfoLine.bufferDimension = nArray[1];
        dataInfoLine.lineCoord = new SbVec3i32[2];
        for (int i = 0; i < 2; ++i) {
            dataInfoLine.lineCoord[i] = new SbVec3i32();
            dataInfoLine.lineCoord[i].setValue(nArray2[3 * i], nArray2[3 * i + 1], nArray2[3 * i + 2]);
        }
        return dataInfoLine;
    }

    private native void getDataLineNativ(long var1, int var3, int[] var4, float[] var5, Buffer var6, int[] var7, long[] var8, int[] var9);

    public DataInfoTrace getData(int n, SbBox3i32 sbBox3i32, SbVec2i32 sbVec2i32) {
        return this.getData(n, sbBox3i32, sbVec2i32, (SoBufferObject)null);
    }

    public DataInfoTrace getData(int n, SbBox3i32 sbBox3i32, SbVec2i32 sbVec2i32, SoBufferObject soBufferObject) {
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        this.getDataTraceNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbVec2i32.array, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, nArray, lArray);
        DataInfoTrace dataInfoTrace = new DataInfoTrace(this);
        dataInfoTrace.errorFlag = nArray[0];
        dataInfoTrace.bufferSize = lArray[0];
        dataInfoTrace.bufferDimension = nArray[1];
        return dataInfoTrace;
    }

    private native void getDataTraceNativ(long var1, int var3, int[] var4, int[] var5, long var6, int[] var8, long[] var9);

    @Deprecated(since="9.4")
    public DataInfoTrace getData(int n, SbBox3i32 sbBox3i32, SbVec2i32 sbVec2i32, ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            if (!byteBuffer.isDirect()) {
                throw new IllegalArgumentException("Not a direct buffer.");
            }
            if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
                throw new IllegalArgumentException("Buffer endian different from native endian.");
            }
        }
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        this.getDataTraceNativ((long)this.getNativeResourceHandle(), n, sbBox3i32.array, sbVec2i32.array, byteBuffer, nArray, lArray);
        DataInfoTrace dataInfoTrace = new DataInfoTrace(this);
        dataInfoTrace.errorFlag = nArray[0];
        dataInfoTrace.bufferSize = lArray[0];
        dataInfoTrace.bufferDimension = nArray[1];
        return dataInfoTrace;
    }

    private native void getDataTraceNativ(long var1, int var3, int[] var4, int[] var5, Buffer var6, int[] var7, long[] var8);

    public DataInfo getData(int n, SbVec3i32 sbVec3i32) {
        int[] nArray = new int[2];
        SbVec3i32 sbVec3i322 = new SbVec3i32();
        SbVec3i32 sbVec3i323 = new SbVec3i32();
        SbVec3i32 sbVec3i324 = new SbVec3i32();
        SoLDMTileID soLDMTileID = new SoLDMTileID(0L);
        DataInfo dataInfo = new DataInfo(this);
        dataInfo.tileData = this.getDataNativ(this.getNativeResourceHandle(), n, sbVec3i32.array, nArray, sbVec3i322.array, sbVec3i323.array, sbVec3i324.array, soLDMTileID.getNativeResourceHandle());
        dataInfo.tileData.order(ByteOrder.nativeOrder());
        dataInfo.errorFlag = nArray[0];
        dataInfo.tileID = soLDMTileID;
        dataInfo.tileDimension = sbVec3i322;
        dataInfo.tilePosition = new SbBox3i32();
        dataInfo.tilePosition.setBounds(sbVec3i323, sbVec3i324);
        return dataInfo;
    }

    private native ByteBuffer getDataNativ(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, long var9);

    public DataInfoBox getRequestedDataBox(int n) {
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.getRequestedDataBoxNativ(this.getNativeResourceHandle(), n, nArray, lArray, sbVec3i32.array);
        DataInfoBox dataInfoBox = new DataInfoBox(this);
        dataInfoBox.errorFlag = nArray[0];
        dataInfoBox.bufferSize = lArray[0];
        dataInfoBox.bufferDimension = sbVec3i32;
        return dataInfoBox;
    }

    private native void getRequestedDataBoxNativ(long var1, int var3, int[] var4, long[] var5, int[] var6);

    public DataInfoLine getRequestedDataLine(int n) {
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        int[] nArray2 = new int[6];
        this.getRequestedDataLineNativ(this.getNativeResourceHandle(), n, nArray, lArray, nArray2);
        DataInfoLine dataInfoLine = new DataInfoLine(this);
        dataInfoLine.errorFlag = nArray[0];
        dataInfoLine.bufferSize = lArray[0];
        dataInfoLine.bufferDimension = nArray[1];
        dataInfoLine.lineCoord = new SbVec3i32[2];
        for (int i = 0; i < 2; ++i) {
            dataInfoLine.lineCoord[i] = new SbVec3i32();
            dataInfoLine.lineCoord[i].setValue(nArray2[3 * i], nArray2[3 * i + 1], nArray2[3 * i + 2]);
        }
        return dataInfoLine;
    }

    private native void getRequestedDataLineNativ(long var1, int var3, int[] var4, long[] var5, int[] var6);

    public DataInfoPlane getRequestedDataPlane(int n) {
        int n2;
        int[] nArray = new int[4];
        long[] lArray = new long[1];
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[18];
        this.getRequestedDataPlaneNativ(this.getNativeResourceHandle(), n, nArray, lArray, sbVec2i32.array, nArray2, nArray3);
        DataInfoPlane dataInfoPlane = new DataInfoPlane(this);
        dataInfoPlane.errorFlag = nArray[0];
        dataInfoPlane.bufferSize = lArray[0];
        dataInfoPlane.numPolygonPoints = nArray[1];
        dataInfoPlane.uAxis = nArray[2];
        dataInfoPlane.vAxis = nArray[3];
        dataInfoPlane.bufferDimension = sbVec2i32;
        dataInfoPlane.polygonCoord = new SbVec3i32[dataInfoPlane.numPolygonPoints];
        for (n2 = 0; n2 < dataInfoPlane.numPolygonPoints; ++n2) {
            dataInfoPlane.polygonCoord[n2] = new SbVec3i32();
            dataInfoPlane.polygonCoord[n2].setValue(nArray3[3 * n2], nArray3[3 * n2 + 1], nArray3[3 * n2 + 2]);
        }
        dataInfoPlane.quadCoord = new SbVec3i32[4];
        for (n2 = 0; n2 < 4; ++n2) {
            dataInfoPlane.quadCoord[n2] = new SbVec3i32();
            dataInfoPlane.quadCoord[n2].setValue(nArray2[3 * n2], nArray2[3 * n2 + 1], nArray2[3 * n2 + 2]);
        }
        return dataInfoPlane;
    }

    private native void getRequestedDataPlaneNativ(long var1, int var3, int[] var4, long[] var5, int[] var6, int[] var7, int[] var8);

    public DataInfoTrace getRequestedDataTrace(int n) {
        int[] nArray = new int[2];
        long[] lArray = new long[1];
        this.getRequestedDataTraceNativ(this.getNativeResourceHandle(), n, nArray, lArray);
        DataInfoTrace dataInfoTrace = new DataInfoTrace(this);
        dataInfoTrace.errorFlag = nArray[0];
        dataInfoTrace.bufferSize = lArray[0];
        dataInfoTrace.bufferDimension = nArray[1];
        return dataInfoTrace;
    }

    private native void getRequestedDataTraceNativ(long var1, int var3, int[] var4, long[] var5);

    private static native void voxelToXYZImpl1(long var0, int[] var2, float[] var3);

    private static native int requestDataImpl1(long var0, int var2, int[] var3, float[] var4, long var5);

    private static native int requestDataImpl(long var0, int var2, int[] var3, long var4);

    private static native boolean isTileUniformImpl(long var0, int var2, int[] var3, double[] var4);

    private static native int requestDataImpl2(long var0, int var2, int[] var3, float[] var4, long var5);

    private static native void voxelToXYZImpl(long var0, int[] var2, float[] var3);

    private static native void XYZToVoxelImpl(long var0, float[] var2, int[] var3);

    private static native void XYZToVoxelImpl1(long var0, float[] var2, int[] var3);

    private static native int requestDataImpl4(long var0, int var2, int[] var3, int[] var4, long var5);

    private static native boolean setGetDataModeImpl(long var0, int var2);

    private static native int getGetDataModeImpl(long var0);

    private static native int requestDataImpl3(long var0, int var2, int[] var3, int var4, Object[] var5, long var6);

    private static native long getDataSetImpl(long var0);

    private static native void setDataSetImpl(long var0, long var2);

    private static native void releaseDataImpl(long var0, long var2);

    protected SoLDMDataAccess(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public SbBox3i32 XYZToVoxel(SbBox3f sbBox3f) {
        SbBox3i32 sbBox3i32 = new SbBox3i32();
        SoLDMDataAccess.XYZToVoxelImpl1(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null, sbBox3i32.array);
        return sbBox3i32;
    }

    public int requestData(int n, SbBox3i32 sbBox3i32, SbVec2i32 sbVec2i32, SoBufferObject soBufferObject) {
        return SoLDMDataAccess.requestDataImpl4(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null, sbVec2i32 != null ? sbVec2i32.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoDataSet getDataSet() {
        return (SoDataSet)ObjectManager.getManagedObjectFor(SoDataSet.class, (Long)SoLDMDataAccess.getDataSetImpl(this.getNativeResourceHandle()));
    }

    public void setDataSet(SoDataSet soDataSet) {
        SoLDMDataAccess.setDataSetImpl(this.getNativeResourceHandle(), soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public GetDataModes getGetDataMode() {
        return (GetDataModes)IntegerValuedEnumHelper.fromIntValue(GetDataModes.class, (int)SoLDMDataAccess.getGetDataModeImpl(this.getNativeResourceHandle()));
    }

    public SbVec3f voxelToXYZ(SbVec3i32 sbVec3i32) {
        SbVec3f sbVec3f = new SbVec3f();
        SoLDMDataAccess.voxelToXYZImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbVec3f.array);
        return sbVec3f;
    }

    public void releaseData(SoLDMTileID soLDMTileID) {
        SoLDMDataAccess.releaseDataImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbVec3i32 XYZToVoxel(SbVec3f sbVec3f) {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        SoLDMDataAccess.XYZToVoxelImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbVec3i32.array);
        return sbVec3i32;
    }

    public int requestData(int n, SbBox3i32 sbBox3i32, SbVec3i32[] sbVec3i32Array, SoBufferObject soBufferObject) {
        return SoLDMDataAccess.requestDataImpl3(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null, sbVec3i32Array != null ? sbVec3i32Array.length : 0, sbVec3i32Array, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public int requestData(int n, SbBox3i32 sbBox3i32, SbLine sbLine, SoBufferObject soBufferObject) {
        return SoLDMDataAccess.requestDataImpl2(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null, sbLine != null ? sbLine.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public boolean setGetDataMode(GetDataModes getDataModes) {
        return SoLDMDataAccess.setGetDataModeImpl(this.getNativeResourceHandle(), getDataModes.getValue());
    }

    public int requestData(int n, SbBox3i32 sbBox3i32, SbPlane sbPlane, SoBufferObject soBufferObject) {
        return SoLDMDataAccess.requestDataImpl1(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null, sbPlane != null ? sbPlane.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public int requestData(int n, SbBox3i32 sbBox3i32, SoBufferObject soBufferObject) {
        return SoLDMDataAccess.requestDataImpl(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public double isTileUniform(int n, SbVec3i32 sbVec3i32) {
        double[] dArray = new double[1];
        boolean bl = false;
        bl = SoLDMDataAccess.isTileUniformImpl(this.getNativeResourceHandle(), n, sbVec3i32 != null ? sbVec3i32.array : null, dArray);
        if (bl) {
            return dArray[0];
        }
        return 0.0;
    }

    public SbBox3f voxelToXYZ(SbBox3i32 sbBox3i32) {
        SbBox3f sbBox3f = new SbBox3f();
        SoLDMDataAccess.voxelToXYZImpl1(this.getNativeResourceHandle(), sbBox3i32 != null ? sbBox3i32.array : null, sbBox3f.array);
        return sbBox3f;
    }

    static {
        JarInitializer.checkInit();
    }

    public class DataInfoBox {
        public int errorFlag;
        public long bufferSize;
        public SbVec3i32 bufferDimension;

        public DataInfoBox(SoLDMDataAccess soLDMDataAccess) {
        }
    }

    public class DataInfoPlane {
        public int errorFlag;
        public long bufferSize;
        public SbVec2i32 bufferDimension;
        public int numPolygonPoints;
        public SbVec3i32[] polygonCoord;
        public SbVec3i32[] quadCoord;
        public int uAxis;
        public int vAxis;

        public DataInfoPlane(SoLDMDataAccess soLDMDataAccess) {
        }
    }

    public class DataInfoLine {
        public int errorFlag;
        public long bufferSize;
        public int bufferDimension;
        public SbVec3i32[] lineCoord;

        public DataInfoLine(SoLDMDataAccess soLDMDataAccess) {
        }
    }

    public class DataInfoTrace {
        public int errorFlag;
        public long bufferSize;
        public int bufferDimension;

        public DataInfoTrace(SoLDMDataAccess soLDMDataAccess) {
        }
    }

    public class DataInfo {
        public int errorFlag;
        public SoLDMTileID tileID;
        public ByteBuffer tileData;
        public SbVec3i32 tileDimension;
        public SbBox3i32 tilePosition;

        public DataInfo(SoLDMDataAccess soLDMDataAccess) {
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum GetDataModes implements IntegerValuedEnum
    {
        CACHE(GetDataModes.getCACHE()),
        DIRECT(GetDataModes.getDIRECT()),
        DIRECT_AND_PREFETCH(GetDataModes.getDIRECTANDPREFETCH());

        private int value;

        private static native int getCACHENative();

        private GetDataModes(int n2) {
            this.value = n2;
        }

        private static int getDIRECTANDPREFETCH() {
            JniInitializer.checkInit();
            return GetDataModes.getDIRECTANDPREFETCHNative();
        }

        private static native int getDIRECTANDPREFETCHNative();

        private static int getDIRECT() {
            JniInitializer.checkInit();
            return GetDataModes.getDIRECTNative();
        }

        private static native int getDIRECTNative();

        private static int getCACHE() {
            JniInitializer.checkInit();
            return GetDataModes.getCACHENative();
        }

        public int getValue() {
            return this.value;
        }

        public static GetDataModes valueOf(int n) {
            return (GetDataModes)IntegerValuedEnumHelper.fromIntValue(GetDataModes.class, (int)n);
        }
    }

    public static enum ErrorValues implements IntegerValuedEnum
    {
        CORRECT(ErrorValues.getCORRECT()),
        INCORRECT_RESOLUTION(ErrorValues.getINCORRECTRESOLUTION()),
        INCORRECT_SUBVOLUME(ErrorValues.getINCORRECTSUBVOLUME()),
        INCORRECT_LINE(ErrorValues.getINCORRECTLINE()),
        INCORRECT_POLYLINE(ErrorValues.getINCORRECTPOLYLINE()),
        INCORRECT_PLANE(ErrorValues.getINCORRECTPLANE()),
        INCORRECT_POSITION(ErrorValues.getINCORRECTPOSITION()),
        INCORRECT_COORDINATE(ErrorValues.getINCORRECTCOORDINATE()),
        MEMORY_FULL(ErrorValues.getMEMORYFULL()),
        REQUEST_NOT_COMPLETED(ErrorValues.getREQUESTNOTCOMPLETED()),
        REQUEST_NOT_FOUND(ErrorValues.getREQUESTNOTFOUND()),
        INCORRECT_BUFFER(ErrorValues.getINCORRECTBUFFER());

        private int value;

        private static native int getCORRECTNative();

        private static native int getINCORRECTCOORDINATENative();

        private static int getINCORRECTCOORDINATE() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTCOORDINATENative();
        }

        private static native int getMEMORYFULLNative();

        private static int getMEMORYFULL() {
            JniInitializer.checkInit();
            return ErrorValues.getMEMORYFULLNative();
        }

        private static native int getREQUESTNOTCOMPLETEDNative();

        private static int getREQUESTNOTCOMPLETED() {
            JniInitializer.checkInit();
            return ErrorValues.getREQUESTNOTCOMPLETEDNative();
        }

        private static native int getREQUESTNOTFOUNDNative();

        private static int getREQUESTNOTFOUND() {
            JniInitializer.checkInit();
            return ErrorValues.getREQUESTNOTFOUNDNative();
        }

        private static native int getINCORRECTBUFFERNative();

        private static int getINCORRECTBUFFER() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTBUFFERNative();
        }

        private ErrorValues(int n2) {
            this.value = n2;
        }

        private static int getINCORRECTPOSITION() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTPOSITIONNative();
        }

        private static int getCORRECT() {
            JniInitializer.checkInit();
            return ErrorValues.getCORRECTNative();
        }

        private static native int getINCORRECTRESOLUTIONNative();

        private static int getINCORRECTRESOLUTION() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTRESOLUTIONNative();
        }

        private static native int getINCORRECTSUBVOLUMENative();

        private static int getINCORRECTSUBVOLUME() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTSUBVOLUMENative();
        }

        private static native int getINCORRECTLINENative();

        private static native int getINCORRECTPOSITIONNative();

        private static int getINCORRECTPLANE() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTPLANENative();
        }

        private static native int getINCORRECTPLANENative();

        private static int getINCORRECTPOLYLINE() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTPOLYLINENative();
        }

        private static native int getINCORRECTPOLYLINENative();

        private static int getINCORRECTLINE() {
            JniInitializer.checkInit();
            return ErrorValues.getINCORRECTLINENative();
        }

        public int getValue() {
            return this.value;
        }

        public static ErrorValues valueOf(int n) {
            return (ErrorValues)IntegerValuedEnumHelper.fromIntValue(ErrorValues.class, (int)n);
        }
    }
}

