/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.compressors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.ldm.internal.JarInitializer;
import com.openinventor.ldm.internal.JniInitializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoDataCompressor
extends Inventor {
    private ByteBuffer m_src_compress;
    private ByteBuffer m_dest_uncompress;
    private static ByteBuffer m_buf_crc32;

    private static native Object allocateCompressedBufferImpl(long var0, long var2);

    private static native String getCompressionFormatNameImpl(long var0);

    private static native void setCompressionLevelImpl(long var0, long var2);

    private static native Object getCompressedBufferImpl(long var0);

    private static native long getCompressionLevelImpl(long var0);

    private static native long getAppropriateCompressorImpl(String var0);

    private static native long crc32Impl(Object var0, long var1);

    private static native boolean isLosslessImpl(long var0);

    protected SoDataCompressor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    static native String getClassTypeId();

    public boolean isLossless() {
        return SoDataCompressor.isLosslessImpl(this.getNativeResourceHandle());
    }

    public String getCompressionFormatName() {
        return SoDataCompressor.getCompressionFormatNameImpl(this.getNativeResourceHandle());
    }

    public ByteBuffer allocateCompressedBuffer(long l) {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoDataCompressor.allocateCompressedBufferImpl(this.getNativeResourceHandle(), l);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public static long crc32(ByteBuffer byteBuffer, long l) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        m_buf_crc32 = byteBuffer;
        return SoDataCompressor.crc32Impl(byteBuffer, l);
    }

    public ByteBuffer getCompressedBuffer() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoDataCompressor.getCompressedBufferImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public static SoDataCompressor getAppropriateCompressor(String string) {
        return (SoDataCompressor)ObjectManager.getManagedObjectFor(SoDataCompressor.class, (Long)SoDataCompressor.getAppropriateCompressorImpl(string));
    }

    public long getCompressionLevel() {
        return SoDataCompressor.getCompressionLevelImpl(this.getNativeResourceHandle());
    }

    public void setCompressionLevel(long l) {
        SoDataCompressor.setCompressionLevelImpl(this.getNativeResourceHandle(), l);
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

