/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFFloat;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.ldm.internal.JarInitializer;
import com.openinventor.ldm.internal.JniInitializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoTransferFunction
extends SoNode {
    public final SoSFInt32 transferFunctionId;
    public final SoSFInt32 shift;
    public final SoSFInt32 offset;
    public final SoSFInt32 minValue;
    public final SoSFInt32 maxValue;
    public final SoSFFloat fauxShadingLength;
    public final SoSFFloat fauxShadingStrength;
    public final SoSFFloat fauxShadingDarkenThreshold;
    public final SoSFEnum<PredefColorMaps> predefColorMap;
    public final SoSFEnum<ColorMapTypes> colorMapType;
    public final SoMFFloat colorMap;
    public final SoMFFloat actualColorMap;

    public ByteBuffer getPackedColorMap(int n) {
        ByteBuffer byteBuffer = this.getPackedColorMapNativ(this.getNativeResourceHandle(), n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    private native ByteBuffer getPackedColorMapNativ(long var1, int var3);

    private static native boolean loadColormapImpl(long var0, String var2);

    private static native boolean hasTransparencyImpl(long var0);

    private static native long ctorImpl();

    protected SoTransferFunction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.transferFunctionId = (SoSFInt32)ObjectManager.getManagedObjectFor(SoSFInt32.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"transferFunctionId"));
        this.shift = (SoSFInt32)ObjectManager.getManagedObjectFor(SoSFInt32.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"shift"));
        this.offset = (SoSFInt32)ObjectManager.getManagedObjectFor(SoSFInt32.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"offset"));
        this.minValue = (SoSFInt32)ObjectManager.getManagedObjectFor(SoSFInt32.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"minValue"));
        this.maxValue = (SoSFInt32)ObjectManager.getManagedObjectFor(SoSFInt32.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"maxValue"));
        this.fauxShadingLength = (SoSFFloat)ObjectManager.getManagedObjectFor(SoSFFloat.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"fauxShadingLength"));
        this.fauxShadingStrength = (SoSFFloat)ObjectManager.getManagedObjectFor(SoSFFloat.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"fauxShadingStrength"));
        this.fauxShadingDarkenThreshold = (SoSFFloat)ObjectManager.getManagedObjectFor(SoSFFloat.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"fauxShadingDarkenThreshold"));
        this.predefColorMap = (SoSFEnum)ObjectManager.getManagedObjectFor(SoSFEnum.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"predefColorMap"), (Class[])new Class[]{PredefColorMaps.class});
        this.colorMapType = (SoSFEnum)ObjectManager.getManagedObjectFor(SoSFEnum.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"colorMapType"), (Class[])new Class[]{ColorMapTypes.class});
        this.colorMap = (SoMFFloat)ObjectManager.getManagedObjectFor(SoMFFloat.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"colorMap"));
        this.actualColorMap = (SoMFFloat)ObjectManager.getManagedObjectFor(SoMFFloat.class, (Long)SoTransferFunction.getFieldHandle((long)this.getNativeResourceHandle(), (String)"actualColorMap"));
    }

    static native String getClassTypeId();

    public boolean hasTransparency() {
        return SoTransferFunction.hasTransparencyImpl(this.getNativeResourceHandle());
    }

    public boolean loadColormap(String string) {
        return SoTransferFunction.loadColormapImpl(this.getNativeResourceHandle(), string);
    }

    public SoTransferFunction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoTransferFunction.ctorImpl());
    }

    static {
        JarInitializer.checkInit();
    }

    public static enum PredefColorMaps implements IntegerValuedEnum
    {
        NONE(PredefColorMaps.getNONE()),
        GREY(PredefColorMaps.getGREY()),
        GRAY(PredefColorMaps.getGRAY()),
        TEMPERATURE(PredefColorMaps.getTEMPERATURE()),
        PHYSICS(PredefColorMaps.getPHYSICS()),
        STANDARD(PredefColorMaps.getSTANDARD()),
        GLOW(PredefColorMaps.getGLOW()),
        BLUE_RED(PredefColorMaps.getBLUERED()),
        SEISMIC(PredefColorMaps.getSEISMIC()),
        BLUE_WHITE_RED(PredefColorMaps.getBLUEWHITERED()),
        INTENSITY(PredefColorMaps.getINTENSITY()),
        LABEL_256(PredefColorMaps.getLABEL256()),
        VOLREN_RED(PredefColorMaps.getVOLRENRED()),
        VOLREN_GREEN(PredefColorMaps.getVOLRENGREEN()),
        AIRWAY(PredefColorMaps.getAIRWAY()),
        AIRWAY_SURFACES(PredefColorMaps.getAIRWAYSURFACES()),
        INTENSITY_REVERSED(PredefColorMaps.getINTENSITYREVERSED());

        private int value;

        private static native int getNONENative();

        private static int getVOLRENRED() {
            JniInitializer.checkInit();
            return PredefColorMaps.getVOLRENREDNative();
        }

        private static native int getVOLRENREDNative();

        private static int getLABEL256() {
            JniInitializer.checkInit();
            return PredefColorMaps.getLABEL256Native();
        }

        private static native int getLABEL256Native();

        private static int getINTENSITY() {
            JniInitializer.checkInit();
            return PredefColorMaps.getINTENSITYNative();
        }

        private static native int getINTENSITYNative();

        private static int getBLUEWHITERED() {
            JniInitializer.checkInit();
            return PredefColorMaps.getBLUEWHITEREDNative();
        }

        private static native int getVOLRENGREENNative();

        private PredefColorMaps(int n2) {
            this.value = n2;
        }

        private static int getINTENSITYREVERSED() {
            JniInitializer.checkInit();
            return PredefColorMaps.getINTENSITYREVERSEDNative();
        }

        private static native int getINTENSITYREVERSEDNative();

        private static int getAIRWAYSURFACES() {
            JniInitializer.checkInit();
            return PredefColorMaps.getAIRWAYSURFACESNative();
        }

        private static native int getAIRWAYSURFACESNative();

        private static int getAIRWAY() {
            JniInitializer.checkInit();
            return PredefColorMaps.getAIRWAYNative();
        }

        private static native int getAIRWAYNative();

        private static int getVOLRENGREEN() {
            JniInitializer.checkInit();
            return PredefColorMaps.getVOLRENGREENNative();
        }

        private static native int getBLUEWHITEREDNative();

        private static native int getPHYSICSNative();

        private static int getTEMPERATURE() {
            JniInitializer.checkInit();
            return PredefColorMaps.getTEMPERATURENative();
        }

        private static native int getTEMPERATURENative();

        private static int getGRAY() {
            JniInitializer.checkInit();
            return PredefColorMaps.getGRAYNative();
        }

        private static native int getGRAYNative();

        private static int getGREY() {
            JniInitializer.checkInit();
            return PredefColorMaps.getGREYNative();
        }

        private static native int getGREYNative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return PredefColorMaps.getNONENative();
        }

        private static int getPHYSICS() {
            JniInitializer.checkInit();
            return PredefColorMaps.getPHYSICSNative();
        }

        private static int getSEISMIC() {
            JniInitializer.checkInit();
            return PredefColorMaps.getSEISMICNative();
        }

        private static native int getSEISMICNative();

        private static int getBLUERED() {
            JniInitializer.checkInit();
            return PredefColorMaps.getBLUEREDNative();
        }

        private static native int getBLUEREDNative();

        private static int getGLOW() {
            JniInitializer.checkInit();
            return PredefColorMaps.getGLOWNative();
        }

        private static native int getGLOWNative();

        private static int getSTANDARD() {
            JniInitializer.checkInit();
            return PredefColorMaps.getSTANDARDNative();
        }

        private static native int getSTANDARDNative();

        public int getValue() {
            return this.value;
        }

        public static PredefColorMaps valueOf(int n) {
            return (PredefColorMaps)IntegerValuedEnumHelper.fromIntValue(PredefColorMaps.class, (int)n);
        }
    }

    public static enum ColorMapTypes implements IntegerValuedEnum
    {
        ALPHA(ColorMapTypes.getALPHA()),
        LUM_ALPHA(ColorMapTypes.getLUMALPHA()),
        RGBA(ColorMapTypes.getRGBA());

        private int value;

        private static native int getALPHANative();

        private ColorMapTypes(int n2) {
            this.value = n2;
        }

        private static int getRGBA() {
            JniInitializer.checkInit();
            return ColorMapTypes.getRGBANative();
        }

        private static native int getRGBANative();

        private static int getLUMALPHA() {
            JniInitializer.checkInit();
            return ColorMapTypes.getLUMALPHANative();
        }

        private static native int getLUMALPHANative();

        private static int getALPHA() {
            JniInitializer.checkInit();
            return ColorMapTypes.getALPHANative();
        }

        public int getValue() {
            return this.value;
        }

        public static ColorMapTypes valueOf(int n) {
            return (ColorMapTypes)IntegerValuedEnumHelper.fromIntValue(ColorMapTypes.class, (int)n);
        }
    }
}

