/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.readers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.ldm.internal.JarInitializer;
import com.openinventor.ldm.internal.JniInitializer;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.ldm.xml.SbXmlTag;

public class SoLDMReader
extends SoVolumeReader {
    private static native boolean isLittleEndianImpl(long var0);

    private static native void getDimensionImpl(long var0, int[] var2);

    private static native boolean getBboxImpl(long var0, int var2, float[] var3);

    private static native boolean getCenterImpl(long var0, int var2, float[] var3);

    private static native long getXmlTagImpl(long var0, String var2);

    private static native void getSizeImpl(long var0, float[] var2);

    private static native long ctorImpl();

    protected SoLDMReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public boolean isLittleEndian() {
        return SoLDMReader.isLittleEndianImpl(this.getNativeResourceHandle());
    }

    public SoLDMReader() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMReader.ctorImpl());
    }

    public SbBox3f getSize() {
        SbBox3f sbBox3f = new SbBox3f();
        SoLDMReader.getSizeImpl(this.getNativeResourceHandle(), sbBox3f.array);
        return sbBox3f;
    }

    public SbVec3i32 getDimension() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        SoLDMReader.getDimensionImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        return sbVec3i32;
    }

    public SbBox3f getBbox(int n) {
        SbBox3f sbBox3f = new SbBox3f();
        boolean bl = false;
        bl = SoLDMReader.getBboxImpl(this.getNativeResourceHandle(), n, sbBox3f != null ? sbBox3f.array : null);
        if (bl) {
            return sbBox3f;
        }
        return null;
    }

    public SbXmlTag getXmlTag(String string) {
        return (SbXmlTag)ObjectManager.createManagedObject(SbXmlTag.class, (Long)SoLDMReader.getXmlTagImpl(this.getNativeResourceHandle(), string), (Inventor.ConstructorCommand)Inventor.ConstructorCommand.CreateInstance);
    }

    public SbVec3f getCenter(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        bl = SoLDMReader.getCenterImpl(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null);
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    static {
        JarInitializer.checkInit();
    }

    public static enum SoLDMErrors implements IntegerValuedEnum
    {
        LDM_NO_ERROR(SoLDMErrors.getLDMNOERROR()),
        LDM_FILE_NOT_FOUND(SoLDMErrors.getLDMFILENOTFOUND()),
        LDM_XML_ROOT_START_TAG_NOT_FOUND(SoLDMErrors.getLDMXMLROOTSTARTTAGNOTFOUND()),
        LDM_XML_ROOT_END_TAG_NOT_FOUND(SoLDMErrors.getLDMXMLROOTENDTAGNOTFOUND()),
        LDM_ALTERNATE_FILE_NOT_FOUND(SoLDMErrors.getLDMALTERNATEFILENOTFOUND()),
        LDM_XML_PARSING_ERROR(SoLDMErrors.getLDMXMLPARSINGERROR()),
        LDM_SIZE_TAG_MISSING(SoLDMErrors.getLDMSIZETAGMISSING()),
        LDM_COMPLETION_FILE_NOT_FOUND(SoLDMErrors.getLDMCOMPLETIONFILENOTFOUND()),
        LDM_RD_NO_ERROR(SoLDMErrors.getLDMRDNOERROR()),
        LDM_RD_FILE_NOT_FOUND_ERROR(SoLDMErrors.getLDMRDFILENOTFOUNDERROR()),
        LDM_RD_UNSUPPORTED_DATA_TYPE_ERROR(SoLDMErrors.getLDMRDUNSUPPORTEDDATATYPEERROR()),
        LDM_RD_UNKNOWN_ERROR(SoLDMErrors.getLDMRDUNKNOWNERROR());

        private int value;

        private static native int getLDMNOERRORNative();

        private static native int getLDMCOMPLETIONFILENOTFOUNDNative();

        private static int getLDMCOMPLETIONFILENOTFOUND() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMCOMPLETIONFILENOTFOUNDNative();
        }

        private static native int getLDMRDNOERRORNative();

        private static int getLDMRDNOERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMRDNOERRORNative();
        }

        private static native int getLDMRDFILENOTFOUNDERRORNative();

        private static int getLDMRDFILENOTFOUNDERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMRDFILENOTFOUNDERRORNative();
        }

        private static native int getLDMRDUNSUPPORTEDDATATYPEERRORNative();

        private static int getLDMRDUNSUPPORTEDDATATYPEERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMRDUNSUPPORTEDDATATYPEERRORNative();
        }

        private static native int getLDMRDUNKNOWNERRORNative();

        private static int getLDMRDUNKNOWNERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMRDUNKNOWNERRORNative();
        }

        private SoLDMErrors(int n2) {
            this.value = n2;
        }

        private static int getLDMSIZETAGMISSING() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMSIZETAGMISSINGNative();
        }

        private static int getLDMNOERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMNOERRORNative();
        }

        private static native int getLDMFILENOTFOUNDNative();

        private static int getLDMFILENOTFOUND() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMFILENOTFOUNDNative();
        }

        private static native int getLDMXMLROOTSTARTTAGNOTFOUNDNative();

        private static int getLDMXMLROOTSTARTTAGNOTFOUND() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMXMLROOTSTARTTAGNOTFOUNDNative();
        }

        private static native int getLDMXMLROOTENDTAGNOTFOUNDNative();

        private static native int getLDMSIZETAGMISSINGNative();

        private static int getLDMXMLPARSINGERROR() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMXMLPARSINGERRORNative();
        }

        private static native int getLDMXMLPARSINGERRORNative();

        private static int getLDMALTERNATEFILENOTFOUND() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMALTERNATEFILENOTFOUNDNative();
        }

        private static native int getLDMALTERNATEFILENOTFOUNDNative();

        private static int getLDMXMLROOTENDTAGNOTFOUND() {
            JniInitializer.checkInit();
            return SoLDMErrors.getLDMXMLROOTENDTAGNOTFOUNDNative();
        }

        public int getValue() {
            return this.value;
        }

        public static SoLDMErrors valueOf(int n) {
            return (SoLDMErrors)IntegerValuedEnumHelper.fromIntValue(SoLDMErrors.class, (int)n);
        }
    }
}

