/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ControlEditor {
    public int horizontalAlignment = 0x1000000;
    public boolean grabHorizontal = false;
    public int minimumWidth = 0;
    public int verticalAlignment = 0x1000000;
    public boolean grabVertical = false;
    public int minimumHeight = 0;
    Composite parent;
    Control editor;
    private boolean hadFocus;
    private Listener controlListener;
    private Listener scrollbarListener;
    private static final int[] EVENTS = new int[]{1, 2, 3, 4, 11};

    public ControlEditor(Composite composite) {
        ScrollBar scrollBar;
        this.parent = composite;
        this.controlListener = event -> this.layout();
        for (int i = 0; i < EVENTS.length; ++i) {
            composite.addListener(EVENTS[i], this.controlListener);
        }
        this.scrollbarListener = event -> this.scroll(event);
        ScrollBar scrollBar2 = composite.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, this.scrollbarListener);
        }
        if ((scrollBar = composite.getVerticalBar()) != null) {
            scrollBar.addListener(13, this.scrollbarListener);
        }
    }

    Rectangle computeBounds() {
        Rectangle rectangle = this.parent.getClientArea();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            rectangle2.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle2.height = Math.max(rectangle.height, this.minimumHeight);
        }
        switch (this.horizontalAlignment) {
            case 131072: {
                rectangle2.x += rectangle.width - rectangle2.width;
                break;
            }
            case 16384: {
                break;
            }
            default: {
                rectangle2.x += (rectangle.width - rectangle2.width) / 2;
            }
        }
        switch (this.verticalAlignment) {
            case 1024: {
                rectangle2.y += rectangle.height - rectangle2.height;
                break;
            }
            case 128: {
                break;
            }
            default: {
                rectangle2.y += (rectangle.height - rectangle2.height) / 2;
            }
        }
        return rectangle2;
    }

    public void dispose() {
        if (this.parent != null && !this.parent.isDisposed()) {
            ScrollBar scrollBar;
            for (int i = 0; i < EVENTS.length; ++i) {
                this.parent.removeListener(EVENTS[i], this.controlListener);
            }
            ScrollBar scrollBar2 = this.parent.getHorizontalBar();
            if (scrollBar2 != null) {
                scrollBar2.removeListener(13, this.scrollbarListener);
            }
            if ((scrollBar = this.parent.getVerticalBar()) != null) {
                scrollBar.removeListener(13, this.scrollbarListener);
            }
        }
        this.parent = null;
        this.editor = null;
        this.hadFocus = false;
        this.controlListener = null;
        this.scrollbarListener = null;
    }

    public Control getEditor() {
        return this.editor;
    }

    public void layout() {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        if (this.editor.getVisible()) {
            this.hadFocus = this.editor.isFocusControl();
        }
        this.editor.setBounds(this.computeBounds());
        if (this.hadFocus) {
            if (this.editor == null || this.editor.isDisposed()) {
                return;
            }
            this.editor.setFocus();
        }
    }

    void scroll(Event event) {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        this.layout();
    }

    public void setEditor(Control control) {
        if (control == null) {
            this.editor = null;
            return;
        }
        this.editor = control;
        this.layout();
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        control.setVisible(true);
    }
}

