/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, event -> {
            ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
            if (clipboardProxy == null) {
                return;
            }
            display.setData(ID, null);
            clipboardProxy.dispose();
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0L) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    long clearFunc(long l, long l2) {
        if (l == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (l == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long l, long l2, long l3, long l4) {
        if (l2 == 0L) {
            return 0L;
        }
        long l5 = OS.gtk_selection_data_get_target(l2);
        TransferData transferData = new TransferData();
        transferData.type = l5;
        Transfer[] transferArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n = -1;
        for (int i = 0; i < transferArray.length; ++i) {
            if (!transferArray[i].isSupportedType(transferData)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return 0L;
        }
        Object[] objectArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n].javaToNative(objectArray[n], transferData);
        if (transferData.format < 8 || transferData.format % 8 != 0) {
            return 0L;
        }
        OS.gtk_selection_data_set(l2, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean setData(Clipboard var1_1, Object[] var2_2, Transfer[] var3_3, int var4_4) {
        block16: {
            block15: {
                var5_5 = new GtkTargetEntry[]{};
                var6_6 = 0L;
                for (var8_7 = 0; var8_7 < var3_3.length; ++var8_7) {
                    var9_8 = var3_3[var8_7];
                    var10_12 = var9_8.getTypeIds();
                    var11_14 = var9_8.getTypeNames();
                    for (var12_17 = 0; var12_17 < var10_12.length; ++var12_17) {
                        var13_18 = new GtkTargetEntry();
                        var13_18.info = var10_12[var12_17];
                        var14_21 = Converter.wcsToMbcs(var11_14[var12_17], true);
                        var15_24 = OS.g_malloc(var14_21.length);
                        OS.memmove(var15_24, var14_21, (long)var14_21.length);
                        var13_18.target = var15_24;
                        var17_27 = new GtkTargetEntry[var5_5.length + 1];
                        System.arraycopy(var5_5, 0, var17_27, 0, var5_5.length);
                        var17_27[var5_5.length] = var13_18;
                        var5_5 = var17_27;
                    }
                }
                var6_6 = OS.g_malloc(GtkTargetEntry.sizeof * var5_5.length);
                var8_7 = 0;
                for (var9_9 = 0; var9_9 < var5_5.length; ++var9_9) {
                    OS.memmove(var6_6 + (long)var8_7, var5_5[var9_9], (long)GtkTargetEntry.sizeof);
                    var8_7 += GtkTargetEntry.sizeof;
                }
                if ((var4_4 & 1) == 0) ** GOTO lbl45
                this.clipboardData = var2_2;
                this.clipboardDataTypes = var3_3;
                var9_10 = this.getFunc.getAddress();
                if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, var6_6, var5_5.length, var9_10, var11_15 = this.clearFunc.getAddress(), this.clipboardOwner)) break block15;
                var13_19 = false;
                for (var14_22 = 0; var14_22 < var5_5.length; ++var14_22) {
                    var15_25 = var5_5[var14_22];
                    if (var15_25.target == 0L) continue;
                    OS.g_free(var15_25.target);
                }
                if (var6_6 != 0L) {
                    OS.g_free(var6_6);
                }
                return var13_19;
            }
            OS.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
            this.activeClipboard = var1_1;
lbl45:
            // 2 sources

            if ((var4_4 & 2) == 0) ** GOTO lbl63
            this.primaryClipboardData = var2_2;
            this.primaryClipboardDataTypes = var3_3;
            var9_10 = this.getFunc.getAddress();
            if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, var6_6, var5_5.length, var9_10, var11_15 = this.clearFunc.getAddress(), this.clipboardOwner)) break block16;
            var13_20 = false;
            for (var14_23 = 0; var14_23 < var5_5.length; ++var14_23) {
                var15_26 = var5_5[var14_23];
                if (var15_26.target == 0L) continue;
                OS.g_free(var15_26.target);
            }
            if (var6_6 != 0L) {
                OS.g_free(var6_6);
            }
            return var13_20;
        }
        try {
            OS.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
            this.activePrimaryClipboard = var1_1;
lbl63:
            // 2 sources

            var9_11 = true;
        }
        catch (Throwable var18_28) {
            for (var19_29 = 0; var19_29 < var5_5.length; ++var19_29) {
                var20_30 = var5_5[var19_29];
                if (var20_30.target == 0L) continue;
                OS.g_free(var20_30.target);
            }
            if (var6_6 != 0L) {
                OS.g_free(var6_6);
            }
            throw var18_28;
        }
        for (var10_13 = 0; var10_13 < var5_5.length; ++var10_13) {
            var11_16 = var5_5[var10_13];
            if (var11_16.target == 0L) continue;
            OS.g_free(var11_16.target);
        }
        if (var6_6 != 0L) {
            OS.g_free(var6_6);
        }
        return var9_11;
    }
}

