/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static char[] mbcsToWcs(byte[] byArray) {
        long[] lArray = new long[1];
        long l = OS.g_utf8_to_utf16(byArray, (long)byArray.length, null, lArray, null);
        if (l == 0L) {
            return EmptyCharArray;
        }
        int n = (int)lArray[0];
        char[] cArray = new char[n];
        OS.memmove(cArray, l, (long)(n * 2));
        OS.g_free(l);
        return cArray;
    }

    public static byte[] wcsToMbcs(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Converter.wcsToMbcs(cArray, bl);
    }

    public static String cCharPtrToJavaString(long l, boolean bl) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        if (bl) {
            OS.g_free(l);
        }
        return new String(Converter.mbcsToWcs(byArray));
    }

    public static byte[] wcsToMbcs(char[] cArray, boolean bl) {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l = OS.g_utf16_to_utf8(cArray, cArray.length, lArray, lArray2, null);
        if (l == 0L) {
            return bl ? NullByteArray : EmptyByteArray;
        }
        int n = (int)lArray2[0];
        byte[] byArray = new byte[n + (bl ? 1 : 0)];
        OS.memmove(byArray, l, (long)n);
        OS.g_free(l);
        return byArray;
    }

    public static char wcsToMbcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return '\u0000';
    }

    public static char mbcsToWcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = n <= 255 ? new byte[]{(byte)n} : new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        char[] cArray = Converter.mbcsToWcs(byArray);
        if (cArray.length == 0) {
            return '\u0000';
        }
        return cArray[0];
    }
}

