/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    long textEntryHandle;
    long containerHandle;
    long calendarHandle;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    String dateTimeString;
    boolean firstTime = true;
    Color fg;
    Color bg;
    boolean hasFocus;
    boolean monthChanged;
    boolean calendarDisplayed;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Point prefferedSize = null;
    Listener mouseEventListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    static final int SPACE_FOR_CURSOR = 1;
    static final int GTK2_MANUAL_BORDER_PADDING = 2;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
        if (this.isDate() || this.isTime()) {
            this.createText();
        }
        if (this.isCalendar()) {
            OS.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
        }
        if (this.isDateWithDropDownButton()) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
            this.addListener(11, event -> this.setDropDownButtonSize());
        }
        this.initAccessible();
        if (this.isDateWithDropDownButton()) {
            Point point = this.computeSizeInPixels(-1, -1);
            this.setBoundsInPixels(0, 0, point.x, point.y);
        }
    }

    void createText() {
        this.calendar = Calendar.getInstance();
        this.formatSymbols = new DateFormatSymbols();
        if (this.isDate()) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
        } else if (this.isTime()) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
        }
        this.dateTimeString = this.getFormattedString(this.style);
        if (this.dateTimeString != null) {
            this.setText(this.dateTimeString);
        }
    }

    static int checkStyle(int n) {
        if (!OS.GTK3 && DateTime.isDateWithDropDownButton(n &= 0xFFFFFCFF)) {
            n &= 0xFBFFFFFF;
        }
        if (((n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            n &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (!bl && (this.isDate() || this.isTime()) && OS.GTK3 && this.prefferedSize != null) {
            n3 = n != -1 ? n : this.prefferedSize.x;
            n4 = n2 != -1 ? n2 : this.prefferedSize.y;
            return new Point(n3, n4);
        }
        if (n == -1 || n2 == -1) {
            Point point;
            if (this.isCalendar()) {
                point = this.computeNativeSize(this.containerHandle, n, n2, bl);
                n3 = point.x;
                n4 = point.y;
            } else {
                point = this.computeNativeSize(this.textEntryHandle, n, n2, bl);
                Rectangle rectangle = this.computeTrimInPixels(0, 0, point.x, point.y);
                if (this.isDateWithDropDownButton()) {
                    Point point2 = this.down.computeSizeInPixels(-1, -1, bl);
                    n3 = rectangle.width + point2.x;
                    n4 = Math.max(rectangle.height, point2.y);
                } else if (this.isDate() || this.isTime()) {
                    if (OS.GTK3) {
                        n3 = rectangle.width;
                        n4 = rectangle.height;
                    } else {
                        n3 = point.x;
                        n4 = point.y;
                    }
                }
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidthInPixels();
        if (this.prefferedSize == null && this.isDateWithDropDownButton() && OS.GTK3) {
            this.prefferedSize = new Point(n3 + 2 * n5, n4 + 2 * n5);
            return this.prefferedSize;
        }
        return new Point(n3 + 2 * n5, n4 + 2 * n5);
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        if (this.isCalendar()) {
            return super.computeTrimInPixels(n, n2, n3, n4);
        }
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if (OS.GTK3) {
            GtkBorder gtkBorder = new GtkBorder();
            long l = OS.gtk_widget_get_style_context(this.textEntryHandle);
            if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                OS.gtk_style_context_get_padding(l, 0, gtkBorder);
            } else {
                OS.gtk_style_context_get_padding(l, OS.gtk_widget_get_state_flags(this.textEntryHandle), gtkBorder);
            }
            rectangle.x -= gtkBorder.left;
            rectangle.y -= gtkBorder.top;
            rectangle.width += gtkBorder.left + gtkBorder.right;
            rectangle.height += gtkBorder.top + gtkBorder.bottom;
            if ((this.style & 0x800) != 0) {
                if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                    OS.gtk_style_context_get_border(l, 0, gtkBorder);
                } else {
                    OS.gtk_style_context_get_border(l, OS.gtk_widget_get_state_flags(this.textEntryHandle), gtkBorder);
                }
                rectangle.x -= gtkBorder.left;
                rectangle.y -= gtkBorder.top;
                rectangle.width += gtkBorder.left + gtkBorder.right;
                rectangle.height += gtkBorder.top + gtkBorder.bottom;
            }
        } else {
            Object object;
            if ((this.style & 0x800) != 0) {
                object = this.getThickness(this.textEntryHandle);
                n5 += ((Point)object).x;
                n6 += ((Point)object).y;
            }
            object = Display.getEntryInnerBorder(this.textEntryHandle);
            rectangle.x -= ((GtkBorder)object).left;
            rectangle.y -= ((GtkBorder)object).top;
            rectangle.width += ((GtkBorder)object).left + ((GtkBorder)object).right;
            rectangle.height += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    void createHandle(int n) {
        this.createHandle();
    }

    void createHandle() {
        if (this.isCalendar()) {
            this.state |= 8;
            this.createHandleForFixed();
            this.createHandleForCalendar();
        } else {
            this.createHandleForFixed();
            if (this.isDateWithDropDownButton()) {
                this.createHandleForDateWithDropDown();
            } else {
                this.createHandleForDateTime();
            }
            OS.gtk_editable_set_editable(this.textEntryHandle, (this.style & 8) == 0);
            if (OS.GTK_VERSION <= OS.VERSION(3, 20, 0)) {
                OS.gtk_entry_set_has_frame(this.textEntryHandle, (this.style & 0x800) != 0);
            }
        }
    }

    private void createHandleForFixed() {
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
    }

    private void createHandleForCalendar() {
        this.calendarHandle = OS.gtk_calendar_new();
        if (this.calendarHandle == 0L) {
            this.error(2);
        }
        this.handle = this.calendarHandle;
        this.containerHandle = this.calendarHandle;
        OS.gtk_container_add(this.fixedHandle, this.calendarHandle);
        OS.gtk_calendar_set_display_options(this.calendarHandle, 3);
        OS.gtk_widget_show(this.calendarHandle);
    }

    private void createHandleForDateWithDropDown() {
        this.containerHandle = this.gtk_box_new(0, false, 0);
        if (this.containerHandle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.containerHandle);
        this.textEntryHandle = OS.gtk_entry_new();
        if (this.textEntryHandle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.containerHandle, this.textEntryHandle);
        OS.gtk_widget_show(this.containerHandle);
        OS.gtk_widget_show(this.textEntryHandle);
        this.handle = this.containerHandle;
        if (this.handle == 0L) {
            this.error(2);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    private void createHandleForDateTime() {
        long l = OS.gtk_adjustment_new(0.0, -9999.0, 9999.0, 1.0, 0.0, 0.0);
        this.textEntryHandle = OS.gtk_spin_button_new(l, 1.0, 0);
        if (this.textEntryHandle == 0L) {
            this.error(2);
        }
        this.handle = this.textEntryHandle;
        this.containerHandle = this.textEntryHandle;
        OS.gtk_spin_button_set_numeric(this.textEntryHandle, false);
        OS.gtk_container_add(this.fixedHandle, this.textEntryHandle);
        OS.gtk_spin_button_set_wrap(this.textEntryHandle, (this.style & 0x40) != 0);
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        OS.gtk_widget_set_can_focus(this.down.handle, false);
        this.down.addListener(13, event -> {
            this.popupCalendar.calendarDisplayed = !this.isDropped();
            this.setFocus();
            this.dropDownCalendar(!this.isDropped());
        });
        this.popupListener = event -> {
            if (event.widget == this.popupShell) {
                this.popupShellEvent(event);
                return;
            }
            if (event.widget == this.popupCalendar) {
                this.popupCalendarEvent(event);
                return;
            }
            if (event.widget == this) {
                this.onDispose(event);
                return;
            }
            if (event.widget == this.getShell()) {
                this.getDisplay().asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.handleFocus(16);
                });
            }
        };
        this.popupFilter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
    }

    void createPopupShell(int n, int n2, int n3) {
        int n4;
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.mouseEventListener = event -> {
            Control control;
            if (event.widget instanceof Control && (control = (Control)event.widget) != this.down && control.getShell() != this.popupShell) {
                this.dropDownCalendar(false);
            }
        };
        int[] nArray = new int[]{21, 4};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupShell.addListener(nArray[n4], this.popupListener);
        }
        nArray = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupCalendar.addListener(nArray[n4], this.popupListener);
        }
        this.addListener(12, this.popupListener);
        if (n != -1) {
            this.popupCalendar.setDate(n, n2, n3);
        }
    }

    @Override
    void setFontDescription(long l) {
        if (this.isDateWithDropDownButton()) {
            this.prefferedSize = null;
            this.setFontDescription(this.textEntryHandle, l);
        }
        super.setFontDescription(l);
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        if (this.isCalendar()) {
            this.getDate();
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.popupCalendar = null;
        this.down = null;
        this.dateTimeString = null;
    }

    void dropDownCalendar(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.hideDropDownCalendar();
            return;
        }
        this.setCurrentDate();
        if (this.getShell() != this.popupShell.getParent()) {
            this.recreateCalendar();
        }
        Point point = this.getSizeInPixels();
        Point point2 = this.popupCalendar.computeSizeInPixels(-1, -1, false);
        this.popupCalendar.setBoundsInPixels(1, 1, Math.max(point.x - 2, point2.x), point2.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        this.focusDayOnPopupCalendar();
        Display display = this.getDisplay();
        Rectangle rectangle = display.mapInPixels(this.getParent(), null, this.getBoundsInPixels());
        Rectangle rectangle2 = DPIUtil.autoScaleUp(this.getMonitor().getClientArea());
        this.showPopupShell(point, point2, rectangle, rectangle2);
        display.addFilter(3, this.mouseEventListener);
    }

    private void showPopupShell(Point point, Point point2, Rectangle rectangle, Rectangle rectangle2) {
        int n = Math.max(point.x, point2.x + 2);
        int n2 = point2.y + 2;
        int n3 = this.calculateCalendarYpos(point, rectangle, n2, rectangle2);
        int n4 = this.calculateCalendarXpos(point2, rectangle, rectangle2, n);
        this.popupShell.setBoundsInPixels(n4, n3, n, n2);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
    }

    private int calculateCalendarYpos(Point point, Rectangle rectangle, int n, Rectangle rectangle2) {
        int n2 = this.computeNativeSize((long)this.containerHandle, (int)-1, (int)-1, (boolean)false).y;
        int n3 = rectangle.y + point.y / 2 + n2 / 2;
        if (n3 + n > rectangle2.y + rectangle2.height) {
            n3 -= n + n2;
        }
        return n3;
    }

    private int calculateCalendarXpos(Point point, Rectangle rectangle, Rectangle rectangle2, int n) {
        Integer n2 = rectangle.x;
        if (n2 + n > rectangle2.x + rectangle2.width) {
            n2 = rectangle2.x + rectangle2.width - point.x;
        }
        return n2;
    }

    private void focusDayOnPopupCalendar() {
        int n = Calendar.getInstance().get(1);
        int n2 = Calendar.getInstance().get(2);
        if (this.savedYear == n && this.savedMonth == n2) {
            int n3 = Calendar.getInstance().get(5);
            OS.gtk_calendar_mark_day(this.popupCalendar.handle, n3);
        }
    }

    private void setCurrentDate() {
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
    }

    private void recreateCalendar() {
        int n = this.popupCalendar.getYear();
        int n2 = this.popupCalendar.getMonth();
        int n3 = this.popupCalendar.getDay();
        this.popupCalendar.removeListener(12, this.popupListener);
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
        this.createPopupShell(n, n2, n3);
    }

    private void hideDropDownCalendar() {
        this.popupShell.setVisible(false);
        OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
        this.display.removeFilter(3, this.mouseEventListener);
    }

    String formattedStringValue(int n, int n2, boolean bl) {
        if (n == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            return stringArray[n2];
        }
        if (bl) {
            if (n == 10 && n2 == 0) {
                return String.valueOf(12);
            }
            if (n == 2) {
                return String.valueOf(n2 + 1);
            }
        }
        return String.valueOf(n2);
    }

    @Override
    GdkColor getBackgroundColor() {
        if (this.isCalendar()) {
            return this.getBaseColor();
        }
        return super.getBackgroundColor();
    }

    String getComputeSizeString(int n) {
        if ((n & 0x20) != 0) {
            return (n & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((n & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (n & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((n & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int n) {
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fieldNames[i] != n) continue;
            return i;
        }
        return -1;
    }

    String getFormattedString(int n) {
        String string = null;
        if (this.isTime()) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            int n2 = this.calendar.get(10);
            if (n2 == 0) {
                n2 = 12;
            }
            int n3 = this.calendar.get(12);
            int n4 = this.calendar.get(13);
            int n5 = this.calendar.get(9);
            string = "" + (n2 < 10 ? "0" : "") + n2 + ":";
            string = (n & 0x8000) != 0 ? string + (n3 < 10 ? "0" : "") + n3 + " " + stringArray[n5] : string + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4 + " " + stringArray[n5];
        } else if (this.isDate()) {
            int n6 = this.calendar.get(1);
            int n7 = this.calendar.get(2) + 1;
            int n8 = this.calendar.get(5);
            string = "" + (n7 < 10 ? "0" : "") + n7 + "/";
            string = (n & 0x8000) != 0 ? string + n6 : string + (n8 < 10 ? "0" : "") + n8 + "/" + n6;
        }
        return string;
    }

    void getDate() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.calendarHandle, nArray, nArray2, nArray3);
        this.year = nArray[0];
        this.month = nArray2[0];
        this.day = nArray3[0];
    }

    public int getDay() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    @Override
    String getNameText() {
        if (this.isTime()) {
            return this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds();
        }
        return this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTime()) {
            int n = this.calendar.get(10);
            if (n == 0) {
                n = 12;
            }
            stringBuffer.append(n);
            int n2 = this.calendar.get(12);
            stringBuffer.append(":" + (n2 < 10 ? "0" : "") + n2);
            if ((this.style & 0x8000) == 0) {
                int n3 = this.calendar.get(13);
                stringBuffer.append(":" + (n3 < 10 ? "0" : "") + n3);
            }
            stringBuffer.append(" " + this.formatSymbols.getAmPmStrings()[this.calendar.get(9)]);
        } else {
            Calendar calendar = this.calendar;
            if (this.isCalendar()) {
                this.formatSymbols = new DateFormatSymbols();
                calendar = Calendar.getInstance();
                this.getDate();
                calendar.set(this.year, this.month, this.day);
            }
            if ((this.style & 0x8000) == 0) {
                stringBuffer.append(this.formatSymbols.getWeekdays()[calendar.get(7)] + ", ");
            }
            stringBuffer.append(this.formatSymbols.getMonths()[calendar.get(2)] + " ");
            if ((this.style & 0x8000) == 0) {
                stringBuffer.append(calendar.get(5) + ", ");
            }
            stringBuffer.append(calendar.get(1));
        }
        return stringBuffer.toString();
    }

    public int getYear() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    @Override
    long gtk_day_selected(long l) {
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long gtk_day_selected_double_click(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_month_changed(long l) {
        if (this.calendarDisplayed) {
            this.calendarDisplayed = false;
        } else {
            this.monthChanged = true;
        }
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long eventHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long focusHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long fontHandle() {
        return this.dateTimeHandle();
    }

    private long dateTimeHandle() {
        if (this.isCalendar() && this.calendarHandle != 0L) {
            return this.calendarHandle;
        }
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0L) {
            return this.textEntryHandle;
        }
        return super.focusHandle();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.isCalendar()) {
            this.hookEventsForCalendar();
        } else {
            int n = 772;
            OS.gtk_widget_add_events(this.textEntryHandle, n);
            if ((this.style & 4) == 0) {
                this.hookEventsForDateTimeSpinner();
            }
            if (OS.G_OBJECT_TYPE(this.textEntryHandle) == OS.GTK_TYPE_MENU()) {
                this.hookEventsForMenu();
            }
        }
    }

    private final void hookEventsForCalendar() {
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected, this.display.getClosure(61), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected_double_click, this.display.getClosure(66), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.month_changed, this.display.getClosure(62), false);
    }

    private final void hookEventsForDateTimeSpinner() {
        OS.g_signal_connect_closure(this.textEntryHandle, OS.output, this.display.getClosure(36), true);
        OS.g_signal_connect_closure(this.textEntryHandle, OS.focus_in_event, this.display.getClosure(21), true);
    }

    private final void hookEventsForMenu() {
        OS.g_signal_connect_closure(this.down.handle, OS.selection_done, this.display.getClosure(68), true);
    }

    void incrementField(int n) {
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.calendar.get(n2);
        if (n2 == 10) {
            int n4 = this.calendar.getMaximum(10);
            int n5 = this.calendar.getMinimum(10);
            if (n3 == n4 && n == 1 || n3 == n5 && n == -1) {
                int n6 = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = n6;
            }
        }
        this.setTextField(n2, n3 + n, true, true);
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    private boolean isCalendar() {
        return (this.style & 0x400) != 0;
    }

    private boolean isDateWithDropDownButton() {
        return (this.style & 4) != 0 && (this.style & 0x20) != 0;
    }

    private static boolean isDateWithDropDownButton(int n) {
        return (n & 4) != 0 && (n & 0x20) != 0;
    }

    private boolean isDate() {
        return (this.style & 0x20) != 0;
    }

    private boolean isTime() {
        return (this.style & 0x80) != 0;
    }

    private boolean isReadOnly() {
        return (this.style & 8) != 0;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getSpokenText();
            }

            @Override
            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = DateTime.this.isCalendar() ? 41 : 42;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            @Override
            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int n, int n2) {
        Calendar calendar = this.isCalendar() ? Calendar.getInstance() : this.calendar;
        int n3 = calendar.getActualMinimum(n);
        int n4 = calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    boolean isValidDate(int n, int n2, int n3) {
        if (n < 1752 || n > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar.get(1) == n && calendar.get(2) == n2 && calendar.get(5) == n3;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int n = this.popupCalendar.getYear();
                int n2 = this.popupCalendar.getMonth();
                int n3 = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(n, n2, n3);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.popupCalendar.monthChanged) {
                    this.popupCalendar.monthChanged = false;
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int n = this.popupCalendar.getYear();
                int n4 = this.popupCalendar.getMonth();
                int n5 = this.popupCalendar.getDay();
                this.setDate(n, n4, n5);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
                break;
            }
        }
    }

    void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.addFilter(15, this.popupFilter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.down || control == this.popupCalendar) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.removeFilter(3, this.mouseEventListener);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectField(int n) {
        if (n != this.currentField) {
            this.commitCurrentField();
        }
        int n2 = this.fieldIndices[n].x;
        int n3 = this.fieldIndices[n].y;
        Point point = this.getSelection();
        if (n == this.currentField && n2 == point.x && n3 == point.y) {
            return;
        }
        this.currentField = n;
        this.display.syncExec(() -> {
            if (this.textEntryHandle != 0L) {
                String string = this.getText(this.getText(), n2, n3 - 1);
                int n3 = string.lastIndexOf(32);
                n3 = n3 == -1 ? n2 : n2 + n3 + 1;
                this.setSelection(n3, n3);
            }
        });
    }

    void sendSelectionEvent() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.calendarHandle, nArray, nArray2, nArray3);
        if (nArray3[0] != this.day || nArray2[0] != this.month || nArray[0] != this.year) {
            this.year = nArray[0];
            this.month = nArray2[0];
            this.day = nArray3[0];
            if (this.year == Calendar.getInstance().get(1) && this.month == Calendar.getInstance().get(2)) {
                OS.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
            } else {
                OS.gtk_calendar_clear_marks(this.calendarHandle);
            }
            this.sendSelectionEvent(13);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (!OS.GTK3 && this.isCalendar() && color == null) {
            OS.gtk_widget_modify_base(this.containerHandle, 0, null);
        }
        this.bg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        if (this.isCalendar() && !OS.GTK3) {
            OS.gtk_widget_modify_base(this.containerHandle, 0, gdkColor);
        } else if (this.isCalendar() && OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            super.setBackgroundColor(this.calendarHandle, gdkColor);
        } else {
            super.setBackgroundColor(gdkColor);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isDateWithDropDownButton()) {
            this.down.setEnabled(bl);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA gdkRGBA = null;
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
            }
            this.setForegroundColor(this.containerHandle, gdkRGBA);
        } else {
            this.setForegroundColor(this.containerHandle, gdkColor, false);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setFieldOfInternalDataStructure(int n, int n2) {
        if (this.calendar.get(n) == n2) {
            return;
        }
        if (n == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(n, n2);
        if (this.calendar.get(n) != n2) {
            this.calendar.set(n, n2);
        }
        this.sendSelectionEvent(13);
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidDate(n, n2, n3)) {
            return;
        }
        if (this.isCalendar()) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            OS.gtk_calendar_select_month(this.calendarHandle, n2, n);
            OS.gtk_calendar_select_day(this.calendarHandle, n3);
        } else {
            this.calendar.set(n, n2, n3);
            this.updateControl();
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), n)) {
            return;
        }
        if (this.isCalendar()) {
            this.day = n;
            OS.gtk_calendar_select_day(this.calendarHandle, n);
        } else {
            this.calendar.set(5, n);
            this.updateControl();
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = n;
        } else {
            this.calendar.set(11, n);
            this.updateControl();
        }
    }

    @Override
    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.down != null) {
            this.down.setMenu(menu);
        }
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValidTime(12, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.minutes = n;
        } else {
            this.calendar.set(12, n);
            this.updateControl();
        }
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), n, this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.month = n;
            OS.gtk_calendar_select_month(this.calendarHandle, n, this.year);
        } else {
            this.calendar.set(2, n);
            this.updateControl();
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValidTime(13, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.seconds = n;
        } else {
            this.calendar.set(13, n);
            this.updateControl();
        }
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (!this.isValidTime(12, n2)) {
            return;
        }
        if (!this.isValidTime(13, n3)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = n;
            this.minutes = n2;
            this.seconds = n3;
        } else {
            this.calendar.set(11, n);
            this.calendar.set(12, n2);
            this.calendar.set(13, n3);
            this.updateControl();
        }
    }

    public void setYear(int n) {
        this.checkWidget();
        if (!this.isValidDate(n, this.getMonth(), this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.year = n;
            OS.gtk_calendar_select_month(this.calendarHandle, this.month, n);
        } else {
            this.calendar.set(1, n);
            this.updateControl();
        }
    }

    @Override
    void setBoundsInPixels(int n, int n2, int n3, int n4) {
        int n5;
        if (this.isDateWithDropDownButton() && OS.GTK3) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_get_preferred_size(this.textEntryHandle, null, gtkRequisition);
            n5 = gtkRequisition.height;
            int n6 = n3 - (this.down.getSizeInPixels().x + this.getGtkBorderPadding().right);
            OS.gtk_widget_set_size_request(this.textEntryHandle, n6 >= 0 ? n6 : 0, n5);
        }
        int n7 = OS.VERSION(3, 14, 2);
        if (this.isCalendar() && OS.GTK3 && OS.GTK_VERSION < n7 && n4 > (n5 = this.computeSizeInPixels((int)-1, (int)-1, (boolean)true).y)) {
            n4 = n5;
        }
        super.setBoundsInPixels(n, n2, n3, n4);
    }

    private void setDropDownButtonSize() {
        int n;
        Rectangle rectangle = this.getClientAreaInPixels();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        Point point = this.down.computeSizeInPixels(-1, n3);
        int n4 = n = this.computeNativeSize((long)this.textEntryHandle, (int)-1, (int)-1, (boolean)false).y;
        int n5 = n2 - point.x;
        int n6 = n3 / 2 - n / 2;
        this.down.setBoundsInPixels(n5, n6, point.x, n4);
    }

    GtkBorder getGtkBorderPadding() {
        if (OS.GTK3) {
            GtkBorder gtkBorder = new GtkBorder();
            long l = OS.gtk_widget_get_style_context(this.textEntryHandle);
            if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                OS.gtk_style_context_get_padding(l, 0, gtkBorder);
            } else {
                OS.gtk_style_context_get_padding(l, OS.gtk_widget_get_state_flags(this.textEntryHandle), gtkBorder);
            }
            return gtkBorder;
        }
        GtkBorder gtkBorder = new GtkBorder();
        gtkBorder.right = 2;
        gtkBorder.left = 2;
        gtkBorder.top = 2;
        gtkBorder.bottom = 2;
        return gtkBorder;
    }

    boolean onNumberKeyInput(int n) {
        int n2;
        int n3 = this.fieldNames[this.currentField];
        int n4 = this.fieldIndices[this.currentField].x;
        int n5 = this.fieldIndices[this.currentField].y;
        int n6 = n5 - n4;
        String string = this.keyToString(n);
        if (n3 == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            if (string.equalsIgnoreCase(stringArray[0].substring(0, 1)) || string.equalsIgnoreCase(stringArray[0])) {
                this.setTextField(n3, 0, true, false);
            } else if (string.equalsIgnoreCase(stringArray[1].substring(0, 1)) || string.equalsIgnoreCase(stringArray[1])) {
                this.setTextField(n3, 1, true, false);
            }
            return false;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            String string2 = this.getText(n4, n5 - 1);
            n2 = string2.lastIndexOf(32);
            if (n2 != -1) {
                string2 = string2.substring(n2 + 1);
            }
            string = "" + string2 + string;
        }
        int n7 = string.length();
        n2 = this.characterCount == 0 ? 1 : 0;
        this.characterCount = n7 < n6 ? n7 : 0;
        int n8 = this.calendar.getActualMaximum(n3);
        int n9 = this.calendar.getActualMinimum(n3);
        int n10 = this.unformattedIntValue(n3, string, this.characterCount == 0, n8);
        if (n10 == -1) {
            this.characterCount = 0;
            return false;
        }
        if (n2 != 0 && n10 == 0 && n6 > 1) {
            this.setTextField(n3, n10, false, false);
        } else if (n9 <= n10 && n10 <= n8) {
            if (n3 == 2 && n2 != 0) {
                this.setTextField(n3, n10 - 1, this.characterCount == 0, this.characterCount == 0);
            } else {
                this.setTextField(n3, n10, this.characterCount == 0, this.characterCount == 0);
            }
        } else if (n7 >= n6 && (n10 = this.unformattedIntValue(n3, string = string.substring(n7 - n6 + 1), this.characterCount == 0, n8)) != -1) {
            this.characterCount = n6 - 1;
            if (n9 <= n10 && n10 <= n8) {
                this.setTextField(n3, n10, this.characterCount == 0, true);
            }
        }
        return false;
    }

    private String keyToString(int n) {
        if (n >= 65456 && n <= 65465) {
            n -= 65408;
        }
        char c = (char)n;
        return "" + c;
    }

    int unformattedIntValue(int n, String string, boolean bl, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n == 2 && bl && --n3 == -1) {
            n3 = n2;
        }
        if (n == 10 && bl && n3 == 12) {
            n3 = 0;
        }
        return n3;
    }

    void updateControl() {
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0L) {
            this.setText(this.getFormattedString(this.style));
        }
        this.redraw();
    }

    @Override
    void register() {
        super.register();
        if (this.containerHandle != 0L) {
            this.display.addWidget(this.containerHandle, this);
        }
        if (this.textEntryHandle != 0L) {
            this.display.addWidget(this.textEntryHandle, this);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.containerHandle != 0L) {
            this.display.removeWidget(this.containerHandle);
        }
        if (this.fixedHandle != 0L) {
            this.display.removeWidget(this.fixedHandle);
        }
        if (this.textEntryHandle != 0L) {
            this.display.removeWidget(this.textEntryHandle);
        }
    }

    int getArrow(long l) {
        int n = (int)OS.gtk_adjustment_get_value(OS.gtk_spin_button_get_adjustment(l));
        int n2 = 0;
        if (this.isDate()) {
            n2 = this.getMonth() + 1;
        } else if (this.isTime() && (n2 = this.getHours() > 12 ? this.getHours() - 12 : this.getHours()) == 0) {
            n2 = 12;
        }
        if (n == 0 && this.firstTime) {
            return 0;
        }
        this.firstTime = false;
        if (n == n2) {
            return 0;
        }
        return n > n2 ? 0x1000001 : 0x1000002;
    }

    void setText(String string) {
        if (string != null) {
            byte[] byArray = Converter.wcsToMbcs(string, true);
            OS.gtk_entry_set_width_chars(this.textEntryHandle, string.length());
            OS.gtk_entry_set_text(this.textEntryHandle, byArray);
        }
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (!this.isReadOnly() && (this.isTime() || this.isDate())) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            int n = gdkEventKey.keyval;
            switch (n) {
                case 65362: 
                case 65431: {
                    this.incrementField(1);
                    this.commitCurrentField();
                    break;
                }
                case 65364: 
                case 65433: {
                    this.incrementField(-1);
                    this.commitCurrentField();
                    break;
                }
                case 65363: 
                case 65432: {
                    this.selectField((this.currentField + 1) % this.fieldCount);
                    this.sendEvent(31);
                    break;
                }
                case 65361: 
                case 65430: {
                    int n2 = this.currentField - 1;
                    this.selectField(n2 < 0 ? this.fieldCount - 1 : n2);
                    this.sendEvent(31);
                    break;
                }
                case 65360: 
                case 65429: {
                    int n3 = this.fieldNames[this.currentField];
                    this.setTextField(n3, this.calendar.getActualMinimum(n3), true, true);
                    break;
                }
                case 65367: 
                case 65436: {
                    int n4 = this.fieldNames[this.currentField];
                    this.setTextField(n4, this.calendar.getActualMaximum(n4), true, true);
                    break;
                }
                default: {
                    this.onNumberKeyInput(n);
                }
            }
        }
        return 1L;
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int n;
            this.characterCount = 0;
            int n2 = this.fieldNames[this.currentField];
            int n3 = this.fieldIndices[this.currentField].x;
            int n4 = this.fieldIndices[this.currentField].y;
            String string = this.getText(this.getText(), n3, n4 - 1);
            int n5 = string.lastIndexOf(32);
            if (n5 != -1) {
                string = string.substring(n5 + 1);
            }
            if ((n = this.unformattedIntValue(n2, string, this.characterCount == 0, this.calendar.getActualMaximum(n2))) != -1) {
                this.setTextField(n2, n, true, true);
            }
        }
    }

    Point getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_editable_get_selection_bounds(this.textEntryHandle, nArray, nArray2);
        long l = OS.gtk_entry_get_text(this.textEntryHandle);
        nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
        nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
        Point point = new Point(nArray[0], nArray2[0]);
        return point;
    }

    String getText() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            long l = OS.gtk_entry_get_text(this.textEntryHandle);
            if (l == 0L) {
                return "";
            }
            int n = OS.strlen(l);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l, (long)n);
            return new String(Converter.mbcsToWcs(byArray));
        }
        return "";
    }

    String getText(String string, int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    void setSelection(int n, int n2) {
        this.checkWidget();
        long l = OS.gtk_entry_get_text(this.textEntryHandle);
        n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
        n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
        OS.gtk_editable_set_position(this.textEntryHandle, n);
        OS.gtk_editable_select_region(this.textEntryHandle, n, n2);
    }

    void setTextField(int n, int n2, boolean bl, boolean bl2) {
        int n3 = this.fieldIndices[this.currentField].x;
        int n4 = this.fieldIndices[this.currentField].y;
        this.setSelection(n3, n4);
        if (bl) {
            int n5 = this.validateValueBounds(n, n2);
            this.setFieldOfInternalDataStructure(n, n5);
        } else {
            String string = this.formattedStringValue(n, n2, bl2);
            string = this.padWithZeros(n3, n4, string);
            this.replaceCurrentlySelectedTextRegion(string);
            this.setFieldOfInternalDataStructure(n, n2);
        }
        this.updateControl();
        this.selectField(this.currentField);
    }

    private String padWithZeros(int n, int n2, String string) {
        int n3 = n2 - n - string.length();
        for (int i = 0; i < n3; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private int validateValueBounds(int n, int n2) {
        int n3 = this.calendar.getActualMaximum(n);
        int n4 = this.calendar.getActualMinimum(n);
        if (n == 1) {
            n3 = 9999;
            n4 = 1752;
            int n5 = Calendar.getInstance().get(1);
            int n6 = n5 / 100 * 100;
            if (n2 < (n5 + 30) % 100) {
                n2 += n6;
            } else if (n2 < 100) {
                n2 += n6 - 100;
            }
        }
        if (n2 > n3) {
            n2 = n4;
        }
        if (n2 < n4) {
            n2 = n3;
        }
        return n2;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        if (this.isDate() || this.isTime()) {
            GdkEventButton gdkEventButton = this.getEventInfoFromOS(l2);
            if (gdkEventButton.button == 1) {
                this.onTextMouseClick(gdkEventButton);
                return this.gtk_button_press_event(l, l2, false);
            }
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        if (this.isDate() || this.isTime()) {
            GdkEventButton gdkEventButton = this.getEventInfoFromOS(l2);
            if (gdkEventButton.button == 1) {
                this.onTextMouseClick(gdkEventButton);
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    private GdkEventButton getEventInfoFromOS(long l) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l, (long)GdkEventButton.sizeof);
        return gdkEventButton;
    }

    @Override
    long gtk_output(long l) {
        if (this.calendar == null) {
            return 0L;
        }
        int n = this.getArrow(l);
        switch (n) {
            case 0x1000001: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: {
                this.commitCurrentField();
                this.incrementField(-1);
            }
        }
        return 1L;
    }

    void replaceCurrentlySelectedTextRegion(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(string, false);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_editable_get_selection_bounds(this.textEntryHandle, nArray, nArray2);
        OS.gtk_editable_delete_selection(this.textEntryHandle);
        OS.gtk_editable_insert_text(this.textEntryHandle, byArray, byArray.length, nArray);
        OS.gtk_editable_set_position(this.textEntryHandle, nArray[0]);
    }

    void onTextMouseClick(GdkEventButton gdkEventButton) {
        Point point = this.getSelection();
        for (int i = 0; i < this.fieldCount; ++i) {
            if (point.x < this.fieldIndices[i].x || point.x > this.fieldIndices[i].y) continue;
            this.currentField = i;
            break;
        }
        this.selectField(this.currentField);
    }

    String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    void selectAll() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            OS.gtk_editable_select_region(this.textEntryHandle, 0, -1);
        }
    }

    void hideDateTime() {
        if (this.isDate() || this.isTime()) {
            OS.gtk_widget_hide(this.fixedHandle);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.fixedHandle != 0L) {
            this.hideDateTime();
        }
    }
}

