/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Lock;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventProperty;
import org.eclipse.swt.internal.gtk.GdkKeymapKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    long[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    long fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    long eventProc;
    long filterProc;
    long windowProc2;
    long windowProc3;
    long windowProc4;
    long windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    long[] closures;
    long[] closuresProc;
    int[] closuresCount;
    int[] signalIds;
    long shellMapProcClosure;
    int[] indexTable;
    int freeSlot;
    long lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Tracker tracker;
    Control imControl;
    long preeditWindow;
    long preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Consumer<RuntimeException> runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer<Error> errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    long timerProc;
    Callback windowTimerCallback;
    long windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    long caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    long mouseHoverHandle;
    long mouseHoverProc;
    Callback mouseHoverCallback;
    long sizeAllocateProc;
    Callback sizeAllocateCallback;
    long sizeRequestProc;
    Callback sizeRequestCallback;
    long shellMapProc;
    Callback shellMapCallback;
    long idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    long cellDataProc;
    Callback cellDataCallback;
    long setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    long emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    long allChildrenProc;
    long allChildren;
    Callback allChildrenCallback;
    long signalProc;
    Callback signalCallback;
    long shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_SET = 1;
    static final int PROPERTY_NOTIFY = 2;
    boolean entrySelectOnFocus;
    Control currentControl;
    long checkIfEventProc;
    Callback checkIfEventCallback;
    long flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    long[] flushData = new long[1];
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_LIST_SELECTION_INACTIVE;
    GdkColor COLOR_LIST_SELECTION_TEXT_INACTIVE;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_LINK_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    ArrayList<String> colorList;
    final int SWT_COLOR_LIST_SELECTION_TEXT_INACTIVE = 38;
    final int SWT_COLOR_LIST_SELECTION_INACTIVE = 39;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    long pangoLayoutNewProc;
    long pangoFontFamilyNewProc;
    long pangoFontFaceNewProc;
    long imContextNewProc;
    long printerOptionWidgetNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static long fixed_type;
    static long fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static Callback fixedSizeAllocateCallback;
    static long fixedClassInitProc;
    static long fixedMapProc;
    static long fixedSizeAllocateProc;
    static long oldFixedSizeAllocateProc;
    static long text_renderer_type;
    static long pixbuf_renderer_type;
    static long toggle_renderer_type;
    static long text_renderer_info_ptr;
    static long pixbuf_renderer_info_ptr;
    static long toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererGetSizeCallback;
    static Callback rendererGetPreferredWidthCallback;
    static long rendererClassInitProc;
    static long rendererRenderProc;
    static long rendererGetSizeProc;
    static long rendererGetPreferredWidthProc;
    static final int[][] KeyTable;
    private int latinKeyGroup;
    long keysChangedProc;
    Callback keysChangedCallback;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int GTK3_MAJOR = 3;
    static final int GTK3_MINOR = 0;
    static final int GTK3_MICRO = 0;
    static final int GTK2_MAJOR = 2;
    static final int GTK2_MINOR = 24;
    static final int GTK2_MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    static final int TRIM_NONE = 0;
    static final int TRIM_BORDER = 1;
    static final int TRIM_RESIZE = 2;
    static final int TRIM_TITLE_BORDER = 3;
    static final int TRIM_TITLE_RESIZE = 4;
    static final int TRIM_TITLE = 5;
    int[] trimWidths = new int[6];
    int[] trimHeights = new int[6];
    boolean ignoreTrim;
    String windowManager;

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
        File file;
        this.trimWidths[0] = 0;
        this.trimHeights[0] = 0;
        this.trimWidths[1] = 4;
        this.trimHeights[1] = 4;
        this.trimWidths[2] = 6;
        this.trimHeights[2] = 6;
        this.trimWidths[3] = 5;
        this.trimHeights[3] = 28;
        this.trimWidths[4] = 6;
        this.trimHeights[4] = 29;
        this.trimWidths[5] = 0;
        this.trimHeights[5] = 23;
        String string = System.getProperty("user.home");
        if (string != null && (file = new File(string, ".swt/trims.prefs")).exists() && file.isFile()) {
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
                String string2 = properties.getProperty("trimWidths");
                String string3 = properties.getProperty("trimHeights");
                if (string2 != null && string3 != null) {
                    int n;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    for (n = 0; n < this.trimWidths.length && stringTokenizer.hasMoreTokens(); ++n) {
                        this.trimWidths[n] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    stringTokenizer = new StringTokenizer(string3);
                    for (n = 0; n < this.trimHeights.length && stringTokenizer.hasMoreTokens(); ++n) {
                        this.trimHeights[n] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    void addGdkEvent(long l) {
        int n;
        if (this.gdkEvents == null) {
            n = 1024;
            this.gdkEvents = new long[n];
            this.gdkEventWidgets = new Widget[n];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            n = this.gdkEventCount + 1024;
            long[] lArray = new long[n];
            System.arraycopy(this.gdkEvents, 0, lArray, 0, this.gdkEventCount);
            this.gdkEvents = lArray;
            Widget[] widgetArray = new Widget[n];
            System.arraycopy(this.gdkEventWidgets, 0, widgetArray, 0, this.gdkEventCount);
            this.gdkEventWidgets = widgetArray;
        }
        Widget widget = null;
        long l2 = OS.gtk_get_event_widget(l);
        if (l2 != 0L) {
            while ((widget = this.getWidget(l2)) == null && (l2 = OS.gtk_widget_get_parent(l2)) != 0L) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = l;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = OS.g_idle_add(this.idleProc, 0L);
            }
        }
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    long allChildrenProc(long l, long l2) {
        this.allChildren = OS.g_list_append(this.allChildren, l);
        if (l2 != 0L && OS.GTK_IS_CONTAINER(l)) {
            OS.gtk_container_forall(l, this.allChildrenProc, l2);
        }
        return 0L;
    }

    void addMouseHoverTimeout(long l) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = OS.g_timeout_add(400, this.mouseHoverProc, l);
        this.mouseHoverHandle = l;
    }

    void addPopup(Menu menu) {
        int n;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n2 = this.popups.length;
        for (n = 0; n < n2; ++n) {
            if (this.popups[n] != menu) continue;
            return;
        }
        for (n = 0; n < n2 && this.popups[n] != null; ++n) {
        }
        if (n == n2) {
            Menu[] menuArray = new Menu[n2 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n2);
            this.popups = menuArray;
        }
        this.popups[n] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(long l, Widget widget) {
        int n;
        if (l == 0L) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n = this.freeSlot + 1024;
            int[] nArray = new int[n];
            Widget[] widgetArray = new Widget[n];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            for (int i = this.freeSlot; i < n - 1; ++i) {
                nArray[i] = i + 1;
            }
            nArray[n - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        n = this.freeSlot + 1;
        OS.g_object_set_qdata(l, SWT_OBJECT_INDEX, n);
        int n2 = this.freeSlot;
        this.freeSlot = this.indexTable[n2];
        this.indexTable[n2] = -2;
        this.widgetTable[n2] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0L);
                }
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        if (!OS.isX11()) {
            OS.gdk_flush();
        } else {
            long l = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            OS.XFlush(l);
        }
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        Widget widget = this.getWidget(l5);
        if (widget == null) {
            return 0L;
        }
        return widget.cellDataProc(l, l2, l3, l4, l5);
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] == null) continue;
                if (!bl) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread != thread) continue;
                SWT.error(22);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long checkIfEventProc(long l, long l2, long l3) {
        int n = OS.X_EVENT_TYPE(l2);
        switch (n) {
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0L;
            }
        }
        long l4 = OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), OS.X_EVENT_WINDOW(l2));
        if (l4 == 0L) {
            return 0L;
        }
        if (this.flushWindow != 0L) {
            if (this.flushAll) {
                long l5 = l4;
                while (l5 != this.flushWindow && (l5 = OS.gdk_window_get_parent(l5)) != 0L) {
                }
                if (l5 != this.flushWindow) {
                    return 0L;
                }
            } else if (l4 != this.flushWindow) {
                return 0L;
            }
        }
        OS.memmove(this.exposeEvent, l2, (long)XExposeEvent.sizeof);
        switch (n) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = Math.max(0, this.exposeEvent.width);
                this.flushRect.height = Math.max(0, this.exposeEvent.height);
                OS.gdk_window_invalidate_rect(l4, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(l2, this.exposeEvent, (long)XExposeEvent.sizeof);
            }
        }
        return 0L;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        int n;
        if (this.modalShells == null) {
            return;
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2 && this.modalShells[n] != shell; ++n) {
            if (this.modalShells[n] != null) continue;
            return;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        byte[] byArray;
        int n;
        long l;
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        if (!OS.gtk_init_check(new long[]{0L}, null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        System.setProperty("org.eclipse.swt.internal.gtk.theme", OS.getThemeName());
        if (OS.isX11()) {
            this.xDisplay = OS.gdk_x11_get_default_xdisplay();
        }
        if ((l = (n = OS.gtk_major_version()) == 3 ? OS.gtk_check_version(3, 0, 0) : OS.gtk_check_version(2, 24, 0)) != 0L) {
            int n2 = OS.strlen(l);
            byArray = new byte[n2];
            OS.memmove(byArray, l, (long)n2);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(byArray)));
            System.out.println("***WARNING: SWT requires GTK 2.24.0");
            int n3 = OS.gtk_minor_version();
            int n4 = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + n + "." + n3 + "." + n4);
        }
        if (OS.GTK3) {
            fixed_type = OS.swt_fixed_get_type();
        }
        if (fixed_type == 0L) {
            byte[] byArray2 = Converter.wcsToMbcs("SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0L) {
                this.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((fixedSizeAllocateProc = (fixedSizeAllocateCallback = new Callback(this.getClass(), "fixedSizeAllocateProc", 2)).getAddress()) == 0L) {
                this.error(3);
            }
            long l2 = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(OS.GTK_TYPE_FIXED(), l2);
            GTypeQuery gTypeQuery = new GTypeQuery();
            OS.memmove(gTypeQuery, l2, (long)GTypeQuery.sizeof);
            OS.g_free(l2);
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)gTypeQuery.class_size;
            gTypeInfo.class_init = fixedClassInitProc;
            gTypeInfo.instance_size = (short)gTypeQuery.instance_size;
            fixed_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(fixed_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static(OS.GTK_TYPE_FIXED(), byArray2, fixed_info_ptr, 0);
        }
        if (rendererClassInitProc == 0L && (rendererClassInitProc = (rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2)).getAddress()) == 0L) {
            this.error(3);
        }
        if (rendererRenderProc == 0L && (rendererRenderProc = (rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", OS.GTK3 ? 6 : 7)).getAddress()) == 0L) {
            this.error(3);
        }
        if (OS.GTK3) {
            if (rendererGetPreferredWidthProc == 0L && (rendererGetPreferredWidthProc = (rendererGetPreferredWidthCallback = new Callback(this.getClass(), "rendererGetPreferredWidthProc", 4)).getAddress()) == 0L) {
                this.error(3);
            }
        } else if (rendererGetSizeProc == 0L && (rendererGetSizeProc = (rendererGetSizeCallback = new Callback(this.getClass(), "rendererGetSizeProc", 7)).getAddress()) == 0L) {
            this.error(3);
        }
        if (text_renderer_type == 0L) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererTextClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs("SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TEXT(), byArray, text_renderer_info_ptr, 0);
        }
        if (pixbuf_renderer_type == 0L) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererPixbufClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererPixbuf_sizeof();
            pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(pixbuf_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs("SwtPixbufRenderer", true);
            pixbuf_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_PIXBUF(), byArray, pixbuf_renderer_info_ptr, 0);
        }
        if (toggle_renderer_type == 0L) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererToggleClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererToggle_sizeof();
            toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(toggle_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs("SwtToggleRenderer", true);
            toggle_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TOGGLE(), byArray, toggle_renderer_info_ptr, 0);
        }
        OS.gtk_widget_set_default_direction(1);
        byte[] byArray3 = Converter.wcsToMbcs(APP_NAME, true);
        OS.g_set_prgname(byArray3);
        OS.gdk_set_program_class(byArray3);
        if (!OS.GTK3) {
            byArray = Converter.wcsToMbcs("style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*.swt-toolbar-flat\" style : highest \"swt-flat\"", true);
            OS.gtk_rc_parse_string(byArray);
        }
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0L) {
            this.error(3);
        }
        OS.gdk_event_handler_set(this.eventProc, 0L, 0L);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0L) {
            this.error(3);
        }
        OS.gdk_window_add_filter(0L, this.filterProc, 0L);
        byArray = Converter.wcsToMbcs("SWT_Window_" + APP_NAME, true);
        long l3 = OS.gdk_atom_intern(byArray, false);
        OS.gdk_selection_owner_set(OS.gtk_widget_get_window(this.shellHandle), l3, 0, false);
        OS.gdk_selection_owner_get(l3);
        this.signalCallback = new Callback(this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (this.signalProc == 0L) {
            this.error(3);
        }
        OS.gtk_widget_add_events(this.shellHandle, 65536);
        OS.g_signal_connect(this.shellHandle, OS.property_notify_event, this.signalProc, 2L);
        this.latinKeyGroup = this.findLatinKeyGroup();
        this.keysChangedCallback = new Callback(this, "keysChangedProc", 2);
        this.keysChangedProc = this.keysChangedCallback.getAddress();
        if (this.keysChangedProc == 0L) {
            this.error(3);
        }
        OS.g_signal_connect(OS.gdk_keymap_get_default(), OS.keys_changed, this.keysChangedProc, 0L);
    }

    private int findLatinKeyGroup() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        long l = OS.gdk_keymap_get_default();
        for (n = 97; n <= 122; ++n) {
            object3 = new long[1];
            object2 = new int[1];
            if (!OS.gdk_keymap_get_entries_for_keyval(l, n, object3, object2)) continue;
            object = new GdkKeymapKey();
            for (int i = 0; i < object2[0]; ++i) {
                OS.memmove((GdkKeymapKey)object, (long)(object3[0] + (long)(i * GdkKeymapKey.sizeof)), (long)GdkKeymapKey.sizeof);
                Integer n3 = (Integer)hashMap.get(((GdkKeymapKey)object).group);
                if (n3 != null) {
                    Integer n4 = n3;
                    Integer n5 = n3 = Integer.valueOf(n3 + 1);
                } else {
                    n3 = 1;
                }
                hashMap.put(((GdkKeymapKey)object).group, n3);
            }
            OS.g_free((long)object3[0]);
        }
        n = 0;
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (Integer)object2.getKey();
            Integer n6 = (Integer)object2.getValue();
            if (n6 <= n) continue;
            n2 = (Integer)object;
            n = n6;
        }
        return n2;
    }

    int getLatinKeyGroup() {
        return this.latinKeyGroup;
    }

    long keysChangedProc(long l, long l2) {
        this.latinKeyGroup = this.findLatinKeyGroup();
        return 0L;
    }

    Image createImage(String string) {
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l = OS.gtk_icon_theme_load_icon(OS.gtk_icon_theme_get_default(), byArray, 48, 4, 0L);
        if (l == 0L) {
            return null;
        }
        int n = OS.gdk_pixbuf_get_width(l);
        int n2 = OS.gdk_pixbuf_get_height(l);
        int n3 = OS.gdk_pixbuf_get_rowstride(l);
        boolean bl = OS.gdk_pixbuf_get_has_alpha(l);
        long l2 = OS.gdk_pixbuf_get_pixels(l);
        byte[] byArray2 = new byte[n3 * n2];
        OS.memmove(byArray2, l2, (long)byArray2.length);
        OS.g_object_unref(l);
        ImageData imageData = null;
        if (bl) {
            PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(n, n2, 32, paletteData);
            byte[] byArray3 = new byte[n3 * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray3[i * n + j] = byArray2[i * n3 + j * 4 + 3];
                    byArray2[i * n3 + j * 4 + 3] = 0;
                }
            }
            imageData.setAlphas(0, 0, n * n2, byArray3, 0);
        } else {
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(n, n2, 24, paletteData);
        }
        imageData.data = byArray2;
        imageData.bytesPerLine = n3;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (display != Displays[i]) continue;
                Display.Displays[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    long emissionProc(long l, long l2, long l3, long l4) {
        if (OS.gtk_widget_get_toplevel(OS.g_value_peek_pointer(l3)) == l4) {
            OS.gtk_widget_set_direction(OS.g_value_peek_pointer(l3), 2);
        }
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                Display display = Displays[i];
                if (display == null || display.thread != thread) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return display;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    long eventProc(long l, long l2) {
        int n = OS.gdk_event_get_time(l);
        if (n != 0) {
            this.lastEventTime = n;
        }
        int n2 = OS.GDK_EVENT_TYPE(l);
        switch (n2) {
            case 4: 
            case 8: {
                this.lastUserEventTime = n;
            }
        }
        boolean bl = true;
        if (this.dispatchEvents != null) {
            bl = false;
            for (int i = 0; i < this.dispatchEvents.length; ++i) {
                if (n2 != this.dispatchEvents[i]) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.addGdkEvent(OS.gdk_event_copy(l));
            return 0L;
        }
        bl = true;
        if (this.tracker != null) {
            bl = this.tracker.processEvent(l);
        }
        if (bl) {
            OS.gtk_main_do_event(l);
        }
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0L;
    }

    public Widget findWidget(long l) {
        this.checkDevice();
        return this.getWidget(l);
    }

    public Widget findWidget(long l, long l2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, long l) {
        this.checkDevice();
        return null;
    }

    static long fixedClassInitProc(long l, long l2) {
        GtkWidgetClass gtkWidgetClass = new GtkWidgetClass();
        OS.memmove(gtkWidgetClass, l);
        gtkWidgetClass.map = fixedMapProc;
        oldFixedSizeAllocateProc = gtkWidgetClass.size_allocate;
        gtkWidgetClass.size_allocate = fixedSizeAllocateProc;
        OS.memmove(l, gtkWidgetClass);
        return 0L;
    }

    static long fixedMapProc(long l) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l);
        if (widget != null) {
            return widget.fixedMapProc(l);
        }
        return 0L;
    }

    static long fixedSizeAllocateProc(long l, long l2) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l);
        if (widget != null) {
            return widget.fixedSizeAllocateProc(l, l2);
        }
        return OS.Call(oldFixedSizeAllocateProc, l, l2);
    }

    static long rendererClassInitProc(long l, long l2) {
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l);
        gtkCellRendererClass.render = rendererRenderProc;
        if (OS.GTK3) {
            gtkCellRendererClass.get_preferred_width = rendererGetPreferredWidthProc;
        } else {
            gtkCellRendererClass.get_size = rendererGetSizeProc;
        }
        OS.memmove(l, gtkCellRendererClass);
        return 0L;
    }

    static long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l2);
        if (widget != null) {
            return widget.rendererGetPreferredWidthProc(l, l2, l3, l4);
        }
        return 0L;
    }

    static long rendererGetSizeProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l2);
        if (widget != null) {
            return widget.rendererGetSizeProc(l, l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    static long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l3);
        if (widget != null) {
            return widget.rendererRenderProc(l, l2, l3, l4, l5, l6);
        }
        return 0L;
    }

    static long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l3);
        if (widget != null) {
            return widget.rendererRenderProc(l, l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    void flushExposes(long l, boolean bl) {
        OS.gdk_flush();
        OS.gdk_flush();
        if (OS.isX11()) {
            this.flushWindow = l;
            this.flushAll = bl;
            long l2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            long l3 = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(l2, l3, this.checkIfEventProc, 0L);
            OS.g_free(l3);
            this.flushWindow = 0L;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        long l = OS.gtk_settings_get_default();
        if (l == 0L) {
            return 500;
        }
        int[] nArray = new int[1];
        OS.g_object_get(l, OS.gtk_cursor_blink, nArray, 0L);
        if (nArray[0] == 0) {
            return 0;
        }
        OS.g_object_get(l, OS.gtk_cursor_blink_time, nArray, 0L);
        if (nArray[0] == 0) {
            return 500;
        }
        return nArray[0] / 2;
    }

    long getClosure(int n) {
        if (OS.GLIB_VERSION >= OS.VERSION(2, 36, 0)) {
            int n2 = n;
            this.closuresCount[n2] = this.closuresCount[n2] + 1;
            if (this.closuresCount[n2] >= 255) {
                if (this.closures[n] != 0L) {
                    OS.g_closure_unref(this.closures[n]);
                }
                this.closures[n] = OS.g_cclosure_new(this.closuresProc[n], n, 0L);
                OS.g_closure_ref(this.closures[n]);
                OS.g_closure_sink(this.closures[n]);
                this.closuresCount[n] = 0;
            }
        }
        return this.closures[n];
    }

    public Control getCursorControl() {
        Object object;
        Object object2;
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l = 0L;
        long[] lArray = new long[1];
        long l2 = this.gdk_device_get_window_at_position(nArray, nArray2);
        if (l2 != 0L) {
            OS.gdk_window_get_user_data(l2, lArray);
            l = lArray[0];
        } else {
            long l3;
            if (!OS.isX11()) {
                return null;
            }
            OS.gdk_error_trap_push();
            object2 = new int[1];
            object = new long[1];
            long[] lArray2 = new long[1];
            long l4 = OS.XDefaultRootWindow(this.xDisplay);
            do {
                if (OS.XQueryPointer(this.xDisplay, l4, (long[])object, lArray2, object2, object2, object2, object2, object2) == 0) {
                    l = 0L;
                    break;
                }
                l3 = lArray2[0];
                if (l3 == 0L) continue;
                l4 = l3;
                long l5 = OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), l3);
                if (l5 == 0L) continue;
                OS.gdk_window_get_user_data(l5, lArray);
                if (lArray[0] == 0L) continue;
                l = lArray[0];
            } while (l3 != 0L);
            OS.gdk_error_trap_pop();
        }
        if (l == 0L) {
            return null;
        }
        do {
            if ((object2 = (Object)this.getWidget(l)) == null || !(object2 instanceof Control) || !((Control)(object = (Object)((Control)object2))).isEnabled()) continue;
            return object;
        } while ((l = OS.gtk_widget_get_parent(l)) != 0L);
        return null;
    }

    static GtkBorder getEntryInnerBorder(long l) {
        GtkBorder gtkBorder = new GtkBorder();
        long l2 = OS.gtk_entry_get_inner_border(l);
        if (l2 != 0L) {
            OS.memmove(gtkBorder, l2, (long)GtkBorder.sizeof);
            return gtkBorder;
        }
        long[] lArray = new long[1];
        OS.gtk_widget_style_get(l, OS.inner_border, lArray, 0L);
        if (lArray[0] != 0L) {
            OS.memmove(gtkBorder, lArray[0], (long)GtkBorder.sizeof);
            OS.gtk_border_free(lArray[0]);
            return gtkBorder;
        }
        gtkBorder.left = 2;
        gtkBorder.top = 2;
        gtkBorder.right = 2;
        gtkBorder.bottom = 2;
        return gtkBorder;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int n = event.type;
            this.sendPreEvent(n);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(n);
            }
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    long filterProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return 0L;
        }
        return widget.filterProc(l, l2, l3);
    }

    public Point getCursorLocation() {
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_device_position(0L, nArray, nArray2, null);
        if (!OS.isX11() && this.activeShell != null) {
            Shell shell = this.activeShell;
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            while (shell.getParent() != null) {
                OS.gtk_window_get_position(shell.shellHandle, nArray3, nArray4);
                nArray[0] = nArray[0] + nArray3[0];
                nArray2[0] = nArray2[0] + nArray4[0];
                shell = shell.getParent().getShell();
            }
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (string.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (string.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (string.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    long gtk_fixed_get_type() {
        return fixed_type;
    }

    long gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    long gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    long gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    String gtk_css_create_css_color_string(String string, String string2, int n) {
        switch (n) {
            case 16: {
                if (string2 != null && string != null) {
                    return string2 + "\n" + string;
                }
                if (string2 != null) {
                    return string2;
                }
                return "";
            }
            case 8: {
                if (string2 != null && string != null) {
                    return string + "\n" + string2;
                }
                if (string != null) {
                    return string;
                }
                return "";
            }
        }
        return "";
    }

    String gtk_css_default_theme_values(int n) {
        byte[] byArray = OS.getThemeNameBytes();
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        long l = OS.gtk_css_provider_get_named(byArray, null);
        long l2 = OS.gtk_css_provider_to_string(l);
        int n2 = OS.strlen(l2);
        if (n2 == 0) {
            return "";
        }
        byArray = new byte[n2];
        OS.memmove(byArray, l2, (long)n2);
        String string = new String(Converter.mbcsToWcs(byArray));
        String string2 = "";
        switch (n) {
            case 28: {
                int n3 = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? string.indexOf("tooltip * {") : string.indexOf(".tooltip {");
                int n4 = string.indexOf("@define-color tooltip_fg_color");
                if (n3 != -1) {
                    this.COLOR_INFO_FOREGROUND = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.gtk_css_parse_foreground(l, "tooltip * {") : this.gtk_css_parse_foreground(l, ".tooltip {");
                    return "parsed";
                }
                if (n4 == -1 || (string2 = this.simple_color_parser(string, "@define-color tooltip_fg_color", n4)).isEmpty()) break;
                break;
            }
            case 29: {
                int n5 = string.indexOf("tooltip.background {");
                int n6 = string.indexOf("@define-color tooltip_bg_color");
                if (n5 != -1) {
                    this.COLOR_INFO_BACKGROUND = this.gtk_css_parse_background(l, "tooltip.background {");
                    return "parsed";
                }
                if (n6 == -1 || (string2 = this.simple_color_parser(string, "@define-color tooltip_bg_color", n6)).isEmpty()) break;
                break;
            }
            case 25: {
                int n7 = string.indexOf("@define-color theme_base_color");
                int n8 = string.indexOf("@define-color base_color");
                if (!(n7 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_base_color", n7)).isEmpty() : n8 != -1 && !(string2 = this.simple_color_parser(string, "@define-color base_color", n8)).isEmpty())) break;
                break;
            }
            case 24: {
                int n9 = string.indexOf("@define-color theme_text_color");
                int n10 = string.indexOf("@define-color text_color");
                if (!(n9 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_text_color", n9)).isEmpty() : n10 != -1 && !(string2 = this.simple_color_parser(string, "@define-color text_color", n10)).isEmpty())) break;
                break;
            }
            case 26: {
                int n11 = string.indexOf("@define-color theme_selected_bg_color");
                int n12 = string.indexOf("@define-color selected_bg_color");
                if (!(n11 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_selected_bg_color", n11)).isEmpty() : n12 != -1 && !(string2 = this.simple_color_parser(string, "@define-color selected_bg_color", n12)).isEmpty())) break;
                break;
            }
            case 39: {
                int n13 = string.indexOf("@define-color theme_unfocused_selected_bg_color");
                if (n13 == -1 || (string2 = this.simple_color_parser(string, "@define-color theme_unfocused_selected_bg_color", n13)).isEmpty()) break;
                break;
            }
            case 27: {
                int n14 = string.indexOf("@define-color theme_selected_fg_color");
                int n15 = string.indexOf("@define-color selected_fg_color");
                if (!(n14 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_selected_fg_color", n14)).isEmpty() : n15 != -1 && !(string2 = this.simple_color_parser(string, "@define-color selected_fg_color", n15)).isEmpty())) break;
                break;
            }
            case 38: {
                int n16 = string.indexOf("@define-color theme_unfocused_selected_fg_color");
                if (n16 == -1 || (string2 = this.simple_color_parser(string, "@define-color theme_unfocused_selected_fg_color", n16)).isEmpty()) break;
                break;
            }
            case 33: {
                int n17 = string.indexOf("@define-color insensitive_fg_color");
                if (n17 == -1 || (string2 = this.simple_color_parser(string, "@define-color insensitive_fg_color", n17)).isEmpty()) break;
                break;
            }
            case 34: {
                int n18 = string.indexOf("@define-color insensitive_bg_color");
                if (n18 == -1 || (string2 = this.simple_color_parser(string, "@define-color insensitive_bg_color", n18)).isEmpty()) break;
                break;
            }
            case 22: {
                int n19 = string.indexOf("@define-color theme_bg_color");
                int n20 = string.indexOf("@define-color bg_color");
                if (!(n19 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_bg_color", n19)).isEmpty() : n20 != -1 && !(string2 = this.simple_color_parser(string, "@define-color bg_color", n20)).isEmpty())) break;
                break;
            }
            case 21: {
                int n21 = string.indexOf("@define-color theme_fg_color");
                int n22 = string.indexOf("@define-color fg_color");
                if (!(n21 != -1 ? !(string2 = this.simple_color_parser(string, "@define-color theme_fg_color", n21)).isEmpty() : n22 != -1 && !(string2 = this.simple_color_parser(string, "@define-color fg_color", n22)).isEmpty())) break;
                break;
            }
            default: {
                return "";
            }
        }
        return string2;
    }

    GdkColor gtk_css_parse_background(long l, String string) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        long l2 = OS.gtk_css_provider_to_string(l);
        if (l2 == 0L) {
            return this.COLOR_WIDGET_BACKGROUND;
        }
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        String string3 = "";
        if (string != null) {
            if (string2.contains(string)) {
                string3 = string2.substring(string2.indexOf(string));
            }
        } else {
            string3 = string2;
        }
        if (string3.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND;
        }
        if (string3.contains("background-color:")) {
            int n2 = string3.indexOf("background-color:");
            String string4 = string3.substring(n2 + 18);
            gdkRGBA = this.gtk_css_property_to_rgba(string4);
        } else if (string3.contains("background:")) {
            int n3 = string3.indexOf("background:");
            String string5 = string3.substring(n3 + 13);
            gdkRGBA = this.gtk_css_property_to_rgba(string5);
        }
        return this.toGdkColor(gdkRGBA);
    }

    GdkColor gtk_css_parse_foreground(long l, String string) {
        if (l == 0L) {
            return this.COLOR_WIDGET_FOREGROUND;
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        long l2 = OS.gtk_css_provider_to_string(l);
        if (l2 == 0L) {
            return this.COLOR_WIDGET_FOREGROUND;
        }
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        String string3 = "";
        if (string != null) {
            if (string2.contains(string)) {
                string3 = string2.substring(string2.indexOf(string));
            }
        } else {
            string3 = string2;
        }
        if (string3.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND;
        }
        String string4 = "[^-]color: rgb[a]?\\([0-9]+,[\\s]?[0-9]+,[\\s]?[0-9]+[,[\\s]*[0-9]+]?\\)";
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find()) {
            String string5 = matcher.group(0);
            if (string5.contains("color:")) {
                int n2 = string5.indexOf("color:");
                String string6 = string5.substring(n2 + 7);
                gdkRGBA = this.gtk_css_property_to_rgba(string6);
            }
        } else {
            return this.COLOR_WIDGET_FOREGROUND;
        }
        return this.toGdkColor(gdkRGBA);
    }

    GdkRGBA gtk_css_property_to_rgba(String string) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        String[] stringArray = new String[1];
        stringArray = string.split(";");
        OS.gdk_rgba_parse(gdkRGBA, Converter.wcsToMbcs(stringArray[0], true));
        return gdkRGBA;
    }

    String gtk_rgba_to_css_string(GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2;
        if (gdkRGBA != null) {
            gdkRGBA2 = gdkRGBA;
        } else {
            GdkColor gdkColor = this.getSystemColor((int)22).handle;
            gdkRGBA2 = this.toGdkRGBA(gdkColor);
        }
        long l = OS.gdk_rgba_to_string(gdkRGBA2);
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    String gtk_widget_get_name(long l) {
        String string;
        long l2 = OS.gtk_widget_get_name(l);
        if (l2 == 0L) {
            string = "*";
        } else {
            int n = OS.strlen(l2);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            string = new String(Converter.mbcsToWcs(byArray));
        }
        return string;
    }

    String gtk_widget_class_get_css_name(long l) {
        String string;
        long l2 = OS.gtk_widget_class_get_css_name(OS.GTK_WIDGET_GET_CLASS(l));
        if (l2 == 0L) {
            string = "*";
        } else {
            int n = OS.strlen(l2);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            string = new String(Converter.mbcsToWcs(byArray));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] nArray = new int[1];
        long l = OS.gtk_settings_get_default();
        OS.g_object_get(l, OS.gtk_alternative_button_order, nArray, 0L);
        return nArray[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        long l = OS.gtk_settings_get_default();
        int[] nArray = new int[1];
        OS.g_object_get(l, OS.gtk_double_click_time, nArray, 0L);
        return nArray[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        long l = this.activeShell.shellHandle;
        long l2 = OS.gtk_window_get_focus(l);
        if (l2 == 0L) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(l2)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((l2 = OS.gtk_widget_get_parent(l2)) != 0L);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    @Override
    public int getDepth() {
        this.checkDevice();
        return OS.gdk_visual_get_depth(OS.gdk_visual_get_system());
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] byArray = Converter.wcsToMbcs("_NET_WORKAREA", true);
        long l = OS.gdk_atom_intern(byArray, true);
        if (l == 0L) {
            return null;
        }
        long[] lArray = new long[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long[] lArray2 = new long[1];
        if (!OS.gdk_property_get(OS.gdk_get_default_root_window(), l, 0L, 0L, 16L, 0, lArray, nArray, nArray2, lArray2)) {
            return null;
        }
        Rectangle rectangle = null;
        if (lArray2[0] != 0L) {
            if (nArray2[0] == 16) {
                int[] nArray3 = new int[4];
                OS.memmove(nArray3, lArray2[0], 16L);
                rectangle = new Rectangle(nArray3[0], nArray3[1], nArray3[2], nArray3[3]);
            } else if (nArray2[0] == 32) {
                long[] lArray3 = new long[4];
                OS.memmove(lArray3, lArray2[0], 32L);
                rectangle = new Rectangle((int)lArray3[0], (int)lArray3[1], (int)lArray3[2], (int)lArray3[3]);
            }
            OS.g_free(lArray2[0]);
        }
        return rectangle;
    }

    public Monitor[] getMonitors() {
        Object object;
        int n;
        this.checkDevice();
        Monitor[] monitorArray = null;
        Rectangle rectangle = DPIUtil.autoScaleDown(this.getWorkArea());
        long l = OS.gdk_screen_get_default();
        if (l != 0L && (n = OS.gdk_screen_get_n_monitors(l)) > 0) {
            monitorArray = new Monitor[n];
            object = new GdkRectangle();
            for (int i = 0; i < n; ++i) {
                OS.gdk_screen_get_monitor_geometry(l, i, (GdkRectangle)object);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = DPIUtil.autoScaleDown(((GdkRectangle)object).x);
                monitor.y = DPIUtil.autoScaleDown(((GdkRectangle)object).y);
                monitor.width = DPIUtil.autoScaleDown(((GdkRectangle)object).width);
                monitor.height = DPIUtil.autoScaleDown(((GdkRectangle)object).height);
                if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                    OS.gdk_screen_get_monitor_workarea(l, i, (GdkRectangle)object);
                    monitor.clientX = DPIUtil.autoScaleDown(((GdkRectangle)object).x);
                    monitor.clientY = DPIUtil.autoScaleDown(((GdkRectangle)object).y);
                    monitor.clientWidth = DPIUtil.autoScaleDown(((GdkRectangle)object).width);
                    monitor.clientHeight = DPIUtil.autoScaleDown(((GdkRectangle)object).height);
                } else {
                    if (rectangle != null) {
                        monitor.clientX = Math.max(monitor.x, rectangle.x);
                        monitor.clientY = Math.max(monitor.y, rectangle.y);
                        monitor.clientHeight = Math.max(Math.min(monitor.y + monitor.height, rectangle.y + rectangle.height) - monitor.clientY, 0);
                        monitor.clientWidth = Math.max(Math.min(monitor.x + monitor.width, rectangle.x + rectangle.width) - monitor.clientX, 0);
                    }
                    if (rectangle == null || monitor.clientWidth == 0 || monitor.clientHeight == 0) {
                        monitor.clientX = monitor.x;
                        monitor.clientY = monitor.y;
                        monitor.clientHeight = monitor.height;
                        monitor.clientWidth = monitor.width;
                    }
                }
                monitorArray[i] = monitor;
            }
        }
        if (monitorArray == null) {
            Monitor monitor = new Monitor();
            object = this.getBounds();
            monitor.x = ((Rectangle)object).x;
            monitor.y = ((Rectangle)object).y;
            monitor.width = ((Rectangle)object).width;
            monitor.height = ((Rectangle)object).height;
            if (rectangle != null) {
                monitor.clientX = rectangle.x;
                monitor.clientY = rectangle.y;
                monitor.clientWidth = rectangle.width;
                monitor.clientHeight = rectangle.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitorArray = new Monitor[]{monitor};
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitorArray = this.getMonitors();
        int n = 0;
        long l = OS.gdk_screen_get_default();
        if (l != 0L) {
            n = OS.gdk_screen_get_primary_monitor(l);
        }
        return monitorArray[n];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        for (int i = 0; i < this.widgetTable.length; ++i) {
            int n2;
            Widget widget = this.widgetTable[i];
            if (widget == null || !(widget instanceof Shell)) continue;
            for (n2 = 0; n2 < n && shellArray[n2] != widget; ++n2) {
            }
            if (n2 != n) continue;
            if (n == shellArray.length) {
                Shell[] shellArray2 = new Shell[n + 16];
                System.arraycopy(shellArray, 0, shellArray2, 0, n);
                shellArray = shellArray2;
            }
            shellArray[n++] = (Shell)widget;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int n) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (n) {
            case 36: {
                gdkColor = this.COLOR_LINK_FOREGROUND;
                break;
            }
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (0 > n || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("dialog-error");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("dialog-information");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("dialog-question");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("dialog-warning");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    GdkRGBA toGdkRGBA(GdkColor gdkColor) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        gdkRGBA.alpha = 1.0;
        gdkRGBA.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
        gdkRGBA.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
        gdkRGBA.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        return gdkRGBA;
    }

    GdkColor toGdkColor(GdkRGBA gdkRGBA) {
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(gdkRGBA.red * 65535.0);
        gdkColor.green = (short)(gdkRGBA.green * 65535.0);
        gdkColor.blue = (short)(gdkRGBA.blue * 65535.0);
        return gdkColor;
    }

    GdkColor toGdkColor(GdkRGBA gdkRGBA, double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        OS.gtk_rgb_to_hsv(gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, dArray, dArray2, dArray3);
        double d2 = (2.0 - dArray2[0]) * dArray3[0];
        double d3 = dArray2[0] * dArray3[0];
        d3 /= d2 <= 1.0 ? d2 : 2.0 - d2;
        d2 /= 2.0;
        d3 = Math.max(0.0, Math.min(1.0, d3 * d));
        d2 = Math.max(0.0, Math.min(1.0, d2 * d));
        dArray3[0] = (d2 + (d3 *= d2 <= 1.0 ? d2 : 2.0 - (d2 *= 2.0))) / 2.0;
        dArray2[0] = 2.0 * d3 / (d2 + d3);
        OS.gtk_hsv_to_rgb(dArray[0], dArray2[0], dArray3[0], dArray, dArray2, dArray3);
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(dArray[0] * 65535.0);
        gdkColor.green = (short)(dArray2[0] * 65535.0);
        gdkColor.blue = (short)(dArray3[0] * 65535.0);
        return gdkColor;
    }

    void getBackgroundColor(long l, int n, GdkRGBA gdkRGBA) {
        OS.gtk_style_context_save(l);
        OS.gtk_style_context_set_state(l, n);
        long l2 = Cairo.cairo_image_surface_create(1, 1, 1);
        long l3 = Cairo.cairo_create(l2);
        OS.gtk_render_background(l, l3, -50.0, -50.0, 100.0, 100.0);
        Cairo.cairo_fill(l3);
        Cairo.cairo_surface_flush(l2);
        byte[] byArray = new byte[3];
        OS.memmove(byArray, Cairo.cairo_image_surface_get_data(l2), (long)byArray.length);
        gdkRGBA.red = (float)byArray[2] / 255.0f;
        gdkRGBA.green = (float)byArray[1] / 255.0f;
        gdkRGBA.blue = (float)byArray[0] / 255.0f;
        gdkRGBA.alpha = 1.0;
        Cairo.cairo_surface_destroy(l2);
        Cairo.cairo_destroy(l3);
        OS.gtk_style_context_restore(l);
    }

    void initializeSystemColors() {
        long l;
        long l2 = OS.gtk_window_new(1);
        if (l2 == 0L) {
            this.error(2);
        }
        byte[] byArray = Converter.wcsToMbcs(OS.GTK3 ? "gtk-tooltip" : "gtk-tooltips", true);
        OS.gtk_widget_set_name(l2, byArray);
        OS.gtk_widget_realize(l2);
        long l3 = OS.gtk_label_new(new byte[1]);
        if (l3 == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l2, l3);
        long[] lArray = new long[1];
        OS.gtk_widget_style_get(l3, OS.link_color, lArray, 0L);
        GdkColor gdkColor = new GdkColor();
        if (lArray[0] != 0L) {
            OS.memmove(gdkColor, lArray[0], (long)GdkColor.sizeof);
            OS.gdk_color_free(lArray[0]);
        } else {
            gdkColor.blue = (short)-4370;
        }
        if (!OS.GTK3) {
            l = OS.gdk_colormap_get_system();
            OS.gdk_colormap_alloc_color(l, gdkColor, true, true);
        }
        this.COLOR_LINK_FOREGROUND = gdkColor;
        if (OS.GTK3) {
            String string;
            l = OS.gtk_widget_get_style_context(l2);
            OS.gtk_style_context_add_class(l, OS.GTK_STYLE_CLASS_TOOLTIP);
            OS.gtk_style_context_invalidate(l);
            GdkRGBA gdkRGBA = new GdkRGBA();
            this.initializeColorList();
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(28);
                if (!string.isEmpty()) {
                    if (string != "parsed") {
                        gdkRGBA = this.gtk_css_property_to_rgba(string);
                        this.COLOR_INFO_FOREGROUND = this.toGdkColor(gdkRGBA);
                    }
                } else {
                    this.styleContextGetColor(l, 0, gdkRGBA);
                    this.COLOR_INFO_FOREGROUND = this.toGdkColor(gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 0, gdkRGBA);
                this.COLOR_INFO_FOREGROUND = this.toGdkColor(gdkRGBA);
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(29);
                if (!string.isEmpty()) {
                    if (string != "parsed") {
                        gdkRGBA = this.gtk_css_property_to_rgba(string);
                        this.COLOR_INFO_BACKGROUND = this.toGdkColor(gdkRGBA);
                    }
                } else {
                    this.getBackgroundColor(l, 0, gdkRGBA);
                    this.COLOR_INFO_BACKGROUND = this.toGdkColor(gdkRGBA);
                }
            } else {
                this.getBackgroundColor(l, 0, gdkRGBA);
                this.COLOR_INFO_BACKGROUND = this.toGdkColor(gdkRGBA);
            }
            OS.gtk_widget_destroy(l2);
            l = OS.gtk_widget_get_style_context(this.shellHandle);
            this.COLOR_WIDGET_DARK_SHADOW = this.toGdkColor(new GdkRGBA());
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(21);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    this.styleContextGetColor(l, 0, gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 0, gdkRGBA);
            }
            this.COLOR_WIDGET_FOREGROUND = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(22);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    OS.gtk_style_context_get_background_color(l, 0, gdkRGBA);
                }
            } else {
                OS.gtk_style_context_get_background_color(l, 0, gdkRGBA);
            }
            this.COLOR_WIDGET_LIGHT_SHADOW = this.COLOR_WIDGET_BACKGROUND = this.toGdkColor(gdkRGBA);
            this.COLOR_WIDGET_NORMAL_SHADOW = this.toGdkColor(gdkRGBA, 0.7);
            this.COLOR_WIDGET_HIGHLIGHT_SHADOW = this.toGdkColor(gdkRGBA, 1.3);
            OS.gtk_style_context_save(l);
            OS.gtk_style_context_add_class(l, OS.GTK_STYLE_CLASS_VIEW);
            OS.gtk_style_context_add_class(l, OS.GTK_STYLE_CLASS_CELL);
            OS.gtk_style_context_invalidate(l);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(24);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    this.styleContextGetColor(l, 0, gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 0, gdkRGBA);
            }
            this.COLOR_LIST_FOREGROUND = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(25);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    OS.gtk_style_context_get_background_color(l, 0, gdkRGBA);
                }
            } else {
                OS.gtk_style_context_get_background_color(l, 0, gdkRGBA);
            }
            this.COLOR_LIST_BACKGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_restore(l);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(27);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    this.styleContextGetColor(l, 4, gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 4, gdkRGBA);
            }
            this.COLOR_TITLE_FOREGROUND = this.COLOR_LIST_SELECTION_TEXT = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(26);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    OS.gtk_style_context_get_background_color(l, 4, gdkRGBA);
                }
            } else {
                OS.gtk_style_context_get_background_color(l, 4, gdkRGBA);
            }
            this.COLOR_TITLE_BACKGROUND = this.COLOR_LIST_SELECTION = this.toGdkColor(gdkRGBA);
            this.COLOR_TITLE_BACKGROUND_GRADIENT = this.toGdkColor(gdkRGBA, 1.3);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(38);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    this.styleContextGetColor(l, 1, gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 1, gdkRGBA);
            }
            this.COLOR_LIST_SELECTION_TEXT_INACTIVE = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(39);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    OS.gtk_style_context_get_background_color(l, 1, gdkRGBA);
                }
            } else {
                OS.gtk_style_context_get_background_color(l, 1, gdkRGBA);
            }
            this.COLOR_LIST_SELECTION_INACTIVE = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(33);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    this.styleContextGetColor(l, 8, gdkRGBA);
                }
            } else {
                this.styleContextGetColor(l, 8, gdkRGBA);
            }
            this.COLOR_TITLE_INACTIVE_FOREGROUND = this.toGdkColor(gdkRGBA);
            if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                string = this.gtk_css_default_theme_values(34);
                if (!string.isEmpty()) {
                    gdkRGBA = this.gtk_css_property_to_rgba(string);
                } else {
                    OS.gtk_style_context_get_background_color(l, 8, gdkRGBA);
                }
            } else {
                OS.gtk_style_context_get_background_color(l, 8, gdkRGBA);
            }
            this.COLOR_TITLE_INACTIVE_BACKGROUND = this.toGdkColor(gdkRGBA);
            this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = this.toGdkColor(gdkRGBA, 1.3);
            return;
        }
        l = OS.gtk_widget_get_style(l2);
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(l, 0, gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(l, 0, gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        OS.gtk_widget_destroy(l2);
        long l4 = OS.gtk_widget_get_style(this.shellHandle);
        gdkColor = new GdkColor();
        OS.gtk_style_get_black(l4, gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_dark(l4, 0, gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(l4, 0, gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(l4, 0, gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(l4, 0, gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(l4, 0, gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(l4, 0, gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(l4, 0, gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(l4, 3, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(l4, 3, gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(l4, 1, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(l4, 1, gdkColor);
        this.COLOR_LIST_SELECTION_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(l4, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(l4, 3, gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(l4, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(l4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(l4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(l4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
    }

    GdkRGBA styleContextGetColor(long l, int n, GdkRGBA gdkRGBA) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 18, 0)) {
            OS.gtk_style_context_save(l);
            OS.gtk_style_context_set_state(l, n);
            OS.gtk_style_context_get_color(l, n, gdkRGBA);
            OS.gtk_style_context_restore(l);
        } else {
            OS.gtk_style_context_get_color(l, n, gdkRGBA);
        }
        return gdkRGBA;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(long l) {
        if (l == 0L) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == l) {
            return this.lastWidget;
        }
        long l2 = OS.g_object_get_qdata(l, SWT_OBJECT_INDEX) - 1L;
        if (0L <= l2 && l2 < (long)this.widgetTable.length) {
            this.lastHandle = l;
            this.lastWidget = this.widgetTable[(int)l2];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long idleProc(long l) {
        boolean bl = this.runAsyncMessages(false);
        if (!bl) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return bl ? 1L : 0L;
    }

    @Override
    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeWindowManager();
    }

    void initializeCallbacks() {
        this.closures = new long[85];
        this.closuresCount = new int[85];
        this.closuresProc = new long[85];
        this.signalIds = new int[85];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[15] = OS.g_signal_lookup(OS.event, OS.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, OS.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.GTK3 ? OS.draw : OS.expose_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[19] = OS.g_signal_lookup(OS.GTK3 ? OS.draw : OS.expose_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, OS.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, OS.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, OS.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, OS.GTK_TYPE_WIDGET());
        this.signalIds[46] = OS.g_signal_lookup(OS.show_help, OS.GTK_TYPE_WIDGET());
        this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, OS.GTK_TYPE_WIDGET());
        this.signalIds[48] = OS.g_signal_lookup(OS.style_set, OS.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, OS.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, OS.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0L) {
            this.error(3);
        }
        this.closuresProc[1] = this.windowProc2;
        this.closuresProc[60] = this.windowProc2;
        this.closuresProc[6] = this.windowProc2;
        this.closuresProc[8] = this.windowProc2;
        this.closuresProc[83] = this.windowProc2;
        this.closuresProc[61] = this.windowProc2;
        this.closuresProc[66] = this.windowProc2;
        this.closuresProc[24] = this.windowProc2;
        this.closuresProc[23] = this.windowProc2;
        this.closuresProc[30] = this.windowProc2;
        this.closuresProc[62] = this.windowProc2;
        this.closuresProc[36] = this.windowProc2;
        this.closuresProc[38] = this.windowProc2;
        this.closuresProc[39] = this.windowProc2;
        this.closuresProc[40] = this.windowProc2;
        this.closuresProc[44] = this.windowProc2;
        this.closuresProc[68] = this.windowProc2;
        this.closuresProc[45] = this.windowProc2;
        this.closuresProc[69] = this.windowProc2;
        this.closuresProc[57] = this.windowProc2;
        this.closuresProc[54] = this.windowProc2;
        this.closuresProc[56] = this.windowProc2;
        this.closuresProc[70] = this.windowProc2;
        this.closuresProc[71] = this.windowProc2;
        this.closuresProc[72] = this.windowProc2;
        this.closuresProc[73] = this.windowProc2;
        this.closuresProc[74] = this.windowProc2;
        this.closuresProc[75] = this.windowProc2;
        this.closuresProc[76] = this.windowProc2;
        this.closuresProc[77] = this.windowProc2;
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0L) {
            this.error(3);
        }
        this.closuresProc[2] = this.windowProc3;
        this.closuresProc[3] = this.windowProc3;
        this.closuresProc[4] = this.windowProc3;
        this.closuresProc[5] = this.windowProc3;
        this.closuresProc[9] = this.windowProc3;
        this.closuresProc[10] = this.windowProc3;
        this.closuresProc[11] = this.windowProc3;
        this.closuresProc[14] = this.windowProc3;
        this.closuresProc[15] = this.windowProc3;
        this.closuresProc[16] = this.windowProc3;
        this.closuresProc[18] = this.windowProc3;
        this.closuresProc[19] = this.windowProc3;
        this.closuresProc[20] = this.windowProc3;
        this.closuresProc[21] = this.windowProc3;
        this.closuresProc[22] = this.windowProc3;
        this.closuresProc[27] = this.windowProc3;
        this.closuresProc[28] = this.windowProc3;
        this.closuresProc[25] = this.windowProc3;
        this.closuresProc[29] = this.windowProc3;
        this.closuresProc[31] = this.windowProc3;
        this.closuresProc[32] = this.windowProc3;
        this.closuresProc[33] = this.windowProc3;
        this.closuresProc[34] = this.windowProc3;
        this.closuresProc[35] = this.windowProc3;
        this.closuresProc[37] = this.windowProc3;
        this.closuresProc[43] = this.windowProc3;
        this.closuresProc[46] = this.windowProc3;
        this.closuresProc[47] = this.windowProc3;
        this.closuresProc[48] = this.windowProc3;
        this.closuresProc[53] = this.windowProc3;
        this.closuresProc[55] = this.windowProc3;
        this.closuresProc[59] = this.windowProc3;
        this.closuresProc[65] = this.windowProc3;
        this.closuresProc[82] = this.windowProc3;
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0L) {
            this.error(3);
        }
        this.closuresProc[12] = this.windowProc4;
        this.closuresProc[13] = this.windowProc4;
        this.closuresProc[67] = this.windowProc4;
        this.closuresProc[41] = this.windowProc4;
        this.closuresProc[42] = this.windowProc4;
        this.closuresProc[63] = this.windowProc4;
        this.closuresProc[49] = this.windowProc4;
        this.closuresProc[50] = this.windowProc4;
        this.closuresProc[51] = this.windowProc4;
        this.closuresProc[64] = this.windowProc4;
        this.closuresProc[84] = this.windowProc4;
        this.closuresProc[78] = this.windowProc4;
        this.closuresProc[79] = this.windowProc4;
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0L) {
            this.error(3);
        }
        this.closuresProc[7] = this.windowProc5;
        this.closuresProc[17] = this.windowProc5;
        this.closuresProc[26] = this.windowProc5;
        this.closuresProc[52] = this.windowProc5;
        this.closuresProc[80] = this.windowProc5;
        this.closuresProc[81] = this.windowProc5;
        for (int i = 0; i < 85; ++i) {
            if (this.closuresProc[i] != 0L) {
                this.closures[i] = OS.g_cclosure_new(this.closuresProc[i], i, 0L);
            }
            if (this.closures[i] == 0L) continue;
            OS.g_closure_ref(this.closures[i]);
            OS.g_closure_sink(this.closures[i]);
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0L) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0L) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0L) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0L) {
            this.error(3);
        }
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        if (this.sizeAllocateProc == 0L) {
            this.error(3);
        }
        this.sizeRequestCallback = new Callback(this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        if (this.sizeRequestProc == 0L) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0L) {
            this.error(3);
        }
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0L, 0L);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0L) {
            this.error(3);
        }
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        if (this.setDirectionProc == 0L) {
            this.error(3);
        }
        this.emissionProcCallback = new Callback(this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        if (this.emissionProc == 0L) {
            this.error(3);
        }
        this.allChildrenCallback = new Callback(this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        if (this.allChildrenProc == 0L) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0L) {
            this.error(3);
        }
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
        if (this.idleProc == 0L) {
            this.error(3);
        }
    }

    void initializeColorList() {
        this.colorList = new ArrayList();
        this.colorList.add("black");
        this.colorList.add("darkred");
        this.colorList.add("darkgreen");
        this.colorList.add("darkyellow");
        this.colorList.add("darkblue");
        this.colorList.add("darkmagenta");
        this.colorList.add("darkcyan");
        this.colorList.add("darkgray");
        this.colorList.add("gray");
        this.colorList.add("red");
        this.colorList.add("green");
        this.colorList.add("yellow");
        this.colorList.add("blue");
        this.colorList.add("magenta");
        this.colorList.add("cyan");
        this.colorList.add("white");
    }

    void initializeSubclasses() {
        long l = OS.PANGO_TYPE_LAYOUT();
        long l2 = OS.g_type_class_ref(l);
        this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l2);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l2, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
        OS.g_type_class_unref(l2);
        if (OS.GTK3) {
            long l3 = OS.GTK_TYPE_IM_MULTICONTEXT();
            long l4 = OS.g_type_class_ref(l3);
            this.imContextNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l4);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l4, OS.imContextNewProc_CALLBACK(this.imContextNewProc));
            OS.g_type_class_unref(l4);
            long l5 = OS.PANGO_TYPE_FONT_FAMILY();
            long l6 = OS.g_type_class_ref(l5);
            this.pangoFontFamilyNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l6);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l6, OS.pangoFontFamilyNewProc_CALLBACK(this.pangoFontFamilyNewProc));
            OS.g_type_class_unref(l6);
            long l7 = OS.PANGO_TYPE_FONT_FACE();
            long l8 = OS.g_type_class_ref(l7);
            this.pangoFontFaceNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l8);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l8, OS.pangoFontFaceNewProc_CALLBACK(this.pangoFontFaceNewProc));
            OS.g_type_class_unref(l8);
            if (!OS.IsWin32) {
                long l9 = OS.gtk_printer_option_widget_get_type();
                long l10 = OS.g_type_class_ref(l9);
                this.printerOptionWidgetNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l10);
                OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l10, OS.printerOptionWidgetNewProc_CALLBACK(this.printerOptionWidgetNewProc));
                OS.g_type_class_unref(l10);
            }
        }
    }

    void initializeSystemSettings() {
        OS.g_signal_connect(this.shellHandle, OS.style_set, this.signalProc, 1L);
        long l = OS.gtk_entry_new();
        OS.gtk_widget_destroy(l);
        int[] nArray = new int[1];
        long l2 = OS.gtk_settings_get_default();
        OS.g_object_get(l2, OS.gtk_entry_select_on_focus, nArray, 0L);
        this.entrySelectOnFocus = nArray[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        for (int i = 0; i < 1023; ++i) {
            this.indexTable[i] = i + 1;
        }
        this.indexTable[1023] = -1;
    }

    void initializeWindowManager() {
        int n;
        long l;
        long l2;
        this.windowManager = "";
        if (OS.isX11() && (l2 = OS.gdk_screen_get_default()) != 0L && (l = OS.gdk_x11_screen_get_window_manager_name(l2)) != 0L && (n = OS.strlen(l)) > 0) {
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l, (long)n);
            this.windowManager = new String(Converter.mbcsToWcs(byArray));
        }
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        long l2 = l;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(l2);
        } else {
            OS.g_object_unref(l2);
        }
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        long l;
        if (this.isDisposed()) {
            this.error(45);
        }
        long l2 = OS.gdk_get_default_root_window();
        if (OS.USE_CAIRO) {
            l = OS.gdk_cairo_create(l2);
            if (l == 0L) {
                this.error(2);
            }
        } else {
            l = OS.gdk_gc_new(l2);
            if (l == 0L) {
                this.error(2);
            }
            OS.gdk_gc_set_subwindow(l, 1L);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = l2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return l;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point2 = new Point(n, n2);
        if (control == control2) {
            return point2;
        }
        if (control != null) {
            point = DPIUtil.autoScaleDown(control.getWindowOrigin());
            if ((control.style & 0x8000000) != 0) {
                point2.x = DPIUtil.autoScaleDown(control.getClientWidth()) - point2.x;
            }
            point2.x += point.x;
            point2.y += point.y;
        }
        if (control2 != null) {
            point = DPIUtil.autoScaleDown(control2.getWindowOrigin());
            point2.x -= point.x;
            point2.y -= point.y;
            if ((control2.style & 0x8000000) != 0) {
                point2.x = DPIUtil.autoScaleDown(control2.getClientWidth()) - point2.x;
            }
        }
        return point2;
    }

    Point mapInPixels(Control control, Control control2, int n, int n2) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point2 = new Point(n, n2);
        if (control == control2) {
            return point2;
        }
        if (control != null) {
            point = control.getWindowOrigin();
            if ((control.style & 0x8000000) != 0) {
                point2.x = control.getClientWidth() - point2.x;
            }
            point2.x += point.x;
            point2.y += point.y;
        }
        if (control2 != null) {
            point = control2.getWindowOrigin();
            point2.x -= point.x;
            point2.y -= point.y;
            if ((control2.style & 0x8000000) != 0) {
                point2.x = control2.getClientWidth() - point2.x;
            }
        }
        return point2;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    Rectangle mapInPixels(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.mapInPixels(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            point = DPIUtil.autoScaleDown(control.getWindowOrigin());
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = DPIUtil.autoScaleDown(control.getClientWidth()) - rectangle.x;
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        if (control2 != null) {
            point = DPIUtil.autoScaleDown(control2.getWindowOrigin());
            rectangle.x -= point.x;
            rectangle.y -= point.y;
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = DPIUtil.autoScaleDown(control2.getClientWidth()) - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    Rectangle mapInPixels(Control control, Control control2, int n, int n2, int n3, int n4) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            point = control.getWindowOrigin();
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = control.getClientWidth() - rectangle.x;
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        if (control2 != null) {
            point = control2.getWindowOrigin();
            rectangle.x -= point.x;
            rectangle.y -= point.y;
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = control2.getClientWidth() - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    long mouseHoverProc(long l) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.hoverProc(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event event) {
        Lock lock = OS.lock;
        lock.lock();
        try {
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (this.isDisposed()) {
                    this.error(45);
                }
                if (event == null) {
                    this.error(4);
                }
                if (!OS.isX11()) {
                    boolean bl = false;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
        {
            long l = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n = event.type;
            switch (n) {
                case 1: 
                case 2: {
                    boolean bl;
                    int n2 = 0;
                    long l2 = Display.untranslateKey(event.keyCode);
                    if (l2 != 0L) {
                        n2 = OS.XKeysymToKeycode(l, l2);
                    }
                    if (n2 == 0) {
                        bl = event.character;
                        switch (bl) {
                            case 8: {
                                l2 = 65288L;
                                break;
                            }
                            case 13: {
                                l2 = 65293L;
                                break;
                            }
                            case 127: {
                                l2 = 65535L;
                                break;
                            }
                            case 27: {
                                l2 = 65307L;
                                break;
                            }
                            case 9: {
                                l2 = 65289L;
                                break;
                            }
                            case 10: {
                                l2 = 65290L;
                                break;
                            }
                            default: {
                                l2 = (long)bl;
                            }
                        }
                        n2 = OS.XKeysymToKeycode(l, l2);
                        if (n2 == 0) {
                            boolean bl2 = false;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            lock.unlock();
                            return bl2;
                        }
                    }
                    OS.XTestFakeKeyEvent(l, n2, n == 1, 0L);
                    bl = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
                case 5: {
                    Rectangle rectangle = DPIUtil.autoScaleUp(event.getBounds());
                    this.setCursorLocationInPixels(new Point(rectangle.x, rectangle.y));
                    boolean bl = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
                case 3: 
                case 4: {
                    int n3 = event.button;
                    switch (n3) {
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 4: {
                            n3 = 6;
                            break;
                        }
                        case 5: {
                            n3 = 7;
                            break;
                        }
                        default: {
                            boolean bl = false;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            lock.unlock();
                            return bl;
                        }
                    }
                    long l3 = OS.gdk_display_get_default();
                    long l4 = OS.gdk_screen_get_default();
                    long l5 = OS.gdk_screen_get_active_window(l4);
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    if (l5 == 0L) {
                        boolean bl = false;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        lock.unlock();
                        return bl;
                    }
                    if (OS.GTK3) {
                        long l6 = OS.gdk_display_get_device_manager(l3);
                        long l7 = OS.gdk_device_manager_get_client_pointer(l6);
                        OS.gdk_window_get_device_position(l5, l7, nArray, nArray2, new int[1]);
                    } else {
                        OS.gdk_window_get_pointer(l5, nArray, nArray2, new int[1]);
                    }
                    OS.gdk_test_simulate_button(l5, nArray[0], nArray2[0], n3, 0, n == 3 ? 4 : 7);
                    boolean bl = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
            }
            boolean bl = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            lock.unlock();
            return bl;
        }
    }

    void postEvent(Event event) {
        int n;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n2 = this.eventQueue.length;
        for (n = 0; n < n2 && this.eventQueue[n] != null; ++n) {
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            for (int i = 0; i < this.gdkEventCount; ++i) {
                long l = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    OS.gdk_event_put(l);
                }
                OS.gdk_event_free(l);
                this.gdkEvents[i] = 0L;
                this.gdkEventWidgets[i] = null;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean bl = false;
        bl |= this.runSettings();
        bl |= this.runPopups();
        OS.gdk_threads_leave();
        if (bl |= OS.g_main_context_iteration(0L, false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] != null) continue;
                Display.Displays[i] = display;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        Object object;
        int n;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (n = 0; n < shellArray.length; ++n) {
            object = shellArray[n];
            if (((Widget)object).isDisposed()) continue;
            ((Shell)object).dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (n = 0; n < this.disposeList.length; ++n) {
                object = this.disposeList[n];
                if (object == null) continue;
                try {
                    object.run();
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    this.runtimeExceptionHandler.accept(runtimeException);
                    continue;
                }
                catch (Error error) {
                    this.errorHandler.accept(error);
                }
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        File file;
        int n;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.windowProc5 = 0L;
        this.windowProc4 = 0L;
        this.windowProc3 = 0L;
        this.windowProc2 = 0L;
        if (this.filterProc != 0L) {
            OS.gdk_window_remove_filter(0L, this.filterProc, 0L);
        }
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0L;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0L;
        if (this.preeditWindow != 0L) {
            OS.gtk_widget_destroy(this.preeditWindow);
        }
        this.imControl = null;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0L;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0L;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0L;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0L;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0L;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0L;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0L;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0L;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0L;
        this.caretCallback.dispose();
        this.caretCallback = null;
        for (n = 0; n < 85; ++n) {
            if (this.closures[n] == 0L) continue;
            OS.g_closure_unref(this.closures[n]);
        }
        if (this.shellMapProcClosure != 0L) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            for (n = 0; n < this.timerIds.length; ++n) {
                if (this.timerIds[n] == 0) continue;
                OS.g_source_remove(this.timerIds[n]);
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0L;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0L;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0L;
        this.mouseHoverHandle = 0L;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (n = 0; n < this.cursors.length; ++n) {
            if (this.cursors[n] == null) continue;
            this.cursors[n].dispose();
        }
        this.cursors = null;
        if (this.resources != null) {
            for (n = 0; n < this.resources.length; ++n) {
                if (this.resources[n] == null) continue;
                this.resources[n].dispose();
            }
            this.resources = null;
        }
        this.COLOR_LINK_FOREGROUND = null;
        this.COLOR_INFO_FOREGROUND = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_BACKGROUND = null;
        this.COLOR_TITLE_FOREGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = null;
        this.COLOR_LIST_SELECTION_INACTIVE = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        OS.gdk_event_handler_set(0L, 0L, 0L);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0L) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0L;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0L;
        this.keysChangedCallback.dispose();
        this.keysChangedCallback = null;
        this.keysChangedProc = 0L;
        long l = OS.PANGO_TYPE_LAYOUT();
        long l2 = OS.g_type_class_ref(l);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l2, this.pangoLayoutNewProc);
        OS.g_type_class_unref(l2);
        this.pangoLayoutNewProc = 0L;
        if (OS.GTK3) {
            long l3 = OS.GTK_TYPE_IM_MULTICONTEXT();
            long l4 = OS.g_type_class_ref(l3);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l4, this.imContextNewProc);
            OS.g_type_class_unref(l4);
            this.imContextNewProc = 0L;
            long l5 = OS.PANGO_TYPE_FONT_FAMILY();
            long l6 = OS.g_type_class_ref(l5);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l6, this.pangoFontFamilyNewProc);
            OS.g_type_class_unref(l6);
            this.pangoFontFamilyNewProc = 0L;
            long l7 = OS.PANGO_TYPE_FONT_FACE();
            long l8 = OS.g_type_class_ref(l7);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l8, this.pangoFontFaceNewProc);
            OS.g_type_class_unref(l8);
            this.pangoFontFaceNewProc = 0L;
        }
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0L) {
            OS.g_free(this.fds);
        }
        this.fds = 0L;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.windowManager = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.idleLock = null;
        String string = System.getProperty("user.home");
        if (string != null && ((file = new File(string, ".swt")).exists() && file.isDirectory() || file.mkdirs())) {
            File file2 = new File(file, "trims.prefs");
            Properties properties = new Properties();
            StringBuilder stringBuilder = new StringBuilder();
            for (int n2 : this.trimWidths) {
                stringBuilder.append(n2).append(' ');
            }
            properties.put("trimWidths", stringBuilder.toString());
            stringBuilder = new StringBuilder();
            for (int n3 : this.trimHeights) {
                stringBuilder.append(n3).append(' ');
            }
            properties.put("trimHeights", stringBuilder.toString());
            try (Object object = new FileOutputStream(file2);){
                properties.store((OutputStream)object, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    long removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0L;
        }
        long l = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0L;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeMouseHoverTimeout(long l) {
        if (l != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0L;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i = 0; i < this.popups.length; ++i) {
            if (this.popups[i] != menu) continue;
            this.popups[i] = null;
            return;
        }
    }

    Widget removeWidget(long l) {
        if (l == 0L) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        int n = (int)OS.g_object_get_qdata(l, SWT_OBJECT_INDEX) - 1;
        if (0 <= n && n < this.widgetTable.length) {
            widget = this.widgetTable[n];
            this.widgetTable[n] = null;
            this.indexTable[n] = this.freeSlot;
            this.freeSlot = n;
            OS.g_object_set_qdata(l, SWT_OBJECT_INDEX, 0L);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        Event event;
        boolean bl = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i = 0; i < n; ++i) {
                Composite composite = compositeArray[i];
                if (composite.isDisposed()) continue;
                composite.setLayoutDeferred(false);
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        Menu menu;
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null && (menu = this.popups[0]) != null) {
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell = shellArray[i];
            if (shell.isDisposed()) continue;
            shell.fixStyle();
            shell.redraw(true);
            shell.layout(true, true);
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i = 0; i < n; ++i) {
                    Widget widget = widgetArray[i];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFEFFFFFF;
                    widgetArray[i] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    public void setCursorLocation(int n, int n2) {
        this.setCursorLocation(new Point(n, n2));
    }

    void setCursorLocationInPixels(Point point) {
        long l = OS.gdk_display_get_default();
        long l2 = OS.gdk_screen_get_default();
        if (!OS.GTK3) {
            OS.gdk_display_warp_pointer(l, l2, point.x, point.y);
        } else {
            long l3 = OS.gdk_display_get_device_manager(l);
            long l4 = OS.gdk_device_manager_get_client_pointer(l3);
            OS.gdk_device_warp(l4, l2, point.x, point.y);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setCursorLocationInPixels(point);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY) && (object == null || object instanceof int[])) {
            this.dispatchEvents = (int[])object;
            if (object == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)object);
            return;
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray = (Object[])object;
            long l = ((LONG)objectArray[0]).value;
            Widget widget = (Widget)objectArray[1];
            if (widget != null) {
                this.addWidget(l, widget);
            } else {
                this.removeWidget(l);
            }
        }
        if (string.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (string.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (object == null) {
            int n;
            if (this.keys == null) {
                return;
            }
            for (n = 0; n < this.keys.length && !this.keys[n].equals(string); ++n) {
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.values[i] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    long setDirectionProc(long l, long l2) {
        long l3;
        OS.gtk_widget_set_direction(l, (int)l2);
        if (OS.GTK_IS_MENU_ITEM(l) && (l3 = OS.gtk_menu_item_get_submenu(l)) != 0L) {
            OS.gtk_widget_set_direction(l3, (int)l2);
            OS.gtk_container_forall(l3, this.setDirectionProc, l2);
        }
        if (OS.GTK_IS_CONTAINER(l)) {
            OS.gtk_container_forall(l, this.setDirectionProc, l2);
        }
        return 0L;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2; ++n) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer<RuntimeException> consumer) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer<RuntimeException> getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer<Error> consumer) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer<Error> getErrorHandler() {
        return this.errorHandler;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0L) {
            this.preeditWindow = OS.gtk_window_new(1);
            if (this.preeditWindow == 0L) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.preeditWindow, this.preeditLabel);
            OS.gtk_widget_show(this.preeditLabel);
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l = control.imHandle();
        OS.gtk_im_context_get_preedit_string(l, lArray, lArray2, null);
        if (lArray[0] != 0L && OS.strlen(lArray[0]) > 0) {
            Control control2 = control.findBackgroundControl();
            if (control2 == null) {
                control2 = control;
            }
            GdkColor gdkColor = control2.getBackgroundColor();
            if (OS.GTK3) {
                control2.setBackgroundColor(this.preeditWindow, gdkColor);
            } else {
                OS.gtk_widget_modify_bg(this.preeditWindow, 0, gdkColor);
            }
            control2.setForegroundColor(this.preeditLabel, control.getForegroundColor());
            control2.setFontDescription(this.preeditLabel, control.getFontDescription());
            if (lArray2[0] != 0L) {
                OS.gtk_label_set_attributes(this.preeditLabel, lArray2[0]);
            }
            OS.gtk_label_set_text(this.preeditLabel, lArray[0]);
            Point point = control.toDisplayInPixels(control.getIMCaretPos());
            OS.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition gtkRequisition = new GtkRequisition();
            if (OS.GTK3) {
                OS.gtk_widget_get_preferred_size(this.preeditLabel, gtkRequisition, null);
            } else {
                OS.gtk_widget_size_request(this.preeditLabel, gtkRequisition);
            }
            OS.gtk_window_resize(this.preeditWindow, gtkRequisition.width, gtkRequisition.height);
            OS.gtk_widget_show(this.preeditWindow);
        } else {
            OS.gtk_widget_hide(this.preeditWindow);
        }
        if (lArray[0] != 0L) {
            OS.g_free(lArray[0]);
        }
        if (lArray2[0] != 0L) {
            OS.pango_attr_list_unref(lArray2[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (this.fds == 0L) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        long l = OS.g_main_context_default();
        boolean bl = false;
        do {
            int n;
            if (!OS.g_main_context_acquire(l)) continue;
            bl = OS.g_main_context_prepare(l, this.max_priority);
            while ((n = OS.g_main_context_query(l, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) > this.allocated_nfds) {
                OS.g_free(this.fds);
                this.allocated_nfds = n;
                this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
            }
            long l2 = OS.g_main_context_get_poll_func(l);
            if (l2 != 0L && (n > 0 || this.timeout[0] != 0)) {
                int n2;
                if (this.timeout[0] < 0) {
                    this.timeout[0] = 50;
                }
                Lock lock = OS.lock;
                int n3 = lock.lock();
                for (n2 = 0; n2 < n3; ++n2) {
                    lock.unlock();
                }
                try {
                    this.wake = false;
                    OS.Call(l2, this.fds, n, this.timeout[0]);
                }
                finally {
                    for (n2 = 0; n2 < n3; ++n2) {
                        lock.lock();
                    }
                    lock.unlock();
                }
            }
            OS.g_main_context_check(l, this.max_priority[0], this.fds, n);
            OS.g_main_context_release(l);
        } while (!bl && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        this.sendPostExternalEventDispatchEvent();
        return true;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != runnable; ++n3) {
        }
        if (n3 != this.timerList.length) {
            OS.g_source_remove(this.timerIds[n3]);
            this.timerList[n3] = null;
            this.timerIds[n3] = 0;
            if (n < 0) {
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != null; ++n3) {
            }
            if (n3 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n2 = OS.g_timeout_add(n, this.timerProc, n3)) != 0) {
            this.timerIds[n3] = n2;
            this.timerList[n3] = runnable;
        }
    }

    long timerProc(long l) {
        if (this.timerList == null) {
            return 0L;
        }
        int n = (int)l;
        if (0 <= n && n < this.timerList.length) {
            Runnable runnable = this.timerList[n];
            this.timerList[n] = null;
            this.timerIds[n] = 0;
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    this.runtimeExceptionHandler.accept(runtimeException);
                }
                catch (Error error) {
                    this.errorHandler.accept(error);
                }
            }
        }
        return 0L;
    }

    long caretProc(long l) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0L;
        }
        if (this.currentCaret.blinkCaret()) {
            int n = this.currentCaret.blinkRate;
            if (n == 0) {
                return 0L;
            }
            this.currentCaret.getParent().blink = true;
            this.caretId = OS.g_timeout_add(n, this.caretProc, 0L);
        } else {
            this.currentCaret = null;
        }
        return 0L;
    }

    void resetCaretTiming() {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
            this.caretId = OS.g_timeout_add(this.currentCaret.blinkRate, this.caretProc, 0L);
        }
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeAllocateProc(l, l2, l3);
    }

    long sizeRequestProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeRequestProc(l, l2, l3);
    }

    void saveResources() {
        int n = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n = this.resources.length;
            Resource[] resourceArray = new Resource[n + 27];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
        if (this.errorImage != null) {
            this.resources[n++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[n++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (int i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] != null) {
                this.resources[n++] = this.cursors[i];
            }
            this.cursors[i] = null;
        }
        if (n < 27) {
            Resource[] resourceArray = new Resource[n];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable eventTable, Event event) {
        int n = event.type;
        this.sendPreEvent(n);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(n);
        }
    }

    void sendPreEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53 && this.eventTable != null && this.eventTable.hooks(50)) {
            Event event = new Event();
            event.detail = n;
            this.sendEvent(50, event);
        }
    }

    void sendPostEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53 && this.eventTable != null && this.eventTable.hooks(51)) {
            Event event = new Event();
            event.detail = n;
            this.sendEvent(51, event);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    public void sendPostExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int n = this.currentCaret.blinkRate;
        this.caretId = OS.g_timeout_add(n, this.caretProc, 0L);
    }

    long shellMapProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.shellMapProc(l, l2, l3);
    }

    String simple_color_parser(String string, String string2, int n) {
        if (string != null && string2 != null) {
            String[] stringArray;
            int n2 = n + string2.length() + 1;
            String string3 = string.substring(n2);
            if (string3.startsWith("#") || string3.startsWith("rgb")) {
                return string3;
            }
            if (!string3.startsWith("@") && this.colorList.contains((stringArray = string3.split(";"))[0])) {
                return string3;
            }
        }
        return "";
    }

    long signalProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 1: {
                this.settingsChanged = true;
                break;
            }
            case 2: {
                byte[] byArray;
                long l4;
                GdkEventProperty gdkEventProperty = new GdkEventProperty();
                OS.memmove(gdkEventProperty, l2);
                if (gdkEventProperty.type != 16 || (l4 = OS.gdk_x11_atom_to_xatom(OS.gdk_atom_intern(byArray = Converter.wcsToMbcs("org.eclipse.swt.filePath.message", true), true))) != OS.gdk_x11_atom_to_xatom(gdkEventProperty.atom)) break;
                long l5 = OS.GTK3 ? OS.gdk_x11_window_get_xid(OS.gtk_widget_get_window(this.shellHandle)) : OS.gdk_x11_drawable_get_xid(OS.gtk_widget_get_window(this.shellHandle));
                long[] lArray = new long[1];
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                long[] lArray2 = new long[1];
                OS.XGetWindowProperty(OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default()), l5, l4, 0, -1, true, 0L, lArray, nArray, nArray2, nArray3, lArray2);
                if (nArray2[0] <= 0) break;
                byte[] byArray2 = new byte[nArray2[0]];
                OS.memmove(byArray2, lArray2[0], (long)byArray2.length);
                OS.XFree(lArray2[0]);
                char[] cArray = Converter.mbcsToWcs(byArray2);
                String string = new String(cArray);
                int n = 0;
                int n2 = string.indexOf(58);
                while (n2 != -1) {
                    String string2 = string.substring(n, n2);
                    Event event = new Event();
                    event.text = string2;
                    this.sendEvent(46, event);
                    n = n2 + 1;
                    n2 = string.indexOf(58, n);
                }
                break;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0L);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    static int translateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != n) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    static int untranslateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][1] != n) continue;
            return KeyTable[i][0];
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0L, true);
        if (OS.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            OS.gdk_window_process_all_updates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0L);
        this.wake = true;
    }

    long windowProc(long l, long l2) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2);
    }

    long windowProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3);
    }

    long windowProc(long l, long l2, long l3, long l4) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3, l4);
    }

    long windowProc(long l, long l2, long l3, long l4, long l5) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3, l4, l5);
    }

    long windowTimerProc(long l) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.timerProc(l);
    }

    long gdk_window_get_device_position(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        if (OS.GTK3) {
            long l2 = 0L;
            if (l != 0L) {
                l2 = OS.gdk_window_get_display(l);
            } else {
                l = OS.gdk_get_default_root_window();
                l2 = OS.gdk_window_get_display(l);
            }
            long l3 = OS.gdk_display_get_device_manager(l2);
            long l4 = OS.gdk_device_manager_get_client_pointer(l3);
            return OS.gdk_window_get_device_position(l, l4, nArray, nArray2, nArray3);
        }
        return OS.gdk_window_get_pointer(l, nArray, nArray2, nArray3);
    }

    long gdk_device_get_window_at_position(int[] nArray, int[] nArray2) {
        if (OS.GTK3) {
            long l = OS.gdk_display_get_default();
            long l2 = OS.gdk_display_get_device_manager(l);
            long l3 = OS.gdk_device_manager_get_client_pointer(l2);
            return OS.gdk_device_get_window_at_position(l3, nArray, nArray2);
        }
        return OS.gdk_window_at_pointer(nArray, nArray2);
    }

    @Override
    protected long gsettingsProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 1: {
                this.scaleFactor = this.getDeviceZoom();
                DPIUtil.setDeviceZoom(this.scaleFactor);
                Shell[] shellArray = this.getShells();
                for (int i = 0; i < shellArray.length; ++i) {
                    shellArray[i].layout(true, true);
                }
                break;
            }
        }
        return 0L;
    }

    static {
        byte[] byArray = Converter.wcsToMbcs("SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs("SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs("SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(byArray);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        DeviceFinder = () -> {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            Display.setDevice(display);
        };
    }
}

