/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.FrameEncoders;
import com.openinventor.remoteviz.rendering.IFrameEncodingPolicy;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;

public class ConnectionSettings
extends Inventor {
    private static native int getKeepAliveTimeOutImpl(long var0);

    private static native long getFrameEncodersImpl(long var0);

    private static native void setKeepAliveTimeOutImpl(long var0, int var2);

    private static native boolean isSupportedEncodersImpl(long var0, long var2);

    private static native int getMaxFPSImpl(long var0);

    private static native void setFrameEncodingPolicyImpl(long var0, long var2);

    private static native void setMaxFPSImpl(long var0, int var2);

    protected ConnectionSettings(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public int getKeepAliveTimeOut() {
        return ConnectionSettings.getKeepAliveTimeOutImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="9.9.0.0")
    public void setMaxFPS(int n) {
        ConnectionSettings.setMaxFPSImpl(this.getNativeResourceHandle(), n);
    }

    @Deprecated(since="9.9.0.0")
    public int getMaxFPS() {
        return ConnectionSettings.getMaxFPSImpl(this.getNativeResourceHandle());
    }

    public FrameEncoders getFrameEncoders() {
        return (FrameEncoders)ObjectManager.getManagedObjectFor(FrameEncoders.class, (Long)ConnectionSettings.getFrameEncodersImpl(this.getNativeResourceHandle()));
    }

    public void setKeepAliveTimeOut(int n) {
        ConnectionSettings.setKeepAliveTimeOutImpl(this.getNativeResourceHandle(), n);
    }

    public boolean isSupportedEncoders(FrameEncoders frameEncoders) {
        return ConnectionSettings.isSupportedEncodersImpl(this.getNativeResourceHandle(), frameEncoders != null ? frameEncoders.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setFrameEncodingPolicy(IFrameEncodingPolicy iFrameEncodingPolicy) {
        ConnectionSettings.setFrameEncodingPolicyImpl(this.getNativeResourceHandle(), iFrameEncodingPolicy != null ? iFrameEncodingPolicy.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        private static native long getNativeObjectHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

