/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;

public class EncodedFrame
extends Inventor
implements Cloneable {
    private static native boolean isLosslessImpl(long var0);

    private static native int getEncodingFormatImpl(long var0);

    private static native long getIdImpl(long var0);

    private static native long ctorImpl1(long var0);

    private static native long getBufferSizeImpl(long var0);

    private static native long ctorImpl();

    private static native boolean isInteractiveImpl(long var0);

    private static native String getMessageImpl(long var0);

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected EncodedFrame(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public Object clone() {
        EncodedFrame encodedFrame = new EncodedFrame(this);
        return encodedFrame;
    }

    public String getMessage() {
        return EncodedFrame.getMessageImpl(this.getNativeResourceHandle());
    }

    public EncodedFrame() {
        this(Inventor.ConstructorCommand.CreateInstance, EncodedFrame.ctorImpl());
    }

    public boolean isInteractive() {
        return EncodedFrame.isInteractiveImpl(this.getNativeResourceHandle());
    }

    public EncodedFrame(EncodedFrame encodedFrame) {
        this(Inventor.ConstructorCommand.CreateInstance, EncodedFrame.ctorImpl1(encodedFrame != null ? encodedFrame.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public boolean isLossless() {
        return EncodedFrame.isLosslessImpl(this.getNativeResourceHandle());
    }

    public long getId() {
        return EncodedFrame.getIdImpl(this.getNativeResourceHandle());
    }

    public long getBufferSize() {
        return EncodedFrame.getBufferSizeImpl(this.getNativeResourceHandle());
    }

    public EncodingFormats getEncodingFormat() {
        return (EncodingFormats)IntegerValuedEnumHelper.fromIntValue(EncodingFormats.class, (int)EncodedFrame.getEncodingFormatImpl(this.getNativeResourceHandle()));
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum EncodingFormats implements IntegerValuedEnum
    {
        JPEG(EncodingFormats.getJPEG()),
        PNG(EncodingFormats.getPNG()),
        H264(EncodingFormats.getH264()),
        VP9(EncodingFormats.getVP9());

        private int value;

        private static native int getJPEGNative();

        private EncodingFormats(int n2) {
            this.value = n2;
        }

        private static int getVP9() {
            JniInitializer.checkInit();
            return EncodingFormats.getVP9Native();
        }

        private static native int getVP9Native();

        private static int getH264() {
            JniInitializer.checkInit();
            return EncodingFormats.getH264Native();
        }

        private static native int getH264Native();

        private static int getPNG() {
            JniInitializer.checkInit();
            return EncodingFormats.getPNGNative();
        }

        private static native int getPNGNative();

        private static int getJPEG() {
            JniInitializer.checkInit();
            return EncodingFormats.getJPEGNative();
        }

        public int getValue() {
            return this.value;
        }

        public static EncodingFormats valueOf(int n) {
            return (EncodingFormats)IntegerValuedEnumHelper.fromIntValue(EncodingFormats.class, (int)n);
        }
    }
}

