/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.MetricsListener;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.util.EnumSet;

public class Monitoring
extends Inventor {
    private static native boolean isMetricEnabledImpl(long var0, int var2);

    private static native void addListenerImpl(long var0, long var2);

    private static native void enableMetricsImpl(long var0, int var2);

    private static native void removeListenerImpl(long var0, long var2);

    private static native int getNumListenersImpl(long var0);

    protected Monitoring(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void addListener(MetricsListener metricsListener) {
        Monitoring.addListenerImpl(this.getNativeResourceHandle(), metricsListener != null ? metricsListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public boolean isMetricEnabled(MetricTypes metricTypes) {
        return Monitoring.isMetricEnabledImpl(this.getNativeResourceHandle(), metricTypes.getValue());
    }

    public void removeListener(MetricsListener metricsListener) {
        Monitoring.removeListenerImpl(this.getNativeResourceHandle(), metricsListener != null ? metricsListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void enableMetrics(EnumSet<MetricTypes> enumSet) {
        int n = IntegerValuedEnumHelper.valueOf(enumSet);
        Monitoring.enableMetricsImpl(this.getNativeResourceHandle(), n);
    }

    public int getNumListeners() {
        return Monitoring.getNumListenersImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        private static native long getNativeObjectHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum MetricTypes implements IntegerValuedEnum
    {
        NONE(MetricTypes.getNONE()),
        NETWORK_LATENCY(MetricTypes.getNETWORKLATENCY()),
        DECODING_TIME(MetricTypes.getDECODINGTIME()),
        RENDERING_TIME(MetricTypes.getRENDERINGTIME()),
        ENCODING_TIME(MetricTypes.getENCODINGTIME()),
        NUM_CLIENTS(MetricTypes.getNUMCLIENTS()),
        NUM_CONNECTIONS(MetricTypes.getNUMCONNECTIONS()),
        NUM_RENDERAREAS(MetricTypes.getNUMRENDERAREAS()),
        ALL(MetricTypes.getALL());

        private int value;

        private static native int getNONENative();

        private static int getNUMCLIENTS() {
            JniInitializer.checkInit();
            return MetricTypes.getNUMCLIENTSNative();
        }

        private static native int getNUMCONNECTIONSNative();

        private static int getNUMCONNECTIONS() {
            JniInitializer.checkInit();
            return MetricTypes.getNUMCONNECTIONSNative();
        }

        private static native int getNUMRENDERAREASNative();

        private static int getNUMRENDERAREAS() {
            JniInitializer.checkInit();
            return MetricTypes.getNUMRENDERAREASNative();
        }

        private static native int getALLNative();

        private static int getALL() {
            JniInitializer.checkInit();
            return MetricTypes.getALLNative();
        }

        private MetricTypes(int n2) {
            this.value = n2;
        }

        private static native int getNUMCLIENTSNative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return MetricTypes.getNONENative();
        }

        private static native int getNETWORKLATENCYNative();

        private static int getNETWORKLATENCY() {
            JniInitializer.checkInit();
            return MetricTypes.getNETWORKLATENCYNative();
        }

        private static native int getDECODINGTIMENative();

        private static int getDECODINGTIME() {
            JniInitializer.checkInit();
            return MetricTypes.getDECODINGTIMENative();
        }

        private static native int getRENDERINGTIMENative();

        private static int getRENDERINGTIME() {
            JniInitializer.checkInit();
            return MetricTypes.getRENDERINGTIMENative();
        }

        private static native int getENCODINGTIMENative();

        private static int getENCODINGTIME() {
            JniInitializer.checkInit();
            return MetricTypes.getENCODINGTIMENative();
        }

        public int getValue() {
            return this.value;
        }

        public static MetricTypes valueOf(int n) {
            return (MetricTypes)IntegerValuedEnumHelper.fromIntValue(MetricTypes.class, (int)n);
        }
    }
}

