/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.touch.SoTouchManager;
import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.RenderAreaListener;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RenderArea
extends Inventor {
    private SoSceneManager m_SceneManager;
    private Set<RenderAreaListener> m_listenerList = new HashSet<RenderAreaListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddListener(RenderAreaListener renderAreaListener) {
        if (renderAreaListener != null) {
            Set<RenderAreaListener> set = this.m_listenerList;
            synchronized (set) {
                this.m_listenerList.add(renderAreaListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoveListener(RenderAreaListener renderAreaListener) {
        if (renderAreaListener != null) {
            Set<RenderAreaListener> set = this.m_listenerList;
            synchronized (set) {
                this.m_listenerList.remove((Object)renderAreaListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoveAllListeners() {
        Set<RenderAreaListener> set = this.m_listenerList;
        synchronized (set) {
            this.m_listenerList.clear();
        }
    }

    private static native void removeAllListenersImpl(long var0);

    private static native int getWidthImpl(long var0);

    private static native long getSceneManagerImpl(long var0);

    private static native void removeListenerImpl(long var0, long var2);

    private static native long getTouchManagerImpl(long var0);

    private static native void addListenerImpl(long var0, long var2);

    private static native long getGLContextImpl(long var0);

    private static native void closeConnectionsAndDisposeImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2, long[] var3);

    private static native void resizeImpl(long var0, int var2, int var3);

    private static native boolean sendMessageImpl1(long var0, byte[] var2, long[] var3);

    private static native int getNumConnectionsImpl(long var0);

    private static native boolean isDisposedImpl(long var0);

    private static native String getIdImpl(long var0);

    private static native void setFrameMessageImpl(long var0, String var2);

    private static native long getConnectionImpl(long var0, String var2);

    private static native String getGpuImpl(long var0);

    private static native long getConnectionImpl1(long var0, int var2);

    private static native int getNumListenersImpl(long var0);

    private static native int getHeightImpl(long var0);

    protected RenderArea(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public boolean sendMessage(String string) {
        return this.sendMessage(string, new ArrayList<Connection>());
    }

    public boolean sendMessage(Collection<Byte> collection) {
        return this.sendMessage(collection, new ArrayList<Connection>());
    }

    public int getNumConnections() {
        return RenderArea.getNumConnectionsImpl(this.getNativeResourceHandle());
    }

    public String getGpu() {
        return RenderArea.getGpuImpl(this.getNativeResourceHandle());
    }

    public Connection getConnection(int n) {
        return (Connection)ObjectManager.getManagedObjectFor(Connection.class, (Long)RenderArea.getConnectionImpl1(this.getNativeResourceHandle(), n));
    }

    public void setFrameMessage(String string) {
        RenderArea.setFrameMessageImpl(this.getNativeResourceHandle(), string);
    }

    public Connection getConnection(String string) {
        return (Connection)ObjectManager.getManagedObjectFor(Connection.class, (Long)RenderArea.getConnectionImpl(this.getNativeResourceHandle(), string));
    }

    public String getId() {
        return RenderArea.getIdImpl(this.getNativeResourceHandle());
    }

    public boolean isDisposed() {
        return RenderArea.isDisposedImpl(this.getNativeResourceHandle());
    }

    public int getNumListeners() {
        return RenderArea.getNumListenersImpl(this.getNativeResourceHandle());
    }

    public int getWidth() {
        return RenderArea.getWidthImpl(this.getNativeResourceHandle());
    }

    public void resize(int n, int n2) {
        RenderArea.resizeImpl(this.getNativeResourceHandle(), n, n2);
    }

    public boolean sendMessage(Collection<Byte> collection, Collection<Connection> collection2) {
        int n;
        if (collection == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        byte[] byArray = new byte[collection.size()];
        int n2 = 0;
        Object object = collection.iterator();
        while (object.hasNext()) {
            n = object.next().byteValue();
            byArray[n2++] = n;
        }
        if (collection2 == null) {
            throw new IllegalArgumentException("excludedConnections cannot be null");
        }
        object = new long[collection2.size()];
        n = 0;
        for (Connection connection : collection2) {
            object[n++] = connection != null ? connection.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        return RenderArea.sendMessageImpl1(this.getNativeResourceHandle(), byArray, (long[])object);
    }

    public void closeConnectionsAndDispose() {
        RenderArea.closeConnectionsAndDisposeImpl(this.getNativeResourceHandle());
    }

    public boolean sendMessage(String string, Collection<Connection> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("excludedConnections cannot be null");
        }
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (Connection connection : collection) {
            lArray[n++] = connection != null ? connection.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        return RenderArea.sendMessageImpl(this.getNativeResourceHandle(), string, lArray);
    }

    public void addListener(RenderAreaListener renderAreaListener) {
        this.onAddListener(renderAreaListener);
        RenderArea.addListenerImpl(this.getNativeResourceHandle(), renderAreaListener != null ? renderAreaListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoGLContext getGLContext() {
        return (SoGLContext)ObjectManager.getManagedObjectFor(SoGLContext.class, (Long)RenderArea.getGLContextImpl(this.getNativeResourceHandle()));
    }

    public void removeListener(RenderAreaListener renderAreaListener) {
        this.onRemoveListener(renderAreaListener);
        RenderArea.removeListenerImpl(this.getNativeResourceHandle(), renderAreaListener != null ? renderAreaListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoTouchManager getTouchManager() {
        return (SoTouchManager)ObjectManager.getManagedObjectFor(SoTouchManager.class, (Long)RenderArea.getTouchManagerImpl(this.getNativeResourceHandle()));
    }

    public void removeAllListeners() {
        this.onRemoveAllListeners();
        RenderArea.removeAllListenersImpl(this.getNativeResourceHandle());
    }

    public SoSceneManager getSceneManager() {
        this.m_SceneManager = (SoSceneManager)ObjectManager.getManagedObjectFor(SoSceneManager.class, (Long)RenderArea.getSceneManagerImpl(this.getNativeResourceHandle()));
        return this.m_SceneManager;
    }

    public int getHeight() {
        return RenderArea.getHeightImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        private static native long getNativeObjectHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

