/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaHardware;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;

public class Service
extends Inventor {
    private static native int getNumRenderAreasImpl(long var0);

    private static native boolean isRunningImpl(long var0);

    private static native void removeAllListenersImpl(long var0);

    private static native void createRenderAreaImpl(long var0, String var2, int var3, int var4, long var5);

    private static native void removeListenerImpl(long var0, long var2);

    private static native long getRenderAreaImpl(long var0, String var2);

    private static native void addListenerImpl(long var0, long var2);

    private static native long getRenderAreaImpl1(long var0, int var2);

    private static native long getSettingsImpl(long var0);

    private static native int getNumListenersImpl(long var0);

    private static native long instanceImpl();

    private static native int getNumClientsImpl(long var0);

    private static native void dispatchImpl(long var0);

    private static native long getClientImpl1(long var0, int var2);

    private static native boolean openImpl(long var0, long var2);

    private static native long getClientImpl(long var0, String var2);

    private static native boolean closeImpl(long var0);

    protected Service(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac")) {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public int getNumRenderAreas() {
        return Service.getNumRenderAreasImpl(this.getNativeResourceHandle());
    }

    public boolean close() {
        return Service.closeImpl(this.getNativeResourceHandle());
    }

    public Client getClient(int n) {
        return (Client)ObjectManager.getManagedObjectFor(Client.class, (Long)Service.getClientImpl1(this.getNativeResourceHandle(), n));
    }

    public boolean open(ServiceSettings serviceSettings) {
        return Service.openImpl(this.getNativeResourceHandle(), serviceSettings != null ? serviceSettings.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public int getNumClients() {
        return Service.getNumClientsImpl(this.getNativeResourceHandle());
    }

    public void dispatch() {
        Service.dispatchImpl(this.getNativeResourceHandle());
    }

    public static Service instance() {
        return (Service)ObjectManager.getManagedObjectFor(Service.class, (Long)Service.instanceImpl());
    }

    public Client getClient(String string) {
        return (Client)ObjectManager.getManagedObjectFor(Client.class, (Long)Service.getClientImpl(this.getNativeResourceHandle(), string));
    }

    public void addListener(ServiceListener serviceListener) {
        Service.addListenerImpl(this.getNativeResourceHandle(), serviceListener != null ? serviceListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public RenderArea getRenderArea(int n) {
        return (RenderArea)ObjectManager.getManagedObjectFor(RenderArea.class, (Long)Service.getRenderAreaImpl1(this.getNativeResourceHandle(), n));
    }

    public void removeListener(ServiceListener serviceListener) {
        Service.removeListenerImpl(this.getNativeResourceHandle(), serviceListener != null ? serviceListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public RenderArea getRenderArea(String string) {
        return (RenderArea)ObjectManager.getManagedObjectFor(RenderArea.class, (Long)Service.getRenderAreaImpl(this.getNativeResourceHandle(), string));
    }

    public void removeAllListeners() {
        Service.removeAllListenersImpl(this.getNativeResourceHandle());
    }

    public void createRenderArea(String string, int n, int n2, RenderAreaHardware renderAreaHardware) {
        Service.createRenderAreaImpl(this.getNativeResourceHandle(), string, n, n2, renderAreaHardware != null ? renderAreaHardware.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public int getNumListeners() {
        return Service.getNumListenersImpl(this.getNativeResourceHandle());
    }

    public ServiceSettings getSettings() {
        return (ServiceSettings)ObjectManager.getManagedObjectFor(ServiceSettings.class, (Long)Service.getSettingsImpl(this.getNativeResourceHandle()));
    }

    public boolean isRunning() {
        return Service.isRunningImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

