/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.LicenseManager;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.Monitoring;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.util.EnumSet;

public class ServiceSettings
extends Inventor
implements Cloneable {
    private void checkExtensions(EnumSet<Extensions> enumSet) {
        if (enumSet.contains((Object)Extensions.MESHVIZXLM)) {
            LicenseManager.checkMVizXLMLP();
        }
    }

    private static native void enableSecureConnectionImpl2(long var0, String var2, String var3, int var4);

    @Deprecated(since="9.7.2")
    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols) {
        ServiceSettings.enableSecureConnectionImpl2(this.getNativeResourceHandle(), string, string2, securityProtocols.getValue());
    }

    @Deprecated(since="9.8.0")
    public void enableSecureConnection(String string, String string2, int n) {
        ServiceSettings.enableSecureConnectionImpl2(this.getNativeResourceHandle(), string, string2, n);
    }

    @Deprecated(since="9.8.0")
    public Extensions getUsedExtensions() {
        return (Extensions)IntegerValuedEnumHelper.fromIntValue(Extensions.class, (int)ServiceSettings.getOivUsedExtensionsImpl(this.getNativeResourceHandle()));
    }

    @Deprecated(since="9.8.0")
    public void setUsedExtensions(Extensions extensions) {
        this.checkExtensions(EnumSet.of(extensions));
        ServiceSettings.setOivUsedExtensionsImpl(this.getNativeResourceHandle(), extensions.getValue());
    }

    private static native long getMonitoringImpl(long var0);

    private static native String getHostnameImpl(long var0);

    private static native void setOivUsedExtensionsImpl(long var0, int var2);

    private static native int getOivUsedExtensionsImpl(long var0);

    private static native void toArrayImpl(long var0, long[] var2);

    private static native void enableSecureConnectionImpl(long var0, String var2, String var3, int var4);

    private static native boolean isSecureConnectionImpl(long var0);

    private static native void setValueImpl(long var0, long var2);

    private static native String getPrivateKeyFileImpl(long var0);

    private static native String getPublicCertificateFileImpl(long var0);

    private static native long ctorImpl1(long var0);

    private static native long ctorImpl();

    private static native int getEnabledSecurityProtocolsImpl(long var0);

    private static native int getRunModeImpl(long var0);

    private static native void setPortImpl(long var0, int var2);

    private static native void setRunModeImpl(long var0, int var2);

    private static native String getIPImpl(long var0);

    private static native void setIPImpl(long var0, String var2);

    private static native int getPortImpl(long var0);

    protected ServiceSettings(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void enableSecureConnection(String string, String string2) {
        this.enableSecureConnection(string, string2, EnumSet.of(SecurityProtocols.TLSv1_1, SecurityProtocols.TLSv1_2, SecurityProtocols.TLSv1_3));
    }

    public Object clone() {
        ServiceSettings serviceSettings = new ServiceSettings(this);
        return serviceSettings;
    }

    public static ServiceSettings[] toArray(long l, long l2) {
        ServiceSettings[] serviceSettingsArray = new ServiceSettings[(int)l2];
        long[] lArray = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            serviceSettingsArray[n] = new ServiceSettings();
            lArray[n] = serviceSettingsArray[n].getNativeResourceHandle();
            ++n;
        }
        ServiceSettings.toArrayImpl(l, lArray);
        return serviceSettingsArray;
    }

    public String getPublicCertificateFile() {
        return ServiceSettings.getPublicCertificateFileImpl(this.getNativeResourceHandle());
    }

    public RunModes getRunMode() {
        return (RunModes)IntegerValuedEnumHelper.fromIntValue(RunModes.class, (int)ServiceSettings.getRunModeImpl(this.getNativeResourceHandle()));
    }

    public String getHostname() {
        return ServiceSettings.getHostnameImpl(this.getNativeResourceHandle());
    }

    public void setIP(String string) {
        ServiceSettings.setIPImpl(this.getNativeResourceHandle(), string);
    }

    public void setValue(ServiceSettings serviceSettings) {
        ServiceSettings.setValueImpl(this.getNativeResourceHandle(), serviceSettings.getNativeResourceHandle());
    }

    public String getPrivateKeyFile() {
        return ServiceSettings.getPrivateKeyFileImpl(this.getNativeResourceHandle());
    }

    public Monitoring getMonitoring() {
        return (Monitoring)ObjectManager.getManagedObjectFor(Monitoring.class, (Long)ServiceSettings.getMonitoringImpl(this.getNativeResourceHandle()));
    }

    public void enableSecureConnection(String string, String string2, EnumSet<SecurityProtocols> enumSet) {
        int n = IntegerValuedEnumHelper.valueOf(enumSet);
        ServiceSettings.enableSecureConnectionImpl(this.getNativeResourceHandle(), string, string2, n);
    }

    public int getPort() {
        return ServiceSettings.getPortImpl(this.getNativeResourceHandle());
    }

    public boolean isSecureConnection() {
        return ServiceSettings.isSecureConnectionImpl(this.getNativeResourceHandle());
    }

    public void setRunMode(RunModes runModes) {
        ServiceSettings.setRunModeImpl(this.getNativeResourceHandle(), runModes.getValue());
    }

    public SecurityProtocols getEnabledSecurityProtocols() {
        return (SecurityProtocols)IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, (int)ServiceSettings.getEnabledSecurityProtocolsImpl(this.getNativeResourceHandle()));
    }

    public void setPort(int n) {
        ServiceSettings.setPortImpl(this.getNativeResourceHandle(), n);
    }

    public EnumSet<Extensions> getOivUsedExtensions() {
        return IntegerValuedEnumHelper.enumSetOf(Extensions.class, (int)ServiceSettings.getOivUsedExtensionsImpl(this.getNativeResourceHandle()));
    }

    public void setOivUsedExtensions(EnumSet<Extensions> enumSet) {
        this.checkExtensions(enumSet);
        int n = IntegerValuedEnumHelper.valueOf(enumSet);
        ServiceSettings.setOivUsedExtensionsImpl(this.getNativeResourceHandle(), n);
    }

    public ServiceSettings(ServiceSettings serviceSettings) {
        this(Inventor.ConstructorCommand.CreateInstance, ServiceSettings.ctorImpl1(serviceSettings != null ? serviceSettings.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public String getIP() {
        return ServiceSettings.getIPImpl(this.getNativeResourceHandle());
    }

    public ServiceSettings() {
        this(Inventor.ConstructorCommand.CreateInstance, ServiceSettings.ctorImpl());
    }

    static {
        JarInitializer.checkInit();
    }

    public static enum Extensions implements IntegerValuedEnum
    {
        VOLUMEVIZ(Extensions.getVOLUMEVIZ()),
        VOLUMEVIZLDM(Extensions.getVOLUMEVIZLDM()),
        MESHVIZ(Extensions.getMESHVIZ()),
        MESHVIZXLM(Extensions.getMESHVIZXLM()),
        HARDCOPY(Extensions.getHARDCOPY()),
        CATIA5READER(Extensions.getCATIA5READER()),
        CATIA6READER(Extensions.getCATIA6READER()),
        DWGREADER(Extensions.getDWGREADER()),
        IGESREADER(Extensions.getIGESREADER()),
        JTREADER(Extensions.getJTREADER()),
        PROEREADER(Extensions.getPROEREADER()),
        SOLIDEDGEREADER(Extensions.getSOLIDEDGEREADER()),
        STEPREADER(Extensions.getSTEPREADER()),
        SOLIDWORKSREADER(Extensions.getSOLIDWORKSREADER()),
        UGREADER(Extensions.getUGREADER()),
        VDAREADER(Extensions.getVDAREADER()),
        XMTREADER(Extensions.getXMTREADER());

        private int value;

        private static native int getVOLUMEVIZNative();

        private static int getSTEPREADER() {
            JniInitializer.checkInit();
            return Extensions.getSTEPREADERNative();
        }

        private static native int getSTEPREADERNative();

        private static int getSOLIDEDGEREADER() {
            JniInitializer.checkInit();
            return Extensions.getSOLIDEDGEREADERNative();
        }

        private static native int getSOLIDEDGEREADERNative();

        private static int getPROEREADER() {
            JniInitializer.checkInit();
            return Extensions.getPROEREADERNative();
        }

        private static native int getPROEREADERNative();

        private static int getJTREADER() {
            JniInitializer.checkInit();
            return Extensions.getJTREADERNative();
        }

        private static native int getSOLIDWORKSREADERNative();

        private Extensions(int n2) {
            this.value = n2;
        }

        private static int getXMTREADER() {
            JniInitializer.checkInit();
            return Extensions.getXMTREADERNative();
        }

        private static native int getXMTREADERNative();

        private static int getVDAREADER() {
            JniInitializer.checkInit();
            return Extensions.getVDAREADERNative();
        }

        private static native int getVDAREADERNative();

        private static int getUGREADER() {
            JniInitializer.checkInit();
            return Extensions.getUGREADERNative();
        }

        private static native int getUGREADERNative();

        private static int getSOLIDWORKSREADER() {
            JniInitializer.checkInit();
            return Extensions.getSOLIDWORKSREADERNative();
        }

        private static native int getJTREADERNative();

        private static native int getHARDCOPYNative();

        private static int getMESHVIZXLM() {
            JniInitializer.checkInit();
            return Extensions.getMESHVIZXLMNative();
        }

        private static native int getMESHVIZXLMNative();

        private static int getMESHVIZ() {
            JniInitializer.checkInit();
            return Extensions.getMESHVIZNative();
        }

        private static native int getMESHVIZNative();

        private static int getVOLUMEVIZLDM() {
            JniInitializer.checkInit();
            return Extensions.getVOLUMEVIZLDMNative();
        }

        private static native int getVOLUMEVIZLDMNative();

        private static int getVOLUMEVIZ() {
            JniInitializer.checkInit();
            return Extensions.getVOLUMEVIZNative();
        }

        private static int getHARDCOPY() {
            JniInitializer.checkInit();
            return Extensions.getHARDCOPYNative();
        }

        private static int getIGESREADER() {
            JniInitializer.checkInit();
            return Extensions.getIGESREADERNative();
        }

        private static native int getIGESREADERNative();

        private static int getDWGREADER() {
            JniInitializer.checkInit();
            return Extensions.getDWGREADERNative();
        }

        private static native int getDWGREADERNative();

        private static int getCATIA6READER() {
            JniInitializer.checkInit();
            return Extensions.getCATIA6READERNative();
        }

        private static native int getCATIA6READERNative();

        private static int getCATIA5READER() {
            JniInitializer.checkInit();
            return Extensions.getCATIA5READERNative();
        }

        private static native int getCATIA5READERNative();

        public int getValue() {
            return this.value;
        }

        public static Extensions valueOf(int n) {
            return (Extensions)IntegerValuedEnumHelper.fromIntValue(Extensions.class, (int)n);
        }
    }

    public static enum SecurityProtocols implements IntegerValuedEnum
    {
        SSLv2(SecurityProtocols.getSSLv2()),
        SSLv3(SecurityProtocols.getSSLv3()),
        TLSv1(SecurityProtocols.getTLSv1()),
        TLSv1_1(SecurityProtocols.getTLSv11()),
        TLSv1_2(SecurityProtocols.getTLSv12()),
        TLSv1_3(SecurityProtocols.getTLSv13());

        private int value;

        private static native int getSSLv2Native();

        private SecurityProtocols(int n2) {
            this.value = n2;
        }

        private static int getTLSv13() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv13Native();
        }

        private static native int getTLSv13Native();

        private static int getTLSv12() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv12Native();
        }

        private static native int getTLSv12Native();

        private static int getTLSv11() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv11Native();
        }

        private static int getSSLv2() {
            JniInitializer.checkInit();
            return SecurityProtocols.getSSLv2Native();
        }

        private static native int getSSLv3Native();

        private static int getSSLv3() {
            JniInitializer.checkInit();
            return SecurityProtocols.getSSLv3Native();
        }

        private static native int getTLSv1Native();

        private static int getTLSv1() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv1Native();
        }

        private static native int getTLSv11Native();

        public int getValue() {
            return this.value;
        }

        public static SecurityProtocols valueOf(int n) {
            return (SecurityProtocols)IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, (int)n);
        }
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        private static native long getNativeObjectHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum RunModes implements IntegerValuedEnum
    {
        INVENTOR_SERVICE(RunModes.getINVENTORSERVICE()),
        INVENTOR_APPLICATION(RunModes.getINVENTORAPPLICATION()),
        INDEPENDENT_SERVICE(RunModes.getINDEPENDENTSERVICE());

        private int value;

        private static native int getINVENTORSERVICENative();

        private RunModes(int n2) {
            this.value = n2;
        }

        private static int getINDEPENDENTSERVICE() {
            JniInitializer.checkInit();
            return RunModes.getINDEPENDENTSERVICENative();
        }

        private static native int getINDEPENDENTSERVICENative();

        private static int getINVENTORAPPLICATION() {
            JniInitializer.checkInit();
            return RunModes.getINVENTORAPPLICATIONNative();
        }

        private static native int getINVENTORAPPLICATIONNative();

        private static int getINVENTORSERVICE() {
            JniInitializer.checkInit();
            return RunModes.getINVENTORSERVICENative();
        }

        public int getValue() {
            return this.value;
        }

        public static RunModes valueOf(int n) {
            return (RunModes)IntegerValuedEnumHelper.fromIntValue(RunModes.class, (int)n);
        }
    }
}

