/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.volumeviz.internal.JarInitializer;
import com.openinventor.volumeviz.internal.JniInitializer;
import com.openinventor.volumeviz.readers.dicom.SiDicomDataSet;

public class SoVRDicomData
extends Inventor {
    private static native long getDicomDataSetImpl(long var0);

    private static native int getImageNumberImpl(long var0);

    private static native int getImageWidthImpl(long var0);

    private static native float getSliceLocationImpl(long var0);

    private static native int getNumFramesImpl(long var0);

    private static native float getXPixelSizeImpl(long var0);

    private static native boolean closeImpl(long var0);

    private static native int getImageHeightImpl(long var0);

    private static native boolean supportedTransferSyntaxImpl(long var0);

    private static native int getSamplesPerPixelImpl(long var0);

    private static native float getSliceThicknessMMImpl(long var0);

    private static native int getBytesPerPixelImpl(long var0);

    private static native float getSliceSpacingImpl(long var0);

    private static native int getSizeInBytesImpl(long var0);

    private static native int getSeriesNumberImpl(long var0);

    private static native float getYPixelSizeImpl(long var0);

    private static native int getHighBitImpl(long var0);

    private static native long ctorImpl();

    private static native int signedDataImpl(long var0);

    private static native float getInterceptImpl(long var0);

    private static native float getSlopeImpl(long var0);

    private static native String getDicomInfoImpl(long var0, short var2, short var3);

    private static native int getBitsStoredImpl(long var0);

    private static native boolean getPositionImpl(long var0, float[] var2);

    private static native boolean readDicomImageImpl(long var0, String var2);

    private static native void getImagePositionImpl(long var0, float[] var2);

    private static native boolean getOrientationImpl(long var0, float[] var2);

    private static native boolean readDicomHeaderImpl(long var0, String var2);

    protected SoVRDicomData(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public boolean readDicomHeader(String string) {
        return SoVRDicomData.readDicomHeaderImpl(this.getNativeResourceHandle(), string);
    }

    public SiDicomDataSet getDicomDataSet() {
        return (SiDicomDataSet)ObjectManager.getManagedObjectFor(SiDicomDataSet.class, (Long)SoVRDicomData.getDicomDataSetImpl(this.getNativeResourceHandle()));
    }

    public int getBitsStored() {
        return SoVRDicomData.getBitsStoredImpl(this.getNativeResourceHandle());
    }

    public SbMatrix getOrientation() {
        SbMatrix sbMatrix = new SbMatrix();
        boolean bl = false;
        bl = SoVRDicomData.getOrientationImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        if (bl) {
            return sbMatrix;
        }
        return null;
    }

    public boolean readDicomImage(String string) {
        return SoVRDicomData.readDicomImageImpl(this.getNativeResourceHandle(), string);
    }

    public int getHighBit() {
        return SoVRDicomData.getHighBitImpl(this.getNativeResourceHandle());
    }

    public int signedData() {
        return SoVRDicomData.signedDataImpl(this.getNativeResourceHandle());
    }

    public SoVRDicomData() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRDicomData.ctorImpl());
    }

    public float getIntercept() {
        return SoVRDicomData.getInterceptImpl(this.getNativeResourceHandle());
    }

    public float getSlope() {
        return SoVRDicomData.getSlopeImpl(this.getNativeResourceHandle());
    }

    public String getDicomInfo(short s, short s2) {
        return SoVRDicomData.getDicomInfoImpl(this.getNativeResourceHandle(), s, s2);
    }

    public SbVec3f getImagePosition() {
        SbVec3f sbVec3f = new SbVec3f();
        SoVRDicomData.getImagePositionImpl(this.getNativeResourceHandle(), sbVec3f.array);
        return sbVec3f;
    }

    public int getImageNumber() {
        return SoVRDicomData.getImageNumberImpl(this.getNativeResourceHandle());
    }

    public int getSizeInBytes() {
        return SoVRDicomData.getSizeInBytesImpl(this.getNativeResourceHandle());
    }

    public int getSeriesNumber() {
        return SoVRDicomData.getSeriesNumberImpl(this.getNativeResourceHandle());
    }

    public int getBytesPerPixel() {
        return SoVRDicomData.getBytesPerPixelImpl(this.getNativeResourceHandle());
    }

    public float getSliceSpacing() {
        return SoVRDicomData.getSliceSpacingImpl(this.getNativeResourceHandle());
    }

    public int getSamplesPerPixel() {
        return SoVRDicomData.getSamplesPerPixelImpl(this.getNativeResourceHandle());
    }

    public float getSliceThicknessMM() {
        return SoVRDicomData.getSliceThicknessMMImpl(this.getNativeResourceHandle());
    }

    public boolean supportedTransferSyntax() {
        return SoVRDicomData.supportedTransferSyntaxImpl(this.getNativeResourceHandle());
    }

    public int getImageHeight() {
        return SoVRDicomData.getImageHeightImpl(this.getNativeResourceHandle());
    }

    public SbVec3f getPosition() {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        bl = SoVRDicomData.getPositionImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    public boolean close() {
        return SoVRDicomData.closeImpl(this.getNativeResourceHandle());
    }

    public float getYPixelSize() {
        return SoVRDicomData.getYPixelSizeImpl(this.getNativeResourceHandle());
    }

    public int getNumFrames() {
        return SoVRDicomData.getNumFramesImpl(this.getNativeResourceHandle());
    }

    public float getXPixelSize() {
        return SoVRDicomData.getXPixelSizeImpl(this.getNativeResourceHandle());
    }

    public int getImageWidth() {
        return SoVRDicomData.getImageWidthImpl(this.getNativeResourceHandle());
    }

    public float getSliceLocation() {
        return SoVRDicomData.getSliceLocationImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

