/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers.dicom;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.volumeviz.internal.JarInitializer;
import com.openinventor.volumeviz.internal.JniInitializer;

public class SiDicomValue
extends Inventor {
    private static native long getIntImpl(long var0, long var2);

    private static native String asStringImpl(long var0);

    private static native long getLengthImpl(long var0);

    private static native String getStringImpl(long var0, long var2);

    private static native int getValueTypeImpl(long var0);

    private static native void getBufferImpl(long var0, long var2);

    private static native long cloneImpl(long var0);

    private static native long getUIntImpl(long var0, long var2);

    private static native double getDoubleImpl(long var0, long var2);

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiDicomValue(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public String getString() {
        return this.getString(0L);
    }

    public long getInt() {
        return this.getInt(0L);
    }

    public long getUInt() {
        return this.getUInt(0L);
    }

    public double getDouble() {
        return this.getDouble(0L);
    }

    public double getDouble(long l) {
        return SiDicomValue.getDoubleImpl(this.getNativeResourceHandle(), l);
    }

    public void getBuffer(SoBufferObject soBufferObject) {
        SiDicomValue.getBufferImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public String asString() {
        return SiDicomValue.asStringImpl(this.getNativeResourceHandle());
    }

    public long getLength() {
        return SiDicomValue.getLengthImpl(this.getNativeResourceHandle());
    }

    public long getInt(long l) {
        return SiDicomValue.getIntImpl(this.getNativeResourceHandle(), l);
    }

    public ValueTypes getValueType() {
        return (ValueTypes)IntegerValuedEnumHelper.fromIntValue(ValueTypes.class, (int)SiDicomValue.getValueTypeImpl(this.getNativeResourceHandle()));
    }

    public long getUInt(long l) {
        return SiDicomValue.getUIntImpl(this.getNativeResourceHandle(), l);
    }

    public SiDicomValue clone() {
        return (SiDicomValue)ObjectManager.getManagedObjectFor(SiDicomValue.class, (Long)SiDicomValue.cloneImpl(this.getNativeResourceHandle()));
    }

    public String getString(long l) {
        return SiDicomValue.getStringImpl(this.getNativeResourceHandle(), l);
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum ValueTypes implements IntegerValuedEnum
    {
        BUFFER(ValueTypes.getBUFFER()),
        STRING(ValueTypes.getSTRING()),
        INT(ValueTypes.getINT()),
        UINT(ValueTypes.getUINT()),
        DOUBLE(ValueTypes.getDOUBLE());

        private int value;

        private static native int getBUFFERNative();

        private ValueTypes(int n2) {
            this.value = n2;
        }

        private static int getDOUBLE() {
            JniInitializer.checkInit();
            return ValueTypes.getDOUBLENative();
        }

        private static native int getDOUBLENative();

        private static int getUINT() {
            JniInitializer.checkInit();
            return ValueTypes.getUINTNative();
        }

        private static native int getUINTNative();

        private static int getBUFFER() {
            JniInitializer.checkInit();
            return ValueTypes.getBUFFERNative();
        }

        private static native int getSTRINGNative();

        private static int getSTRING() {
            JniInitializer.checkInit();
            return ValueTypes.getSTRINGNative();
        }

        private static native int getINTNative();

        private static int getINT() {
            JniInitializer.checkInit();
            return ValueTypes.getINTNative();
        }

        public int getValue() {
            return this.value;
        }

        public static ValueTypes valueOf(int n) {
            return (ValueTypes)IntegerValuedEnumHelper.fromIntValue(ValueTypes.class, (int)n);
        }
    }
}

