/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.viewercomponents.SoRawStereoParameters;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import com.openinventor.inventor.viewercomponents.awt.IRenderArea;
import com.openinventor.inventor.viewercomponents.awt.Timer;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.OptionalStereoGLCapabilitiesChooser;
import java.awt.Canvas;
import java.awt.GraphicsDevice;

public class RenderArea
extends GLCanvas
implements GLEventListener,
IRenderArea {
    protected SoRenderAreaCore m_renderAreaCore = null;
    protected SoNode m_sceneGraph = null;
    protected SoGLRenderAction.TransparencyTypes m_transparencyType;
    private SoGLRenderAction m_glRenderAction;
    private SoSceneManager.AntialiasingModes m_antialiasingMode;
    private float m_antialiasingQuality;
    private int m_stillAntialiasingDelay;
    private float m_stillAntialiasingQuality;
    private boolean m_stereo;
    private boolean m_customGlRenderAction;

    public RenderArea() {
        this(null, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser(), null);
    }

    public RenderArea(GLCapabilities gLCapabilities) {
        this((GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser(), null);
    }

    private RenderArea(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        super(gLCapabilitiesImmutable, gLCapabilitiesChooser, graphicsDevice);
        SoDB.setSystemTimer((SoSystemTimer)new Timer());
        this.addGLEventListener(this);
        this.m_transparencyType = SoGLRenderAction.TransparencyTypes.NO_SORT;
        this.m_glRenderAction = null;
        this.m_antialiasingMode = SoSceneManager.AntialiasingModes.NO_ANTIALIASING;
        this.m_antialiasingQuality = 0.0f;
        this.m_stillAntialiasingDelay = 0;
        this.m_stillAntialiasingQuality = 0.0f;
        this.m_stereo = false;
        this.m_customGlRenderAction = false;
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        this.m_transparencyType = transparencyTypes;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        }
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        if (this.m_renderAreaCore != null) {
            return this.m_renderAreaCore.getTransparencyType();
        }
        return this.m_transparencyType;
    }

    @Override
    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_glRenderAction = soGLRenderAction;
        this.m_customGlRenderAction = true;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setGLRenderAction(soGLRenderAction);
        }
    }

    @Override
    public SoGLRenderAction getGLRenderAction() {
        if (this.m_renderAreaCore != null) {
            return this.m_renderAreaCore.getGLRenderAction();
        }
        return this.m_glRenderAction;
    }

    @Override
    public float getAntialiasingQuality() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingQuality;
        }
        return this.m_renderAreaCore.getAntialiasingQuality();
    }

    @Override
    public void setAntialiasingQuality(float f) {
        this.m_antialiasingQuality = f;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setAntialiasingQuality(f);
        }
    }

    @Override
    public SoSceneManager.AntialiasingModes getAntialiasingMode() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingMode;
        }
        return this.m_renderAreaCore.getAntialiasingMode();
    }

    @Override
    public void setAntialiasingMode(SoSceneManager.AntialiasingModes antialiasingModes) {
        this.m_antialiasingMode = antialiasingModes;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setAntialiasingMode(antialiasingModes);
        }
    }

    @Override
    public float getStillSuperSamplingQuality() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingQuality;
        }
        return this.m_renderAreaCore.getAntialiasingQuality();
    }

    @Override
    public void setStillSuperSamplingQuality(float f) {
        this.m_stillAntialiasingQuality = f;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setStillSuperSamplingQuality(f);
        }
    }

    @Override
    public int getStillSuperSamplingDelay() {
        if (this.m_renderAreaCore == null) {
            return this.m_stillAntialiasingDelay;
        }
        return this.m_renderAreaCore.getStillSuperSamplingDelay();
    }

    @Override
    public void setStillSuperSamplingDelay(int n) {
        this.m_stillAntialiasingDelay = n;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setStillSuperSamplingDelay(n);
        }
    }

    @Override
    public void activateStereo(boolean bl) {
        this.m_stereo = bl;
        if (this.m_renderAreaCore == null) {
            return;
        }
        if (bl) {
            if (!this.isRawStereoAvailable()) {
                throw new UnsupportedOperationException("Stereo buffers are not enabled");
            }
            SoRawStereoParameters soRawStereoParameters = new SoRawStereoParameters();
            this.m_renderAreaCore.setStereoParameters((SoStereoParameters)soRawStereoParameters);
            this.m_renderAreaCore.activateStereo(true);
        } else {
            this.m_renderAreaCore.activateStereo(false);
        }
    }

    @Override
    public boolean isRawStereoAvailable() {
        return this.getChosenGLCapabilities().getStereo();
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setSceneGraph(soNode);
        }
    }

    @Override
    public Canvas getComponent() {
        return this;
    }

    @Override
    public void scheduleRedraw() {
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().scheduleRedraw();
        }
    }

    protected void render() {
        this.m_renderAreaCore.render();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        SoGLContext soGLContext = SoGLContext.getCurrent((boolean)true);
        this.m_renderAreaCore = new SoRenderAreaCore(soGLContext);
        this.m_renderAreaCore.setSceneGraph(this.m_sceneGraph);
        this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        if (this.m_glRenderAction == null) {
            this.m_glRenderAction = this.m_renderAreaCore.getGLRenderAction();
        } else {
            this.m_renderAreaCore.setGLRenderAction(this.m_glRenderAction);
        }
        this.m_renderAreaCore.setAntialiasingMode(this.m_antialiasingMode);
        this.m_renderAreaCore.setAntialiasingQuality(this.m_antialiasingQuality);
        this.m_renderAreaCore.setStillSuperSamplingDelay(this.m_stillAntialiasingDelay);
        this.m_renderAreaCore.setStillSuperSamplingQuality(this.m_stillAntialiasingQuality);
        this.activateStereo(this.m_stereo);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (!this.m_customGlRenderAction) {
            this.m_glRenderAction = null;
        }
        this.m_renderAreaCore.dispose();
    }

    @Override
    public void dispose() {
        this.destroy();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
    }
}

