/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.newt.viewers;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.PreferencesDialog;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ViewerExaminer
extends JPanel
implements IViewerExaminer {
    private RenderAreaExaminer m_renderArea = new RenderAreaExaminer(true);
    private JToggleButton m_seekButton;

    public ViewerExaminer() {
        this.m_renderArea.addInteractionModeListener(new SceneExaminer.InteractionModeListener(){

            public void seekModeChanged(boolean bl) {
                ViewerExaminer.this.m_seekButton.setSelected(bl);
            }

            public void interactionModeChanged(SceneExaminer.InteractionMode interactionMode) {
                ViewerExaminer.this.updateUI(ViewerExaminer.this.m_renderArea.getInteractionMode());
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.m_renderArea));
        JPanel jPanel2 = this.buildToolsPanel();
        this.updateUI(this.m_renderArea.getInteractionMode());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "East");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_renderArea.setSceneGraph(soNode);
    }

    @Override
    public void viewAll() {
        this.m_renderArea.viewAll(new SbViewportRegion(this.m_renderArea.getSize()));
    }

    @Override
    public RenderAreaExaminer getRenderArea() {
        return this.m_renderArea;
    }

    @Override
    public void dispose() {
        this.m_renderArea.dispose();
    }

    private void updateUI(SceneExaminer.InteractionMode interactionMode) {
        switch (interactionMode) {
            case NAVIGATION: {
                this.m_seekButton.setEnabled(true);
                break;
            }
            case SELECTION: {
                this.m_seekButton.setSelected(false);
                this.m_seekButton.setEnabled(false);
                break;
            }
        }
    }

    private JPanel buildToolsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton("");
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("View All");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewAllTech.png")));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.viewAll();
            }
        });
        JButton jButton2 = new JButton("");
        jButton2.setToolTipText("YZ view");
        jButton2.setContentAreaFilled(false);
        jButton2.setBorderPainted(false);
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)jButton2, gridBagConstraints2);
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewYZTech.png")));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.viewAxis(new SbVec3f(-1.0f, 0.0f, 0.0f), new SbVec3f(0.0f, 0.0f, 1.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        JButton jButton3 = new JButton("");
        jButton3.setToolTipText("XZ view");
        jButton3.setContentAreaFilled(false);
        jButton3.setBorderPainted(false);
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        jPanel.add((Component)jButton3, gridBagConstraints3);
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewXZTech.png")));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.viewAxis(new SbVec3f(0.0f, -1.0f, 0.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        JButton jButton4 = new JButton("");
        jButton4.setToolTipText("XY view");
        jButton4.setContentAreaFilled(false);
        jButton4.setBorderPainted(false);
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        jPanel.add((Component)jButton4, gridBagConstraints4);
        jButton4.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewXYTech.png")));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.viewAxis(new SbVec3f(0.0f, 0.0f, -1.0f), new SbVec3f(0.0f, 1.0f, 0.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        JButton jButton5 = new JButton("");
        jButton5.setContentAreaFilled(false);
        jButton5.setBorderPainted(false);
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        jButton5.setToolTipText("Restore Camera");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 4;
        jPanel.add((Component)jButton5, gridBagConstraints5);
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerHome.png")));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.restoreCamera();
            }
        });
        JButton jButton6 = new JButton("");
        jButton6.setContentAreaFilled(false);
        jButton6.setBorderPainted(false);
        jButton6.setMargin(new Insets(0, 0, 0, 0));
        jButton6.setToolTipText("Save Camera");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 5;
        jPanel.add((Component)jButton6, gridBagConstraints6);
        jButton6.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerSetHome.png")));
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.saveCamera();
            }
        });
        JButton jButton7 = new JButton("");
        jButton7.setContentAreaFilled(false);
        jButton7.setBorderPainted(false);
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.setCameraType(SceneInteractor.CameraMode.ORTHOGRAPHIC);
                PreferencesDialog.getInstance().enableStereoPreferences(false);
            }
        });
        jButton7.setMargin(new Insets(0, 0, 0, 0));
        jButton7.setToolTipText("Switch to orthographic camera");
        jButton7.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerOrtho.png")));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 6;
        jPanel.add((Component)jButton7, gridBagConstraints7);
        JButton jButton8 = new JButton("");
        jButton8.setContentAreaFilled(false);
        jButton8.setBorderPainted(false);
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.m_renderArea.setCameraType(SceneInteractor.CameraMode.PERSPECTIVE);
                if (ViewerExaminer.this.m_renderArea.isStereoSupported() && ViewerExaminer.this.m_renderArea.isRawStereoAvailable()) {
                    PreferencesDialog.getInstance().enableStereoPreferences(true);
                }
            }
        });
        jButton8.setMargin(new Insets(0, 0, 0, 0));
        jButton8.setToolTipText("Switch to perspective camera");
        jButton8.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerPerspective.png")));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 7;
        jPanel.add((Component)jButton8, gridBagConstraints8);
        this.m_seekButton = new JToggleButton("", false);
        this.m_seekButton.setContentAreaFilled(false);
        this.m_seekButton.setBorderPainted(false);
        this.m_seekButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_seekButton.setToolTipText("Seek");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 8;
        jPanel.add((Component)this.m_seekButton, gridBagConstraints9);
        this.m_seekButton.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerSeek.png")));
        this.m_seekButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ViewerExaminer.this.m_renderArea.setSeekMode(itemEvent.getStateChange() == 1);
            }
        });
        JButton jButton9 = new JButton("");
        jButton9.setContentAreaFilled(false);
        jButton9.setBorderPainted(false);
        jButton9.setMargin(new Insets(0, 0, 0, 0));
        jButton9.setToolTipText("Preferences...");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.anchor = 15;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 9;
        jPanel.add((Component)jButton9, gridBagConstraints10);
        jButton9.setIcon(new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/preferences.png")));
        jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerExaminer.this.openPreferences();
            }
        });
        return jPanel;
    }

    private void openPreferences() {
        PreferencesDialog preferencesDialog = PreferencesDialog.getInstance();
        if (!this.m_renderArea.isStereoSupported() || !this.m_renderArea.isRawStereoAvailable()) {
            PreferencesDialog.getInstance().enableStereoPreferences(false);
        } else if (preferencesDialog.getStereoListener() == null) {
            preferencesDialog.setStereoListener(new PreferencesDialog.StereoListener(){

                @Override
                public void offsetValueChanged(float f) {
                    ViewerExaminer.this.m_renderArea.setStereoCameraOffset(f);
                }

                @Override
                public void balanceValueChanged(float f) {
                    ViewerExaminer.this.m_renderArea.setStereoCameraBalance(f);
                }

                @Override
                public void activateRawStereo(boolean bl) {
                    try {
                        ViewerExaminer.this.m_renderArea.activateStereo(bl);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        unsupportedOperationException.printStackTrace();
                    }
                }
            });
        }
        if (preferencesDialog.getGeneralPreferencesListener() == null) {
            preferencesDialog.setNavigationMode(this.m_renderArea.getNavigationMode());
            preferencesDialog.setClippingPlanesAdjustMode(this.m_renderArea.getClippingPlanesAdjustMode().toString());
            preferencesDialog.setGeneralPreferencesListener(new PreferencesDialog.GeneralPreferencesListener(){

                @Override
                public void navigationModeChanged(SceneExaminer.NavigationMode navigationMode) {
                    ViewerExaminer.this.m_renderArea.setNavigationMode(navigationMode);
                }

                @Override
                public void clippingModeChanged(String string) {
                    ViewerExaminer.this.m_renderArea.setClippingPlanesAdjustMode(IRenderAreaInteractive.ClippingPlanesAdjustMode.valueOf(string));
                }
            });
        }
        preferencesDialog.setVisible(true);
    }
}

