/* !!GLSL */

//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

varying vec4 eposition;
varying vec3 normal;
varying vec3 diffuseColor;
varying vec3 specularColor;
varying vec3 emissiveColor;
varying vec3 ambientColor;
varying float shininess;

void main()
{
  // Position in clip space
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();

  // Position in eye space
  eposition = OivModelViewMatrix() * OivVertexPosition();

  // Normal in eye space
  normal = OivNormalMatrix() * OivVertexNormal();

  // Retrieves diffuse, specular, emissive, and ambient color from the OpenGL state.
  diffuseColor  = vec3(OivFrontMaterialDiffuse());
  specularColor = vec3(OivFrontMaterialSpecular());
  emissiveColor = vec3(OivFrontMaterialEmissive());
  ambientColor  = vec3(OivFrontMaterialAmbient());
  shininess     = OivFrontMaterialShininess();
}
