package inventor.advanced.MultiTexturing;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;

public class UserInterface {
  private JPanel    m_mainPanel;
  private JPanel    m_leftPanel;
  private Main       m_ivPanel;
  private JComboBox<String> m_comboBox;

  public UserInterface(Main iv_panel) {
    m_ivPanel = iv_panel;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public JPanel getMainPanel() {
    return m_mainPanel;
  }

  private void jbInit() throws Exception {
    JCheckBox jCheckRotor = new JCheckBox();
    jCheckRotor.addItemListener(new jCheckRotorListener());
    jCheckRotor.setEnabled(true);
    jCheckRotor.setToolTipText("the spot can turn around the ligthed shapes");
    jCheckRotor.setVerifyInputWhenFocusTarget(true);
    jCheckRotor.setSelected(true);
    jCheckRotor.setText("Spot animation");

    JCheckBox jCheckTextureBlinker = new JCheckBox();
    jCheckTextureBlinker.setToolTipText(
        "change the projected texture at regular interval");
    jCheckTextureBlinker.setSelected(true);
    jCheckTextureBlinker.setText("Anim texture");
    jCheckTextureBlinker.addItemListener(new jCheckTextureBlinkerListener());

    m_comboBox = new JComboBox<String>(Main.ProjectedTextures);
    m_comboBox.insertItemAt("None", 0);
    m_comboBox.setEnabled(false);
    m_comboBox.setSelectedIndex(0);
    m_comboBox.addActionListener(new jChooseTextureListener());

    TitledBorder titledBorder = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED,
        Color.white, new Color(148, 145, 140)), "Projected texture");

    JPanel jProjectedTexturePanel = new JPanel();
    jProjectedTexturePanel.setBorder(titledBorder);
    jProjectedTexturePanel.add(jCheckTextureBlinker);
    jProjectedTexturePanel.add(m_comboBox);

    m_leftPanel = new JPanel();
    m_leftPanel.add(jCheckRotor);
    m_leftPanel.add(jProjectedTexturePanel);

    m_mainPanel = new JPanel();
    m_mainPanel.add(m_leftPanel);

    SpringLayout left_layout = new SpringLayout();
    left_layout.putConstraint(SpringLayout.NORTH, jCheckRotor, 20,
                              SpringLayout.NORTH, jCheckRotor.getParent());
    left_layout.putConstraint(SpringLayout.WEST, jCheckRotor, 5,
                              SpringLayout.WEST, jCheckRotor.getParent());
    left_layout.putConstraint(SpringLayout.NORTH, jProjectedTexturePanel, 30,
                              SpringLayout.SOUTH, jCheckRotor);
    left_layout.putConstraint(SpringLayout.WEST, jProjectedTexturePanel, 5,
                              SpringLayout.WEST,
                              jProjectedTexturePanel.getParent());
    left_layout.putConstraint(SpringLayout.EAST,
                              jProjectedTexturePanel.getParent(), 5,
                              SpringLayout.EAST, jProjectedTexturePanel);
    left_layout.putConstraint(SpringLayout.SOUTH,
                              jProjectedTexturePanel.getParent(), 5,
                              SpringLayout.SOUTH, jProjectedTexturePanel);

    SpringLayout ptex_layout = new SpringLayout();
    ptex_layout.putConstraint(SpringLayout.NORTH, jCheckTextureBlinker, 5,
                              SpringLayout.NORTH,
                              jCheckTextureBlinker.getParent());
    ptex_layout.putConstraint(SpringLayout.WEST, jCheckTextureBlinker, 5,
                              SpringLayout.WEST, jCheckTextureBlinker.getParent());
    ptex_layout.putConstraint(SpringLayout.NORTH, m_comboBox, 5,
                              SpringLayout.SOUTH, jCheckTextureBlinker);
    ptex_layout.putConstraint(SpringLayout.WEST, m_comboBox, 5,
                              SpringLayout.WEST, m_comboBox.getParent());
    ptex_layout.putConstraint(SpringLayout.EAST, jCheckTextureBlinker.getParent(),5,
                              SpringLayout.EAST, jCheckTextureBlinker);
    ptex_layout.putConstraint(SpringLayout.SOUTH, m_comboBox.getParent(), 5,
                              SpringLayout.SOUTH, m_comboBox);

    m_leftPanel.setLayout(left_layout);
    jProjectedTexturePanel.setLayout(ptex_layout);
  }

  class jCheckRotorListener implements java.awt.event.ItemListener {
    // start/stop the rotation of the spot
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_ivPanel.animSpot(true);
      else
        m_ivPanel.animSpot(false);
    }
  }

  class jCheckTextureBlinkerListener implements java.awt.event.ItemListener {
    // start/stop the automatic changment of the projected texture
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_ivPanel.blinkProjectedTexture(true);
        m_comboBox.setEnabled(false);
      } else {
        m_ivPanel.blinkProjectedTexture(false);
        m_comboBox.setEnabled(true);
      }
    }
  }

  class jChooseTextureListener  implements java.awt.event.ActionListener {
    // choose manually the projected texture
    public void actionPerformed(ActionEvent e) {
      JComboBox<?> cb = (JComboBox<?>)e.getSource();
      m_ivPanel.selectProjectedTexure(cb.getSelectedIndex()-1);
    }

  }

}
