#version 410 compatibility

//!oiv_include <Inventor/oivShaderVariables.h>

uniform int rttSize;

const float PI = 3.14159265358979323846264;
const float SQRT_2 = 1.4142135623730951;

/**
 *  signed distance functions
 */
 
float ring(vec2 P, float size)
{
  float r1 = length(P) - size/2.0;
  float r2 = length(P) - size/4.0;
  return max(r1,-r2);
}

float crosss(vec2 P, float size)
{
  float x = SQRT_2/2.0 * (P.x - P.y);
  float y = SQRT_2/2.0 * (P.x + P.y);
  float r1 = max(abs(x - size/3.0), abs(x + size/3.0));
  float r2 = max(abs(y - size/3.0), abs(y + size/3.0));
  float r3 = max(abs(x), abs(y));
  return max(min(r1,r2),r3) - size/2.0;
}

float diamond(vec2 P, float size)
{
  float x = SQRT_2/2.0 * (P.x - P.y);
  float y = SQRT_2/2.0 * (P.x + P.y);
  return max(abs(x), abs(y)) - size/(2.0*SQRT_2);
}

float marker(vec2 P, float size)
{
  float x = SQRT_2/2.0 * (P.x - P.y);
  float y = SQRT_2/2.0 * (P.x + P.y);
  float r1 = max(abs(x),abs(y))-size/3.5;
  float r2 = length(P - SQRT_2/2.0*vec2(+1.0,-1.0)*size/3.5) - size/3.5;
  float r3 = length(P - SQRT_2/2.0*vec2(-1.0,-1.0)*size/3.5) - size/3.5;
  return min(min(r1,r2),r3);
}

float club(vec2 P, float size)
{
  // clover (3 discs)
  const float t1 = -PI/2.0;
  const vec2  c1 = 0.225*vec2(cos(t1),sin(t1));
  const float t2 = t1+2*PI/3.0;
  const vec2  c2 = 0.225*vec2(cos(t2),sin(t2));
  const float t3 = t2+2*PI/3.0;
  const vec2  c3 = 0.225*vec2(cos(t3),sin(t3));
  float r1 = length( P - c1*size) - size/4.25;
  float r2 = length( P - c2*size) - size/4.25;
  float r3 = length( P - c3*size) - size/4.25;
  float r4 =  min(min(r1,r2),r3);

  // Root (2 circles and 2 planes)
  const vec2 c4 = vec2(+0.65, 0.125);
  const vec2 c5 = vec2(-0.65, 0.125);
  float r5 = length(P-c4*size) - size/1.6;
  float r6 = length(P-c5*size) - size/1.6;
  float r7 = P.y - 0.5*size;
  float r8 = 0.2*size - P.y;
  float r9 = max(-min(r5,r6), max(r7,r8));

  return min(r4,r9);
}

float spade(vec2 P, float size)
{
  // Reversed heart (diamond + 2 circles)
  float s= size * 0.85 / 3.5;
  float x = SQRT_2/2.0 * (P.x + P.y) + 0.4*s;
  float y = SQRT_2/2.0 * (P.x - P.y) - 0.4*s;
  float r1 = max(abs(x),abs(y)) - s;
  float r2 = length(P - SQRT_2/2.0*vec2(+1.0,+0.2)*s) - s;
  float r3 = length(P - SQRT_2/2.0*vec2(-1.0,+0.2)*s) - s;
  float r4 =  min(min(r1,r2),r3);

  // Root (2 circles and 2 planes)
  const vec2 c1 = vec2(+0.65, 0.125);
  const vec2 c2 = vec2(-0.65, 0.125);
  float r5 = length(P-c1*size) - size/1.6;
  float r6 = length(P-c2*size) - size/1.6;
  float r7 = P.y - 0.5*size;
  float r8 = 0.1*size - P.y;
  float r9 = max(-min(r5,r6), max(r7,r8));

  return min(r4,r9);
}

float distanceFunction(int target, vec2 p, float size)
{
  if ( target == 0 )
    return ring(p, size);
  else if ( target == 1 )
    return crosss(p, size);
  else if ( target == 2 )    
    return diamond(p, size);
  else if ( target == 3 )
    return marker(p, size);
  else if ( target == 4 )
    return club(p, size);
  else if ( target == 5 )
    return spade(p, size);

  return ring(p, size);
}


/**
 *  Write data to targets
 */
void
main ()
{
  vec2 p = 2.0*(gl_FragCoord.xy / rttSize) - 1.0;
  
  vec3 c1 = mix(vec3(0.8, 0.2, 0.2), vec3(0.2, 0.2, 0.8), p.x*0.5 + 0.5);
  vec3 c2 = mix(vec3(0.5, 0.5, 0.5), vec3(0.2, 0.8, 0.2), p.x*0.5 + 0.5);
  vec3 c3 = mix(c1, c2, 0.5*p.y + 0.5);
  
  for ( int i = 0; i < 6; ++i )
  {
    float dist = distanceFunction(i, p, 1.0);
    OivFragmentOutput(i, vec4((dist<0.0)? 1.0 - c3 : c3, 1.0));
  }
}
