package inventor.advanced;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoOutput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.misc.callbacks.SoWWWInlineFetchURLCB;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoWWWInline;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;


abstract public class Simplify extends Example {

  static final public Color UIBackgroundColor = new Color(148F/255F,174F/255F,211F/255F);
  static final public Color UIForegroundColor = Color.blue;
  static protected float levels[] = {1.0f, 0.6f , 0.30f, 0.1f};
  private IViewerExaminer myViewer;
  private Checkbox checkBoxLevel[];
  private FileDialog fileDialog;
  private SoSeparator root;

  protected void saveToFile(SoNode root) {
    System.err.println("storing the simplified scene graph in simplified.iv...\n");
    SoOutput output = new SoOutput();
    output.openFile("simplified.iv");
    SoWriteAction wa = new SoWriteAction(output);
    wa.apply(root);
    output.closeFile();
  }

  public void start(String fileName) {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    root = new SoSeparator();

    SoWWWInline.setFetchURLCallBack(new FetchUrlCB(), null);

    if (fileName == null)
      openFile("$OIVJHOME/data/models/duck.iv");
    else
      openFile(fileName);

    System.err.println("displaying the simplified scene graph...");
    // Open a viewer for the simplified scene:

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    Frame f = new Frame ();
    fileDialog = new FileDialog(f, " Load an iv file ",FileDialog.LOAD);
    fileDialog.setDirectory(SoPreferences.getValue("OIVJHOME") + File.separator + "data" + File.separator + "models");
    fileDialog.setMode(FileDialog.LOAD);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(makeUserInterface(), BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private void openFile(String fileName) {
    System.err.println("reading " + fileName + "...");
    SoInput input = new SoInput();
    input.openFile(fileName);
    readFile(input);
  }

  private void readFile(SoInput input) {
    SoSeparator scene_graph = SoDB.readAll(input);

    if (root.getNumChildren() == 0)
      root.addChild(getSimplifiedSceneGraph(scene_graph));
    else
      root.replaceChild(0,getSimplifiedSceneGraph(scene_graph));
  }

  abstract protected SoGroup getSimplifiedSceneGraph(SoGroup scene_graph);

  Panel makeUserInterface() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    constraint.anchor = GridBagConstraints.WEST;
    constraint.insets.bottom = 10;
    constraint.insets.top = 10;
    constraint.insets.left = 10;
    constraint.insets.right = 10;
    constraint.gridwidth = GridBagConstraints.REMAINDER;

    Panel leftPanel = new Panel(gridbag) {
      @Override
      public void paint(Graphics g) {
	Dimension d = getSize() ;
	g.setColor(UIForegroundColor) ;
	int margin = 1;
	g.drawRect(margin,margin, d.width-2*margin, d.height-2*margin);
      }
    };
    leftPanel.setBackground(UIBackgroundColor);

    Label labelLevel = new Label("Levels of simplification");
    labelLevel.setForeground(UIForegroundColor);
    gridbag.setConstraints(labelLevel,constraint);
    leftPanel.add(labelLevel);

    LevelListener level_listener = new LevelListener();

    CheckboxGroup cbg = new CheckboxGroup();
    checkBoxLevel = new Checkbox[levels.length];
    for (int i=0; i<levels.length; i++) {
      checkBoxLevel[i] = new Checkbox(Float.toString(levels[i]), cbg, false);
      checkBoxLevel[i].addItemListener(level_listener);
      leftPanel.add(checkBoxLevel[i]);
      gridbag.setConstraints(checkBoxLevel[i],constraint);
    }
    Checkbox checkBoxDist = new Checkbox("Depends on distance", cbg, true);
    checkBoxDist.addItemListener(new DistanceListener());
    leftPanel.add(checkBoxDist);
    gridbag.setConstraints(checkBoxDist,constraint);

    Button button = new Button("new file");
    gridbag.setConstraints(button,constraint);
    leftPanel.add(button);
    button.addActionListener(new ActionOnMyButton());

    Label emptyLabel = new Label();
    constraint.weighty = 1;
    gridbag.setConstraints(emptyLabel,constraint);
    leftPanel.add(emptyLabel);

    return leftPanel;
  }

  private URL getURL(String fileName) {
    URL url = null;
    try {
      url = new URL("file:"+(new File(fileName)).getAbsolutePath()) ;
    }
    catch (MalformedURLException exc) {
      System.err.println(exc + " : (" + url + ") " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e) {
      System.err.println(e + " : cant load File "+ fileName);
      url = null;
    }
    return url;
  }

  class LevelListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
    }
  }


  class DistanceListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
    }
  }


  class FetchUrlCB extends SoWWWInlineFetchURLCB {
    @Override
    public void  invoke(String url_name, SoWWWInline node) {
      // Open the input file
      SoInput input = new SoInput();

      URL url = getURL(url_name);
      if (url == null) return;

      System.err.println("opening url " + url_name );
      input.openURL(url);

      // Read the whole file into the database
      SoSeparator myGraph = SoDB.readAll(input);
      if (myGraph == null) {
	System.err.println("Problem reading file");
	return ;
      }
      myGraph.renderCulling.setValue(SoSeparator.Cachings.ON);
      node.setChildData(myGraph);

      input.closeFile();

    }
  }

  class ActionOnMyButton implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
      fileDialog.setVisible(true);
      String file_name = fileDialog.getFile();
      if (file_name != null && file_name.endsWith(".iv")) {
	String myFile = fileDialog.getDirectory() + file_name;
	openFile(myFile);
	myViewer.viewAll();
      }
    }
  }
}

