package inventor.advanced.physicalMaterial;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JPanel;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.nodes.SoFile;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoPhysicalMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.inventor.viewercomponents.nodes.SceneOrbiter;
import com.openinventor.inventor.viewercomponents.nodes.SoViewingCube;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * Demonstrates how to use the SoPhysicalMaterial node.
 */
public class Main extends Example
{
  private IRenderAreaInteractive m_viewer;

  private SoPhysicalMaterial m_material;

  private SliderPanel m_specularSliderPanel;
  private SliderPanel m_roughnessSliderPanel;
  private SliderPanel m_metallicSliderPanel;

  @Override
  public void start()
  {
    setLayout(new BorderLayout());

    add(buildOptionsPanel(), BorderLayout.PAGE_START);

    m_viewer = ViewerComponentsFactory.createRenderAreaOrbiter();
    m_viewer.setSceneGraph(buildSceneGraph());
    m_viewer.viewAll(new SbViewportRegion());

    SoViewingCube vcube = ((SceneOrbiter) m_viewer.getSceneInteractor()).getViewingCube();
    vcube.facePosX.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/xpos.png");
    vcube.faceNegX.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/xneg.png");
    vcube.facePosY.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/ypos.png");
    vcube.faceNegY.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/yneg.png");
    vcube.facePosZ.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/zpos.png");
    vcube.faceNegZ.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/xyz/zneg.png");
    vcube.edgeSize.setValue(0.5f);
    vcube.edgeStyle.setValue(SoViewingCube.EdgeStyles.CORNER);

    m_viewer.setAntialiasingMode(AntialiasingModes.SMAA);
    m_viewer.setAntialiasingQuality(1.0f);

    final Component component = m_viewer.getComponent();
    component.setSize(new Dimension(1280, 720));
    add(component, BorderLayout.CENTER);
  }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    SoSeparator root = new SoSeparator();

    SoGradientBackground gradientBackground = new SoGradientBackground();
    gradientBackground.color0.setValue(new SbColor(1.0f, 1.0f, 1.0f));
    gradientBackground.color1.connectFrom(gradientBackground.color0);
    root.addChild(gradientBackground);

    SoLightModel lightModel = new SoLightModel();
    lightModel.setOverride(true);
    lightModel.model.setValue(SoLightModel.Models.PHYSICALLY_BASED);
    root.addChild(lightModel);

    m_material = new SoPhysicalMaterial();
    m_material.baseColor.setValue(new SbColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
    m_material.specular.setValue(1.0f);
    m_material.roughness.setValue(0.5f);
    root.addChild(m_material);

    SoFile modelFile = new SoFile();
    modelFile.name.set("$OIVJHOME/data/examples/Models/StanfordBunny.ivz");
    root.addChild(modelFile);

    return root;
  }

  private JPanel buildOptionsPanel()
  {
    JPanel uiPanel = new JPanel();
    uiPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));

    m_specularSliderPanel = new SliderPanel(0.0f, 1.0f, 1.0f, 2, false);
    ((FlowLayout) m_specularSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    m_specularSliderPanel.addInfoText("Specular Coefficient");
    m_specularSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_material.specular.setValue(value);
      }
    });
    uiPanel.add(m_specularSliderPanel);

    m_roughnessSliderPanel = new SliderPanel(0.0f, 1.0f, 0.5f, 2, false);
    ((FlowLayout) m_roughnessSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    m_roughnessSliderPanel.addInfoText("Roughness Coefficient");
    m_roughnessSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_material.roughness.setValue(value);
      }
    });
    uiPanel.add(m_roughnessSliderPanel);

    m_metallicSliderPanel = new SliderPanel(0.0f, 1.0f, 0.0f, 2, false);
    ((FlowLayout) m_metallicSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    m_metallicSliderPanel.addInfoText("Metallic Coefficient");
    m_metallicSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_material.metallic.setValue(value);
      }
    });
    uiPanel.add(m_metallicSliderPanel);

    return uiPanel;
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Physical Material");
  }
}
