package inventor.advanced.reorganizeSimplify;

import com.openinventor.inventor.actions.SoReorganizeAction;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.simplifier.SoDecimator;

import inventor.advanced.Simplify;


public class Main extends Simplify {

  private static String filename = null;

  public static void main(String argv[]) {
    if (argv.length != 1)
      filename = "$OIVJHOME/data/models/duck.iv";
    else
      filename = argv[0];

    Main example = new Main();
    example.demoMain("Reorganize Simplification");
  }

  @Override
  public void start()
  {
    start(filename);
  }

  @Override
  protected SoGroup getSimplifiedSceneGraph(SoGroup scene_graph) {
    // the simplification action: uses the global simplification.
    SoReorganizeAction simplify = new SoReorganizeAction(new SoDecimator());

    simplify.setSimplificationLevels(levels);
    simplify.setSizeFactor(4.f);
    simplify.setUrlName("new");
    simplify.setMinTriangles(4);

    System.err.println("simplification started...");
    simplify.apply(scene_graph);
    System.err.println("simplification done");

    //   saveToFile(simplify.getSimplifiedSceneGraph());
    return simplify.getSimplifiedSceneGraph();
  }
}
