package inventor.advanced.shaders.simplePassthrough;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * This simple example shows how to use the Shader API.
 *
 * All shader stages are present in order to show how the Shader API can be used
 * for each of them.
 *
 * The Tessellation and Geometry shader stages are just passthrough shaders.
 * Their only use is to show some of the Shader API that can be used in these
 * stages.
 *
 * The example shows a quad whose vertex colors are mixed with a 2D texture.
 */
public class Main extends Example
{
  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.setSceneGraph(createSceneGraph());
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(1024, 768));

    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private SoSeparator createSceneGraph()
  {
    String pkgName = this.getClass().getPackage().getName();
    pkgName = pkgName.replace('.', File.separatorChar);
    String filename = SoPreferences.getValue("OIVJHOME") + File.separator + "examples" + File.separator + pkgName
        + File.separator + "simplePassthrough.iv";

    // Open the input file
    SoInput input = new SoInput();
    if ( !input.openFile(filename) )
    {
      System.err.println("Cannot open file " + filename);
      return null;
    }

    // Read the whole file into the database
    SoSeparator sceneGraph = SoDB.readAll(input);
    if ( sceneGraph == null )
    {
      System.err.println("Problem reading file " + filename);
      return null;
    }

    input.closeFile();
    return sceneGraph;
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Simple Passthrough Shader");
  }
}
