package inventor.advanced.transformManip;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JPanel;

import com.openinventor.inventor.manips.SoCenterballManip;
import com.openinventor.inventor.manips.SoHandleBoxManip;
import com.openinventor.inventor.manips.SoJackManip;
import com.openinventor.inventor.manips.SoTabBoxManip;
import com.openinventor.inventor.manips.SoTrackballManip;
import com.openinventor.inventor.manips.SoTransformBoxManip;
import com.openinventor.inventor.manips.SoTransformerManip;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * This applet shows the effect of the manipulators derived from SoTransformManip
  *
  * @author Jean-Michel Godinaud
  */

public class Main extends Example {

  private IViewerExaminer myViewer;
  private SoSwitch switch_transform;

  public static void main(String [] argv) {
    Main example = new Main();
    example.demoMain("Transform Manip");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoTranslation translate = new SoTranslation();
    translate.translation.setValue(0,0,5);

    switch_transform = new SoSwitch();
    switch_transform.addChild(new SoCenterballManip());
    switch_transform.addChild(new SoHandleBoxManip());
    switch_transform.addChild(new SoJackManip());
    switch_transform.addChild(new SoTabBoxManip());
    switch_transform.addChild(new SoTrackballManip());
    switch_transform.addChild(new SoTransformBoxManip());
    switch_transform.addChild(new SoTransformerManip());
    switch_transform.whichChild.setValue(0);

    SoMaterial myMaterial = new SoMaterial() ;
    myMaterial.diffuseColor.setValue(1, 0, 0) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(new SoCube());
      root.addChild(translate);
      root.addChild(switch_transform);
      root.addChild(myMaterial);
      root.addChild(new SoCone());
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    Label labelManipulator = new Label("Manipulator");
    CheckboxGroup cbgManipulator = new CheckboxGroup();
    Checkbox boxCenterballManip = new Checkbox("Centerball", cbgManipulator, true);
    Checkbox boxHandleBoxManip = new Checkbox("HandleBox", cbgManipulator, false);
    Checkbox boxJackManip = new Checkbox("Jack", cbgManipulator, false);
    Checkbox boxTabBoxManip = new Checkbox("TabBox", cbgManipulator, false);
    Checkbox boxTrackballManip = new Checkbox("Trackball", cbgManipulator, false);
    Checkbox boxTransformBoxManip = new Checkbox("TransformBox", cbgManipulator, false);
    Checkbox boxTransformerManip = new Checkbox("Transformer", cbgManipulator, false);
    // listener
    boxCenterballManip.addItemListener(new ListenerCenterball());
    boxHandleBoxManip.addItemListener(new ListenerHandleBox());
    boxJackManip.addItemListener(new ListenerJack());
    boxTabBoxManip.addItemListener(new ListenerTabBox());
    boxTrackballManip.addItemListener(new ListenerTrackball());
    boxTransformBoxManip.addItemListener(new ListenerTransformBox());
    boxTransformerManip.addItemListener(new ListenerTransformer());

    JPanel leftPanel = new JPanel(new GridLayout(0,1));
    leftPanel.add(labelManipulator);
    leftPanel.add(boxCenterballManip);
    leftPanel.add(boxHandleBoxManip);
    leftPanel.add(boxJackManip);
    leftPanel.add(boxTabBoxManip);
    leftPanel.add(boxTrackballManip);
    leftPanel.add(boxTransformBoxManip);
    leftPanel.add(boxTransformerManip);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(leftPanel, BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    switch_transform = null;
    myViewer.dispose();
  }

  class ListenerCenterball implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(0);
    }
  }

  class ListenerHandleBox implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(1);
    }
  }

  class ListenerJack implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(2);
    }
  }

  class ListenerTabBox implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(3);
    }
  }

  class ListenerTrackball implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(4);
    }
  }

  class ListenerTransformBox implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(5);
    }
  }

  class ListenerTransformer implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      switch_transform.whichChild.setValue(6);
    }
  }

}
