package inventor.mentor.alarmSensor;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.sensors.SoAlarmSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  AlarmSensor example program;
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String [] argv) {
    Main example = new Main();
    example.demoMain("Alarm Sensor");
  }

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoTransform flagXform = new SoTransform() ;

    // Create an alarm that will call the flag-raising task:
    SoAlarmSensor myAlarm = new SoAlarmSensor(new RaiseFlagTask(flagXform)) ;
    myAlarm.setTimeFromNow(new SbTime(4.0)); // 4 seconds
    myAlarm.schedule() ;

    SoCone myCone = new SoCone() ;
    myCone.bottomRadius.setValue(0.1F) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(flagXform);
      root.addChild(myCone);
    }

    // Put our scene in myViewer, change the title
    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  class RaiseFlagTask implements Runnable {
    SoTransform flagAngleXform;
    RaiseFlagTask(SoTransform flagAngleXform) {
      this.flagAngleXform = flagAngleXform;
    }
    @Override
    public void run() {
      // Rotate flag by 90 degrees about the Z axis:
      flagAngleXform.rotation.setValue(new SbVec3f(0,0,1), (float)Math.PI/2F) ;
    }
  }
}
