package inventor.mentor.calculator;
import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.engines.SoCalculator;
import com.openinventor.inventor.engines.SoTimeCounter;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Calculator");
   }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // This transformation is modified to rotate the cone
    SoRotationXYZ myRotXYZ = new SoRotationXYZ();
    myRotXYZ.axis.setValue(SoRotationXYZ.AxisType.X);
    myRotXYZ.angle.setValue((float)(Math.PI/7d));

    SoInput inputFile = new SoInput();
    inputFile.openFile("$OIVJHOME/data/models/flowerPath.iv");
    SoGroup flowerPath = SoDB.readAll(inputFile);

    // Flower group
    SoSeparator flowerGroup = new SoSeparator();
    inputFile.openFile("$OIVJHOME/data/models/flower.iv");
    SoSeparator flower = SoDB.readAll(inputFile);

    // Set up the flower transformations
    SoTranslation danceTranslation = new SoTranslation();
    SoTransform initialTransform = new SoTransform();
    flowerGroup.addChild(danceTranslation);
    initialTransform.scaleFactor.setValue(10.0f, 10.0f, 10.0f);
    initialTransform.translation.setValue(0.0f, 0.0f, 5.0f);
    flowerGroup.addChild(initialTransform);
    flowerGroup.addChild(flower);

    // Set up an engine to calculate the motion path:
    // r = 5*cos(5*theta); x = r*cos(theta); z = r*sin(theta)
    // Theta is incremented using a time counter engine,
    // and converted to radians using an expression in
    // the calculator engine.
    SoCalculator calcXZ = new SoCalculator();
    SoTimeCounter thetaCounter = new SoTimeCounter();

    thetaCounter.max.setValue((short)360);
    thetaCounter.step.setValue((short)4);
    thetaCounter.frequency.setValue(0.075f);

    calcXZ.a.connectFrom(thetaCounter.output);
    calcXZ.expression.set1Value(0, "ta=a*M_PI/180"); // theta
    calcXZ.expression.set1Value(1, "tb=5*cos(5*ta)"); // r
    calcXZ.expression.set1Value(2, "td=tb*cos(ta)"); // x
    calcXZ.expression.set1Value(3, "te=tb*sin(ta)"); // z
    calcXZ.expression.set1Value(4, "oA=vec3f(td,0,te)");
    danceTranslation.translation.connectFrom(calcXZ.oA);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(myRotXYZ);
      root.addChild(flowerPath);
      root.addChild(flowerGroup);
    }
    myViewer.setSceneGraph(root);

    SoCamera camera = myViewer.getRenderArea().getSceneInteractor().getCamera();
    camera.position.setValue(-0.5f, -3.0f, 19.0f);
    camera.nearDistance.setValue(10.0f);
    camera.farDistance.setValue(26.0f);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}

