package inventor.mentor.cameras;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoBlinker;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  mentor.Camera example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */


public class Main extends Example {

  String string = "" +
  "#Inventor V2.1 ascii\n" +
  "" +
  "Separator {" +
  "   Normal {" +
  "      vector [" +
  "         0.553341 0 0.832955, 0.832955 0.553341 0," +
  "         0.832955 -0.553341 0, 0 -0.832955 0.553341," +
  "         -0.553341 0 0.832955, 0 0.832955 0.553341," +
  "         0 0.832955 -0.553341, -0.832955 0.553341 0," +
  "         -0.832955 -0.553341 0, 0 -0.832955 -0.553341," +
  "         0.553341 0 -0.832955, -0.553341 0 -0.832955," +
  "      ]" +
  "   }" +
  "   NormalBinding { value PER_FACE }" +
  "   Material {" +
  "      diffuseColor [" +
  "         1  0  0,   0 1  0,   0  0 1,   0  1  1," +
  "         1  0  1,  .5 1  0,  .5  0 1,  .5  1  1," +
  "         1 .3 .7,  .3 1 .7,  .3 .7 1,  .5 .5 .8" +
  "      ]" +
  "   }" +
  "   MaterialBinding { value PER_FACE }" +
  "   Coordinate3 {" +
  "      point [" +
  "         1.7265 0 0.618,    1 1 1," +
  "         0 0.618 1.7265,    0 -0.618 1.7265," +
  "         1 -1 1,    -1 -1 1," +
  "         -0.618 -1.7265 0,    0.618 -1.7265 0," +
  "         1 -1 -1,    1.7265 0 -0.618," +
  "         1 1 -1,    0.618 1.7265 0," +
  "         -0.618 1.7265 0,    -1 1 1," +
  "         -1.7265 0 0.618,    -1.7265 0 -0.618," +
  "         -1 -1 -1,    0 -0.618 -1.7265," +
  "         0 0.618 -1.7265,    -1 1 -1" +
  "      ]" +
  "   }" +
  "   IndexedFaceSet {" +
  "      coordIndex [" +
  "         1, 2, 3, 4, 0, -1,  0, 9, 10, 11, 1, -1," +
  "         4, 7, 8, 9, 0, -1,  3, 5, 6, 7, 4, -1," +
  "         2, 13, 14, 5, 3, -1,  1, 11, 12, 13, 2, -1," +
  "         10, 18, 19, 12, 11, -1,  19, 15, 14, 13, 12, -1," +
  "         15, 16, 6, 5, 14, -1,  8, 7, 6, 16, 17, -1," +
  "         9, 8, 17, 18, 10, -1,  18, 17, 16, 15, 19, -1," +
  "      ]" +
  "   }" +
  "}";

  private IRenderAreaInteractive myRenderArea;

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaInteractive();

    // Create a blinker node and put it in the scene. A blinker
    // switches between its children at timed intervals.
    SoBlinker myBlinker = new SoBlinker();

    // Create three cameras. Their positions will be set later.
    // This is because the viewAll method depends on the size
    // of the render area, which has not been created yet.
    SoOrthographicCamera orthoViewAll = new SoOrthographicCamera();
    SoPerspectiveCamera perspViewAll = new SoPerspectiveCamera();
    SoPerspectiveCamera perspOffCenter = new SoPerspectiveCamera();
    myBlinker.addChild(orthoViewAll);
    myBlinker.addChild(perspViewAll);
    myBlinker.addChild(perspOffCenter);

    // Read the object from a String
    SoInput myInput = new SoInput();
    myInput.setBuffer(string.getBytes());
    SoSeparator fileContents = SoDB.readAll(myInput);

    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(0.8F, 0.23F, 0.03F);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(myBlinker);
      // Create a light
      root.addChild(new SoDirectionalLight());
      root.addChild(myMaterial);
      root.addChild(fileContents);
    }

    final Component canvas = myRenderArea.getComponent();

    // Establish camera positions.
    // First do a viewAll on all three cameras.
    // Then modify the position of the off-center camera.
    SbViewportRegion myRegion = new SbViewportRegion(canvas.getSize());
    orthoViewAll.viewAll(root, myRegion);
    perspViewAll.viewAll(root, myRegion);
    perspOffCenter.viewAll(root, myRegion);
    SbVec3f initialPos = new SbVec3f();
    initialPos = perspOffCenter.position.getValue();
    float vec[];
    vec = initialPos.getValue();
    perspOffCenter.position.setValue(vec[0]+vec[0]/2, vec[1]+vec[1]/2, vec[2]+vec[2]/4);


    myRenderArea.setSceneGraph(root);

    canvas.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main (String [] argv) {
    Main example = new Main();
    example.demoMain("Cameras");
  }
}
