package inventor.mentor.engineSpin;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.engines.SoElapsedTime;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * com.openinventor.mentor.EngineSpin example program; draws a spinning red cone in a window.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Engine Spin");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Make a scene containing a red cone
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1.0f,0.0f,0.0f);

    // This transformation is modified to rotate the cone
    SoRotationXYZ myRotXYZ = new SoRotationXYZ();

    // An engine rotates the object. The output of myCounter is the
    // time in seconds since the program started.
    // Connect this output to the angle field of myRotXYZ.
    myRotXYZ.axis.setValue(SoRotationXYZ.AxisType.X);
    SoElapsedTime myCounter = new SoElapsedTime();
    myRotXYZ.angle.connectFrom(myCounter.timeOut);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(myRotXYZ);
      root.addChild(myMaterial);
      root.addChild(new SoCone());
    }

    myViewer.setSceneGraph(root);
    // Make myCamera see everything.
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}

