package inventor.mentor.examiner;
import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;


/**
  *  mentor.Examiner example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Examiner");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator() ;
    root.addChild(new SoCone()) ;

    // Set up viewer
    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
