package inventor.mentor.faceSet;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  This is an example from the Inventor Mentor,
  *  chapter 5, example 1.
  *
  * This example builds an obelisk using the Face Set node.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example {
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  //  Eight polygons. The first four are triangles
  //  The second four are quadrilaterals for the sides.
  static float vertices[][] = {
    { 0, 30, 0}, {-2,27, 2}, { 2,27, 2},            //front tri
    { 0, 30, 0}, {-2,27,-2}, {-2,27, 2},            //left  tri
    { 0, 30, 0}, { 2,27,-2}, {-2,27,-2},            //rear  tri
    { 0, 30, 0}, { 2,27, 2}, { 2,27,-2},            //right tri
    {-2, 27, 2}, {-4,0, 4}, { 4,0, 4}, { 2,27, 2},  //front quad
    {-2, 27,-2}, {-4,0,-4}, {-4,0, 4}, {-2,27, 2},  //left  quad
    { 2, 27,-2}, { 4,0,-4}, {-4,0,-4}, {-2,27,-2},  //rear  quad
    { 2, 27, 2}, { 4,0, 4}, { 4,0,-4}, { 2,27,-2}   //right quad
  };

  // Number of vertices in each polygon:
  static int numvertices[] = {3, 3, 3, 3, 4, 4, 4, 4};

  // Normals for each polygon:
  static float norms[][] = {
    {0F, .555F,  .832F}, {-.832F, .555F, 0F}, //front, left tris
    {0F, .555F, -.832F}, { .832F, .555F, 0F}, //rear, right tris

    {0F, .0739F,  .9973F}, {-.9972F, .0739F, 0F},//front, left quads
    {0F, .0739F, -.9973F}, { .9972F, .0739F, 0F},//rear, right quads
  };

  private IViewerExaminer myViewer;

  SoSeparator makeObeliskFaceSet() {
    SoSeparator obelisk = new SoSeparator();

    // This is the preferred code for Inventor 2.1
    // otherwise, see below the commented block

    // Using the new SoVertexProperty node is more efficient
    SoVertexProperty myVertexProperty = new SoVertexProperty();

    // Define the normals used:
    myVertexProperty.normal.setValues(0, norms) ;
    myVertexProperty.normalBinding.setValue(SoVertexProperty.Bindings.PER_FACE) ;

    // Define material for obelisk
    myVertexProperty.orderedRGBA.setValue(new SbColor(0.4F, 0.4F, 0.4F).getPackedValue());

    // Define coordinates for vertices
    myVertexProperty.vertex.setValues(0, vertices);

    // Define the FaceSet
    SoFaceSet myFaceSet = new SoFaceSet();
    myFaceSet.numVertices.setValues(0, numvertices);

    myFaceSet.vertexProperty.setValue(myVertexProperty);

    obelisk.addChild(myFaceSet);

    /* If you prefer use this style : (not recommended)
       // Define the normals used:
       SoNormal myNormals = new SoNormal();
       myNormals.vector.setValues(0, norms);
       obelisk.addChild(myNormals);
       SoNormalBinding myNormalBinding = new SoNormalBinding();
       myNormalBinding.value.setValue(SoNormalBinding.PER_FACE);
       obelisk.addChild(myNormalBinding);

       // Define material for obelisk
       SoMaterial myMaterial = new SoMaterial();
       myMaterial.diffuseColor.setValue(0.4F, 0.4F, 0.4F);
       obelisk.addChild(myMaterial);

       // Define coordinates for vertices
       SoCoordinate3 myCoords = new SoCoordinate3();
       myCoords.point.setValues(0, vertices);
       obelisk.addChild(myCoords);

       // Define the FaceSet
       SoFaceSet myFaceSet = new SoFaceSet();
       myFaceSet.numVertices.setValues(0, numvertices);
       obelisk.addChild(myFaceSet);
    */

    return obelisk;
  }

  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////


  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();
    root.addChild(makeObeliskFaceSet());

    myViewer.setSceneGraph(root);
    myViewer.viewAll() ;

    final Component component = myViewer.getComponent();
    component.setName("Face Set: Obelisk");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("FaceSet");
  }

}

