package inventor.mentor.indexedFaceSet;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoIndexedFaceSet;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;


/**
  * This is an example from the Inventor Mentor,
  * chapter 5, example 2.
  *
  *  This example creates an IndexedFaceSet. It creates
  *  the first stellation of the dodecahedron.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example {
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  //
  // Positions of all of the vertices:
  //
  static float vertexPositions[][] = {
    { 0.0000F,  1.2142F,  0.7453F},  // top

    { 0.0000F,  1.2142F, -0.7453F},  // points surrounding top
    {-1.2142F,  0.7453F,  0.0000F},
    {-0.7453F,  0.0000F,  1.2142F},
    { 0.7453F,  0.0000F,  1.2142F},
    { 1.2142F,  0.7453F,  0.0000F},

    { 0.0000F, -1.2142F,  0.7453F},  // points surrounding bottom
    {-1.2142F, -0.7453F,  0.0000F},
    {-0.7453F,  0.0000F, -1.2142F},
    { 0.7453F,  0.0000F, -1.2142F},
    { 1.2142F, -0.7453F,  0.0000F},

    { 0.0000F, -1.2142F, -0.7453F}, // bottom
  };

  //
  // Connectivity, information; 12 faces with 5 vertices each },
  // (plus the end-of-face indicator for each face):
  //

  static int indices[] = {
    1,  2,  3,  4, 5, SoIndexedFaceSet.SO_END_FACE_INDEX, // top face

    0,  1,  8,  7, 3, SoIndexedFaceSet.SO_END_FACE_INDEX, // 5 faces about top
    0,  2,  7,  6, 4, SoIndexedFaceSet.SO_END_FACE_INDEX,
    0,  3,  6, 10, 5, SoIndexedFaceSet.SO_END_FACE_INDEX,
    0,  4, 10,  9, 1, SoIndexedFaceSet.SO_END_FACE_INDEX,
    0,  5,  9,  8, 2, SoIndexedFaceSet.SO_END_FACE_INDEX,

    9,  5, 4, 6, 11, SoIndexedFaceSet.SO_END_FACE_INDEX, // 5 faces about bottom
    10,  4, 3, 7, 11, SoIndexedFaceSet.SO_END_FACE_INDEX,
    6,  3, 2, 8, 11, SoIndexedFaceSet.SO_END_FACE_INDEX,
    7,  2, 1, 9, 11, SoIndexedFaceSet.SO_END_FACE_INDEX,
    8,  1, 5,10, 11, SoIndexedFaceSet.SO_END_FACE_INDEX,

    6,  7, 8, 9, 10, SoIndexedFaceSet.SO_END_FACE_INDEX, // bottom face
  };

  // Colors for the 12 faces
  static float colors[][] = {
    {1.0F, .0F, 0F}, { .0F,  .0F, 1.0F}, {0F, .7F,  .7F}, { .0F, 1.0F,  0F},
    { .7F, .7F, 0F}, { .7F,  .0F,  .7F}, {0F, .0F, 1.0F}, { .7F,  .0F, .7F},
    { .7F, .7F, 0F}, { .0F, 1.0F,  .0F}, {0F, .7F,  .7F}, {1.0F,  .0F,  0F}
  };

  private IViewerExaminer myViewer;

  // Routine to create a scene graph representing a dodecahedron
  SoSeparator makeStellatedDodecahedron() {
    SoSeparator result = new SoSeparator();

    // This is the preferred code for Inventor 2.1
    // otherwise, see below the commented block


    // Using the new SoVertexProperty node is more efficient
    SoVertexProperty myVertexProperty = new SoVertexProperty();

    // Define colors for the faces
    for (int i=0 ; i<12 ; i++)
      myVertexProperty.orderedRGBA.set1Value(i, new SbColor(colors[i]).getPackedValue());
    myVertexProperty.materialBinding.setValue(SoVertexProperty.Bindings.PER_FACE);

    // Define coordinates for vertices
    myVertexProperty.vertex.setValues(0, vertexPositions);

    // Define the IndexedFaceSet, with indices into
    // the vertices:
    SoIndexedFaceSet myFaceSet = new SoIndexedFaceSet();
    myFaceSet.coordIndex.setValues(0, indices);

    myFaceSet.vertexProperty.setValue(myVertexProperty);
    result.addChild(myFaceSet);

    /* If you prefer use this style : (not recommended)
       // Define colors for the faces
       SoMaterial myMaterials = new SoMaterial();
       myMaterials.diffuseColor.setValues(0, 12, colors);
       result.addChild(myMaterials);
       SoMaterialBinding myMaterialBinding = new SoMaterialBinding();
       myMaterialBinding.value.setValue(SoMaterialBinding.PER_FACE);
       result.addChild(myMaterialBinding);

       // Define coordinates for vertices
       SoCoordinate3 myCoords = new SoCoordinate3();
       myCoords.point.setValues(0, vertexPositions);
       result.addChild(myCoords);

       // Define the IndexedFaceSet, with indices into
       // the vertices:
       SoIndexedFaceSet myFaceSet = new SoIndexedFaceSet();
       myFaceSet.coordIndex.setValues(0, indices);
       result.addChild(myFaceSet);
    */

    return result;
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = makeStellatedDodecahedron();

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Indexed Face Set: Stellated Dodecahedron");
  }
}

