package inventor.mentor.quadMesh;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoQuadMesh;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  This is an example from the Inventor Mentor,
  *  chapter 5, example 4.
  *
  *  This example creates the St. Louis Arch using a QuadMesh.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  // Positions of all of the vertices:
  static float vertexPositions[][] = {
    // 1st row
    {-13.0F,  0.0F, 1.5F}, {-10.3F, 13.7F, 1.2F}, { -7.6F, 21.7F, 1.0F},
    { -5.0F, 26.1F, 0.8F}, { -2.3F, 28.2F, 0.6F}, { -0.3F, 28.8F, 0.5F},
    {  0.3F, 28.8F, 0.5F}, {  2.3F, 28.2F, 0.6F}, {  5.0F, 26.1F, 0.8F},
    {  7.6F, 21.7F, 1.0F}, { 10.3F, 13.7F, 1.2F}, { 13.0F,  0.0F, 1.5F},
    // 2nd row
    {-10.0F,  0.0F, 1.5F}, { -7.9F, 13.2F, 1.2F}, { -5.8F, 20.8F, 1.0F},
    { -3.8F, 25.0F, 0.8F}, { -1.7F, 27.1F, 0.6F}, { -0.2F, 27.6F, 0.5F},
    {  0.2F, 27.6F, 0.5F}, {  1.7F, 27.1F, 0.6F}, {  3.8F, 25.0F, 0.8F},
    {  5.8F, 20.8F, 1.0F}, {  7.9F, 13.2F, 1.2F}, { 10.0F,  0.0F, 1.5F},
    // 3rd row
    {-10.0F,  0.0F,-1.5F}, { -7.9F, 13.2F,-1.2F}, { -5.8F, 20.8F,-1.0F},
    { -3.8F, 25.0F,-0.8F}, { -1.7F, 27.1F,-0.6F}, { -0.2F, 27.6F,-0.5F},
    {  0.2F, 27.6F,-0.5F}, {  1.7F, 27.1F,-0.6F}, {  3.8F, 25.0F,-0.8F},
    {  5.8F, 20.8F,-1.0F}, {  7.9F, 13.2F,-1.2F}, { 10.0F,  0.0F,-1.5F},
    // 4th row
    {-13.0F,  0.0F,-1.5F}, {-10.3F, 13.7F,-1.2F}, { -7.6F, 21.7F,-1.0F},
    { -5.0F, 26.1F,-0.8F}, { -2.3F, 28.2F,-0.6F}, { -0.3F, 28.8F,-0.5F},
    {  0.3F, 28.8F,-0.5F}, {  2.3F, 28.2F,-0.6F}, {  5.0F, 26.1F,-0.8F},
    {  7.6F, 21.7F,-1.0F}, { 10.3F, 13.7F,-1.2F}, { 13.0F,  0.0F,-1.5F},
    // 5th row
    {-13.0F,  0.0F, 1.5F}, {-10.3F, 13.7F, 1.2F}, { -7.6F, 21.7F, 1.0F},
    { -5.0F, 26.1F, 0.8F}, { -2.3F, 28.2F, 0.6F}, { -0.3F, 28.8F, 0.5F},
    {  0.3F, 28.8F, 0.5F}, {  2.3F, 28.2F, 0.6F}, {  5.0F, 26.1F, 0.8F},
    {  7.6F, 21.7F, 1.0F}, { 10.3F, 13.7F, 1.2F}, { 13.0F,  0.0F, 1.5F}
  };
  private IViewerExaminer myViewer;

  // Routine to create a scene graph representing an arch.
  SoSeparator makeArch() {
    // This is the preferred code for Inventor 2.1
    // otherwise, see below the commented block

    // Using the new SoVertexProperty node is more efficient
    SoVertexProperty myVertexProperty = new SoVertexProperty() ;

    // Define the material
    //    myVertexProperty.orderedRGBA.setValue(new SbColor(.78F, .57F, .11F).getPackedValue());
    int rgb = new SbColor(.78F, .57F, .11F).getPackedValue() ;
    myVertexProperty.orderedRGBA.setValue(rgb);

    // Define coordinates for vertices
    myVertexProperty.vertex.setValues(0, vertexPositions);

    // Define the QuadMesh.
    SoQuadMesh myQuadMesh = new SoQuadMesh() ;
    myQuadMesh.verticesPerRow.setValue(12) ;
    myQuadMesh.verticesPerColumn.setValue(5) ;
    myQuadMesh.vertexProperty.setValue(myVertexProperty) ;

    SoSeparator result = new SoSeparator();
    result.addChild(myQuadMesh);


    /* If you prefer use this style : (not recommended)
       // Define the material
       SoMaterial myMaterial = new SoMaterial();
       myMaterial.diffuseColor.setValue(.78F, .57F, .11F) ;
       result.addChild(myMaterial);

       // Define coordinates for vertices
       SoCoordinate3 myCoords = new SoCoordinate3();
       myCoords.point.setValues(0, vertexPositions);
       result.addChild(myCoords);

       // Define the QuadMesh.
       SoQuadMesh myQuadMesh = new SoQuadMesh();
       myQuadMesh.verticesPerRow.setValue(12) ;

       myQuadMesh.verticesPerColumn.setValue(5) ;
       result.addChild(myQuadMesh);
    */

    return result;
  }

  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////


  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = makeArch();

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setName("Quad Mesh: Arch");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("QuadMesh");
  }
}
