package inventor.mentor.readString;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  mentor.ReadString example program
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */


public class Main extends Example
{

  String string = "" +
  "#Inventor V2.0 ascii\n" +
  "" +
  "Separator {" +
  "   Normal {" +
  "      vector [" +
  "         0.553341 0 0.832955, 0.832955 0.553341 0," +
  "         0.832955 -0.553341 0, 0 -0.832955 0.553341," +
  "         -0.553341 0 0.832955, 0 0.832955 0.553341," +
  "         0 0.832955 -0.553341, -0.832955 0.553341 0," +
  "         -0.832955 -0.553341 0, 0 -0.832955 -0.553341," +
  "         0.553341 0 -0.832955, -0.553341 0 -0.832955," +
  "      ]" +
  "   }" +
  "   NormalBinding { value PER_FACE }" +
  "   Material {" +
  "      diffuseColor [" +
  "         1  0  0,   0 1  0,   0  0 1,   0  1  1," +
  "         1  0  1,  .5 1  0,  .5  0 1,  .5  1  1," +
  "         1 .3 .7,  .3 1 .7,  .3 .7 1,  .5 .5 .8" +
  "      ]" +
  "   }" +
  "   MaterialBinding { value PER_FACE }" +
  "   Coordinate3 {" +
  "      point [" +
  "         1.7265 0 0.618,    1 1 1," +
  "         0 0.618 1.7265,    0 -0.618 1.7265," +
  "         1 -1 1,    -1 -1 1," +
  "         -0.618 -1.7265 0,    0.618 -1.7265 0," +
  "         1 -1 -1,    1.7265 0 -0.618," +
  "         1 1 -1,    0.618 1.7265 0," +
  "         -0.618 1.7265 0,    -1 1 1," +
  "         -1.7265 0 0.618,    -1.7265 0 -0.618," +
  "         -1 -1 -1,    0 -0.618 -1.7265," +
  "         0 0.618 -1.7265,    -1 1 -1" +
  "      ]" +
  "   }" +
  "   IndexedFaceSet {" +
  "      coordIndex [" +
  "         1, 2, 3, 4, 0, -1,  0, 9, 10, 11, 1, -1," +
  "         4, 7, 8, 9, 0, -1,  3, 5, 6, 7, 4, -1," +
  "         2, 13, 14, 5, 3, -1,  1, 11, 12, 13, 2, -1," +
  "         10, 18, 19, 12, 11, -1,  19, 15, 14, 13, 12, -1," +
  "         15, 16, 6, 5, 14, -1,  8, 7, 6, 16, 17, -1," +
  "         9, 8, 17, 18, 10, -1,  18, 17, 16, 15, 19, -1," +
  "      ]" +
  "   }" +
  "}" ;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Read String");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoInput in = new SoInput() ;
    in.setBuffer(string, string.length()) ;

    if (in.isValidBuffer()) {
      SoSeparator root = SoDB.readAll(in) ;
      if ( root != null )
      {
        myViewer.setSceneGraph(root);
        myViewer.viewAll();
      }
    }

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
