package inventor.mentor.selectTimerSensor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JButton;

import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoRotation;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoTimerSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * TimerSensor example program;
 *
 * @author Loic Vigneras
 * @author Patrick Vigneras
 */

public class Main extends Example
{
  private IViewerExaminer myViewer;
  private SoTimerSensor rotatingSensor;

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Select Timer Sensor");
  }

  private URL loadURL()
  {
    Frame f = new Frame();
    FileDialog fd = new FileDialog(f, " Load a file ", FileDialog.LOAD);
    fd.setVisible(true);

    if ( fd.getFile() == null )
      return null;

    String fileName = fd.getDirectory() + fd.getFile();

    URL url = null;
    try
    {
      url = new URL("file:" + (new File(fileName)).getAbsolutePath());
    }
    catch (MalformedURLException exc)
    {
      System.err.println(exc + " : " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e)
    {
      System.err.println(e + " : File " + fileName + " not found");
      url = null;
    }
    return url;
  }

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    JButton button = new JButton("Load File");
    button.addActionListener(new ActionOnMyButton());

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(button, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  // inner classes
  class ActionOnMyButton implements ActionListener
  {
    @Override
    public void actionPerformed(ActionEvent e)
    {
      URL url_file = loadURL();
      if ( url_file == null )
        return; // cancel

      SoInput inputFile = new SoInput();
      if ( !inputFile.openURL(url_file) )
      {
        System.err.println("Could not open file " + url_file);
        return;
      }

      SoSeparator activeRoot = new SoSeparator();

      SoRotation myRotation = new SoRotation();
      activeRoot.addChild(myRotation);

      rotatingSensor = new SoTimerSensor(new RotatingSensorTask(myRotation));
      rotatingSensor.setInterval(new SbTime(1.0)); // scheduled once per second
      rotatingSensor.schedule();

      SoTimerSensor schedulingSensor = new SoTimerSensor(new SchedulingSensorTask());
      schedulingSensor.setInterval(new SbTime(5.0)); // once per 5 seconds
      schedulingSensor.schedule();

      activeRoot.addChild(SoDB.readAll(inputFile));

      myViewer.setSceneGraph(activeRoot);
      myViewer.viewAll();
    }
  }

  // inner classes to declare tasks
  class RotatingSensorTask implements Runnable
  {
    private SoRotation myRotation;

    public RotatingSensorTask(SoRotation rot)
    {
      myRotation = rot;
    }

    @Override
    public void run()
    {
      // Rotate an object...
      SbRotation currentRotation = myRotation.rotation.getValue();
      currentRotation.multiply(new SbRotation(new SbVec3f(0, 0, 1), (float) Math.PI / 90F));
      myRotation.rotation.setValue(currentRotation);
    }
  }

  class SchedulingSensorTask implements Runnable
  {
    @Override
    public void run()
    {
      // This function is called once every 5 seconds, and
      // reschedules the other sensor.
      rotatingSensor.unschedule();
      if ( rotatingSensor.getInterval().getMsecValue() == 1000 )
        rotatingSensor.setInterval(new SbTime(0.1));
      else
        rotatingSensor.setInterval(new SbTime(1.0));
      rotatingSensor.schedule();
    }
  }

  // end of inner classes declaration
}
