package inventor.mentor.text;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes. *;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * This is an example from the Inventor Mentor,
  * chapter 6, example 1.
  *
  * This example renders a globe and uses 2D text to label the
  * continents Africa and Asia.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Text");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Choose a font
    SoFont myFont = new SoFont();
    myFont.name.setValue("Times-Roman");
    myFont.size.setValue(24.0F);
    //myFont.size.setValue(.2F);

    // Add the globe, a sphere with a texture map.
    // Put it within a separator.
    SoSeparator sphereSep = new SoSeparator();
    SoTexture2 myTexture2 = new SoTexture2();
    SoComplexity sphereComplexity = new SoComplexity();
    sphereComplexity.value.setValue(0.55F);
    {
      sphereSep.addChild(myTexture2);
      sphereSep.addChild(sphereComplexity);
      sphereSep.addChild(new SoSphere());
    }

    myTexture2.filename.setValue("$OIVJHOME/data/textures/rgb/globe.rgb");

    // Add Text2 for AFRICA, translated to proper location.
    SoSeparator africaSep = new SoSeparator();
    SoTranslation africaTranslate = new SoTranslation();
    SoText2 africaText = new SoText2();
    africaTranslate.translation.setValue(.25F,.0F,1.25F);
    africaText.string.setValue("AFRICA");
    {
      africaSep.addChild(africaTranslate);
      africaSep.addChild(africaText);
    }

    // Add Text2 for ASIA, translated to proper location.
    SoSeparator asiaSep = new SoSeparator();
    SoTranslation asiaTranslate = new SoTranslation();
    SoText2 asiaText = new SoText2();
    asiaTranslate.translation.setValue(.8F,.8F,.0F);
    asiaText.string.setValue("ASIA");
    {
      asiaSep.addChild(asiaTranslate);
      asiaSep.addChild(asiaText);
    }

    SoGroup root = new SoGroup();
    { // assemble scene graph
      root.addChild(myFont);
      root.addChild(sphereSep);
      root.addChild(africaSep);
      root.addChild(asiaSep);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setName("2D Text");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
