package inventor.sample.faceSetHole.faceSetHole;

import com.openinventor.inventor.* ;
import com.openinventor.inventor.nodes.* ;

public class OivSceneGraph {
  protected SoShapeHints hints;
  protected SoGroup root;

  protected static final float vertices[][] = {
    {   0,     0, 0},
    {   1,    -1, 0},
    {   1,     1, 0},

    {0.8f,     0, 0},
    {0.3f, -0.2f, 0},
    {0.3f,  0.2f, 0},

    {   0,     0, 0},
    {   0,    -1, 0},
    {   1,    -1, 0},

    {0.6f,     0, 0},
    {0.4f, -0.9f, 0},
    {0.1f, -0.5f, 0}
  };

  // Number of vertices in each polygon:
  protected static int[] numvertices = {3, 3, 3, 3 };


  public OivSceneGraph() {
    root = makeSceneGraph();
  }

  protected SoSeparator makeSceneGraph() {
    SoSeparator result = new SoSeparator();
    hints = new SoShapeHints();
    result.addChild(hints);
    hints.windingType.setValue(SoShapeHints.WindingTypes.ODD_TYPE);
    hints.vertexOrdering.setValue(SoShapeHints.VertexOrderings.COUNTERCLOCKWISE);

    SoVertexProperty myVertexProperty = new SoVertexProperty();

    // Define material
    myVertexProperty.orderedRGBA.setValue(new SbColor(0.4f, 0, 0).getPackedValue());
    myVertexProperty.normalBinding.setValue(SoVertexProperty.Bindings.OVERALL);
    myVertexProperty.normal.set1Value(0, new SbVec3f(0, 0, 1));

    // Define colors for the faces
    int i;
    for (i=0; i<12; i++)
      myVertexProperty.orderedRGBA.set1Value(i, new SbColor(1, 0, 0).getPackedValue());

    // Define coordinates for vertices
    myVertexProperty.vertex.setValues(0, vertices);

    // Define the FaceSet
    SoFaceSet myFaceSet = new SoFaceSet();
    myFaceSet.numVertices.setValues(0, numvertices);

    myFaceSet.vertexProperty.setValue(myVertexProperty);
    result.addChild(myFaceSet);

    return result;
  }

  public void setWindingType(int wtype) {
    hints.windingType.setValue(wtype);
  }

  public SoNode getSceneGraph() {
    return root;
  }

}
