package inventor.sample.geocentricProjection;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoGeoProjection;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTexture;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.projection.SbProj4Projection;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create main separator
    SoSeparator root = new SoSeparator();

    // Create a SoGeoProjection node
    SoGeoProjection geoProjection = new SoGeoProjection();
    root.addChild(geoProjection);

    // Set the coordinate system to GEOCENTRIC
    geoProjection.coordinateSystem.setValue(SbProj4Projection.CoordinateSystems.GEOCENTRIC);

    // Choose the mollweide projection
    geoProjection.projection.setValue(SbProj4Projection.Projections.MOLLWEIDE);

    // Add the earth texture
    SoTexture2 texture = new SoTexture2();
    texture.filename.setValue("$OIVJHOME/data/textures/jpg/earth.jpg");
    texture.model.setValue(SoTexture.Models.REPLACE);
    root.addChild(texture);

    // Add the shape that is being projected. We use a sphere to
    // approximate the earth
    // We set the radius to 6371000 m (6371 km)
    SoSphere sphere = new SoSphere();
    sphere.radius.setValue(6371000);
    root.addChild(sphere);

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Geocentric projection");
  }
}
