/**
 * This example builds several lineSet to test the push/pop
 * in SoDrawStyle line pattern scale factor.
 * @author JM Godinaud
 */
package inventor.sample.linePatternScale;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  static float vertices[][] = {
    {  0.0f, 0.0f, 0.0f },
    { 10.0f, 0.0f, 0.0f }
  };

  private IViewerExaminer myViewer;

  //Main method
  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("SoDrawStyle line pattern scale factor");
  }

  SoSeparator makeLine(SbColor color, short pattern, int scaleFactor) {

    // Set the draw style for lineGroup.
    SoDrawStyle myDrawStyle = new SoDrawStyle();
    myDrawStyle.linePattern.setValue(pattern);
    myDrawStyle.linePatternScaleFactor.setValue(scaleFactor);

    // Define material for lineGroup
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(color);

    // Define coordinates for vertices
    SoCoordinate3 myCoords = new SoCoordinate3();
    myCoords.point.setValues(0, vertices);

    // Define the LineSet
    SoLineSet myLineSet = new SoLineSet();

    SoSeparator lineGroup = new SoSeparator();
    {
      lineGroup.addChild(myDrawStyle);
      lineGroup.addChild(myMaterial);
      lineGroup.addChild(myCoords);
      lineGroup.addChild(myLineSet);
    }

    return lineGroup;
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    SoTranslation translate = new SoTranslation();
    translate.translation.setValue(new SbVec3f(0,-1,0));

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(makeLine(new SbColor(1, 0, 0), (short) 0xF222, 2));

      root.addChild(translate);
      root.addChild(makeLine(new SbColor(0, 1, 0), (short) 0xF222, 4));

      root.addChild(translate);
      root.addChild(makeLine(new SbColor(0, 1, 1), (short) 0x1111, 1));

      root.addChild(translate);
      root.addChild(makeLine(new SbColor(1, 1, 1), (short) 0x1111, 3));
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}




