package inventor.sample.pattern;

import java.awt.* ;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import com.openinventor.hardcopy.SoVectorizeCGMAction;
import com.openinventor.hardcopy.SoVectorizePSAction;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPattern;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;
import util.editors.MaterialEditor;

/**
  * This is an example for the utilisation of pattern.
  */
public class Main extends Example
{

  static byte pattBuff[] = {
  (byte)0xFF,(byte)0x00,(byte)0xFF,(byte)0x00,
  (byte)0x30,(byte)0x00,(byte)0x30,(byte)0x00,
  (byte)0x18,(byte)0x00,(byte)0x18,(byte)0x00,
  (byte)0x0C,(byte)0x00,(byte)0x0C,(byte)0x00,
  (byte)0xFF,(byte)0x00,(byte)0xFF,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0xFF,(byte)0x00,(byte)0xFF,
  (byte)0x00,(byte)0x30,(byte)0x00,(byte)0x30,
  (byte)0x00,(byte)0x18,(byte)0x00,(byte)0x18,
  (byte)0x00,(byte)0x0C,(byte)0x00,(byte)0x0C,
  (byte)0x00,(byte)0xFF,(byte)0x00,(byte)0xFF,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0xFF,(byte)0x00,(byte)0xFF,(byte)0x00,
  (byte)0x30,(byte)0x00,(byte)0x30,(byte)0x00,
  (byte)0x18,(byte)0x00,(byte)0x18,(byte)0x00,
  (byte)0x0C,(byte)0x00,(byte)0x0C,(byte)0x00,
  (byte)0xFF,(byte)0x00,(byte)0xFF,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0xFF,(byte)0x00,(byte)0xFF,
  (byte)0x00,(byte)0x30,(byte)0x00,(byte)0x30,
  (byte)0x00,(byte)0x18,(byte)0x00,(byte)0x18,
  (byte)0x00,(byte)0x0C,(byte)0x00,(byte)0x0C,
  (byte)0x00,(byte)0xFF,(byte)0x00,(byte)0xFF,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
  (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00 };

  // Vertices for faceSets.
  static float vertices[][] = {
    {-1, 1, 0}, {0, 0, 0}, {0, 1, 0},
    {-1,0,0}  , {0,0,0}  , {-1,1,0}
  };
  static int numVertices[] = {3, 3};

  static protected Color UIBackgroundColor = new Color(148F/255F,174F/255F,211F/255F);
  static protected Color UIForegroundColor = Color.blue;

  MaterialEditor myMaterialEditor;
  SoSeparator root;
  SoPattern myRightPattern;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    myMaterialEditor = new MaterialEditor();

    // I want all the pattern of the file but not the first one !
    String filterNames[] = {"PATTERN N1"};

    if ( !SoPattern.loadPatterns("$OIVJHOME/data/textures/Pattern.pat", filterNames,
        SoPattern.FilterTypes.EXCLUSIVE_FILTER) )
      System.err.println("Cannot load pattern file : Pattern.pat");

    //============================ Left FaceSet ===============================
    SoTransform myTransfo = new SoTransform();
    myTransfo.translation.setValue( -1.F, 0.F, 0.F );

    SoMaterial myLeftMaterial = new SoMaterial();
    myLeftMaterial.diffuseColor.setValue( 0.F, 0.F, 1.F );

    // Pattern.
    SoPattern myLeftPattern = new SoPattern();
    myLeftPattern.category.setValue("GEOLOGY");
    myLeftPattern.name.setValue("PATTERN N4");

    SoCoordinate3 myLeftCoord = new SoCoordinate3();
    myLeftCoord.point.setValues( 0, vertices );

    SoFaceSet myLeftFaceSet = new SoFaceSet();
    myLeftFaceSet.numVertices.setValues( 0, numVertices );

    SoSeparator leftSep = new SoSeparator();
    {
      leftSep.addChild( myTransfo );
      leftSep.addChild( myLeftMaterial );
      leftSep.addChild( myLeftPattern );
      leftSep.addChild( myLeftCoord );
      leftSep.addChild( myLeftFaceSet );
    }

    //========================== Right FaceSet ==============================
    SoMaterial myRightMaterial = new SoMaterial();
    myRightMaterial.diffuseColor.setValue( 1.F, 0.F, 0.F );
    myMaterialEditor.attach( myRightMaterial );

    // The Pattern.
    SoPattern.addPattern("GEOLOGY 2","PATTERN BUFF",pattBuff );
    myRightPattern = new SoPattern();
    myRightPattern.category.setValue("GEOLOGY 2");
    myRightPattern.name.setValue( "PATTERN BUFF" );

    SoCoordinate3 myRightCoord = new SoCoordinate3();
    myRightCoord.point.setValues( 0, vertices );

    SoFaceSet myRightFaceSet = new SoFaceSet();
    myRightFaceSet.numVertices.setValues( 0, numVertices );

    SoSeparator rightSep = new SoSeparator();
    {
      rightSep.addChild( myRightMaterial );
      rightSep.addChild(myRightPattern);
      rightSep.addChild( myRightCoord );
      rightSep.addChild( myRightFaceSet );
    }

    //=======================================================================

    root = new SoSeparator();
    { // assemble scene graph
      root.addChild( leftSep );
      root.addChild( rightSep );
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setName("Pattern");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(makeUserInterface(), BorderLayout.WEST);

    // Get and print pattern names list.
    String[] names = SoPattern.getPatternNames( );
    for( int i=0; i<names.length; i++ )
      System.out.println(names[i]);
  }

  @Override
  public void stop()
  {
    myMaterialEditor.dispose();
    myViewer.dispose();
  }

  Panel makeUserInterface() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    constraint.anchor = GridBagConstraints.WEST;
    constraint.insets.bottom = 10;
    constraint.insets.top = 0;
    constraint.insets.left = 10;
    constraint.insets.right = 10;

    Label titleName = new Label("Example of Pattern");
    titleName.setForeground(UIForegroundColor);
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(titleName,constraint);

    Label patternColor = new Label("Pattern Color :");
    patternColor.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(patternColor, constraint);
    Button patternColorButton = new Button("Color");
    patternColorButton.addActionListener(new PatternColorListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(patternColorButton,constraint);

    Label patternChoice = new Label("Pattern Choice :");
    patternChoice.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(patternChoice, constraint);
    Choice choiceThePattern = new Choice();
    choiceThePattern.addItem("PATTERN BUFF");
    choiceThePattern.addItem("PATTERN N2");
    choiceThePattern.addItem("PATTERN N3");
    choiceThePattern.addItem("PATTERN N4");
    choiceThePattern.addItem("PATTERN N5");
    choiceThePattern.select(0);
    choiceThePattern.addItemListener(new PatternTypeListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceThePattern, constraint);

    Label createPS = new Label("Create a PostScript file :");
    createPS.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(createPS, constraint);
    Button printPS = new Button("Print PS");
    constraint.gridwidth = 1;
    printPS.addActionListener(new PrintPSListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(printPS, constraint);

    Label createCGM = new Label("Create a CGM file :");
    createCGM.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(createCGM, constraint);
    Button printCGM = new Button("Print CGM");
    constraint.gridwidth = 1;
    printCGM.addActionListener(new PrintCGMListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(printCGM, constraint);

    Panel leftPanel = new Panel(gridbag) {
      @Override
      public void paint(Graphics g) {
	Dimension d = getSize() ;
	g.setColor(UIForegroundColor) ;
	int margin = 1;
	g.drawRect(margin,margin, d.width-2*margin, d.height-2*margin);
      }
    };

    leftPanel.setBackground(UIBackgroundColor);
    leftPanel.add(titleName);
    leftPanel.add(patternColor);
    leftPanel.add(patternColorButton);
    leftPanel.add(patternChoice);
    leftPanel.add(choiceThePattern);

    leftPanel.add(createPS);
    leftPanel.add(printPS);
    leftPanel.add(createCGM);
    leftPanel.add(printCGM);

    return leftPanel;
  }

  class PatternTypeListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      Choice c = (Choice)e.getSource();
      switch (c.getSelectedIndex()) {
      case 0:
        myRightPattern.category.setValue("GEOLOGY 2");
	myRightPattern.name.setValue( "PATTERN BUFF" );
	break;
      case 1:
	myRightPattern.category.setValue("GEOLOGY");
	myRightPattern.name.setValue( "PATTERN N2" );
	break;
      case 2:
	myRightPattern.category.setValue("GEOLOGY");
	myRightPattern.name.setValue( "PATTERN N3" );
	break;
      case 3:
	myRightPattern.category.setValue("GEOLOGY");
	myRightPattern.name.setValue( "PATTERN N4" );
	break;
      case 4:
	myRightPattern.category.setValue("GEOLOGY");
	myRightPattern.name.setValue( "PATTERN N6" );
	break;
      }
    }
  }
  class PatternColorListener implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
      myMaterialEditor.setVisible(!myMaterialEditor.isShowing());
    }
  }
  class PrintPSListener implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
      SoVectorizePSAction vectPSAction = new SoVectorizePSAction();
      vectPSAction.getPSVectorOutput().openFile("PatternOutput.ps");
      System.out.println("Begin Printing...");
      vectPSAction.apply(root);
      System.out.println("End");
      vectPSAction.getPSVectorOutput().closeFile();
    }
  }
  class PrintCGMListener implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
      SbColor[] colors = new SbColor[4];
      colors[0] = new SbColor(0, 0, 0 );
      colors[1] = new SbColor(1, 0, 0 );
      colors[2] = new SbColor(0, 1, 0 );
      colors[3] = new SbColor(0, 0, 1 );

      SoVectorizeCGMAction vectCGMAction = new SoVectorizeCGMAction();
      vectCGMAction.getCGMVectorOutput().openFile("PatternOutput.cgm") ;
      System.out.println("Begin Printing...") ;
      //      vectCGMAction.getOutput().setIndexed( true );
      //      vectCGMAction.setPenDescription( 4, colors  );
      vectCGMAction.getCGMVectorOutput().setBinary( true );
      vectCGMAction.apply(root) ;
      System.out.println("End") ;
      vectCGMAction.getCGMVectorOutput().closeFile() ;
    }
  }

  public static void main( String argv[] ) {
    Main example = new Main();
    example.demoMain("Pattern");
  }
}
