package inventor.sample.wellBore;

import java.io.*;

import com.openinventor.inventor.SbVec3f;

// Class to store a simple "well bore" data set.
public class WellBore
{
  // 3D coordinate of each data point
  public SbVec3f[] points;

  // Smallest data value
  public float dataMin;

  // Largest data value
  public float dataMax;

  // First set of data values
  public float[] data0;

  // (Optional) Second set of data values
  public float[] data1;

  public int getNumPoints()
  {
    return points.length;
  }

  public void setData1(float[] data1)
  {
    this.data1 = data1;
  }

  public void setData1(int i, float data)
  {
    this.data1[i] = data;
  }

  public float[] getData0()
  {
    return data0;
  }

  public float getData0(int i)
  {
    return data0[i];
  }

  public float[] getData1()
  {
    return data1;
  }

  public SbVec3f[] getPoints()
  {
    return points;
  }

  public float getData1(int i)
  {
    return data1[i];
  }

  public WellBore()
  {
    dataMin = 0;
    dataMax = 1;
  }

  // Read a "well bore" data set from a simple file format
  // Careful... this code is fragile... only an example!
  static public WellBore createFromFile(String fileName)
  {
    File file = new File(fileName);
    if ( !file.exists() )
    {
      System.err.println("*** Unable to open data file " + fileName);
      return null;
    }

    WellBore well = new WellBore();

    int nPoints = 0;

    BufferedReader reader;
    try
    {
      reader = new BufferedReader(new FileReader(file));
      String line = null;
      while ( (line = reader.readLine()) != null )
      {
        if ( line.startsWith("#") || (line.length() == 0) )
          continue;

        if ( line.startsWith("nVertices ") )
          nPoints = Integer.parseInt(line.substring(10));

        if ( line.startsWith("Coords") )
        {
          well.points = new SbVec3f[nPoints];

          for ( int i = 0; i < nPoints; ++i )
          {
            String[] t = reader.readLine().split(" ");
            well.points[i] = new SbVec3f();
            well.points[i].setValue(Float.parseFloat(t[0]), Float.parseFloat(t[1]), Float.parseFloat(t[2]));
          }
        }

        if ( line.startsWith("Data") )
        {
          well.data0 = new float[nPoints];
          for ( int i = 0; i < nPoints; ++i )
            well.data0[i] = Float.parseFloat(reader.readLine());
        }
      }

      // We happen to know the range for the data in this example
      well.dataMin = 0.0f;
      well.dataMax = 255.0f;

      reader.close();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    return well;
  }
}
